/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.server;

import java.io.IOException;
import java.net.Socket;
import java.nio.channels.Channel;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import weblogic.nodemanager.NodeManagerTextTextFormatter;
import weblogic.nodemanager.server.Handler;
import weblogic.nodemanager.server.Listener;
import weblogic.nodemanager.server.NMServer;
import weblogic.nodemanager.server.SSLConfig;
import weblogic.security.utils.SSLContextWrapper;
import weblogic.security.utils.SSLTrustValidator;

class SSLListener
extends Listener {
    SSLContextWrapper sslContext;
    SSLConfig sslConfig;
    SSLSocketFactory cltFactory;
    private static final NodeManagerTextTextFormatter nmText = NodeManagerTextTextFormatter.getInstance();

    SSLListener(NMServer nMServer, Channel channel) throws IOException {
        super(nMServer, channel);
    }

    public void init() throws IOException {
        try {
            this.sslContext = SSLContextWrapper.getInstance();
            this.sslConfig = this.server.getSSLConfig();
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError("Could not instantiate SSLContextWrapper").initCause(exception);
        }
        PrivateKey privateKey = this.sslConfig.getIdentityPrivateKey();
        X509Certificate[] x509CertificateArray = this.sslConfig.getIdentityCertificateChain();
        this.sslContext.addIdentity(x509CertificateArray, privateKey);
        SSLTrustValidator sSLTrustValidator = new SSLTrustValidator();
        sSLTrustValidator.setPeerCertsRequired(false);
        sSLTrustValidator.setAllowOverride(false);
        this.sslContext.setTrustManager(sSLTrustValidator);
        this.sslContext.setExportRefreshCount(500);
        SSLServerSocketFactory sSLServerSocketFactory = this.sslContext.getSSLServerSocketFactory();
        if (this.inheritedChannel != null) {
            this.cltFactory = this.sslContext.getSSLSocketFactory();
            return;
        }
        SSLServerSocket sSLServerSocket = this.host != null ? (SSLServerSocket)sSLServerSocketFactory.createServerSocket(this.port, this.backlog, this.host) : (SSLServerSocket)sSLServerSocketFactory.createServerSocket(this.port, this.backlog);
        String string = this.sslConfig.getCipherSuite();
        if (string != null) {
            sSLServerSocket.setEnabledCipherSuites(new String[]{string});
            if (!sSLServerSocket.getEnabledCipherSuites()[0].equals(string)) {
                throw new IOException(nmText.getUnsupportedCipher(string));
            }
        }
        sSLServerSocket.setNeedClientAuth(false);
        this.serverSocket = sSLServerSocket;
    }

    public void run() throws IOException {
        String string = this.host != null ? nmText.getSecureSocketListenerHost(Integer.toString(this.port), this.host.toString()) : nmText.getSecureSocketListener(Integer.toString(this.port));
        NMServer.nmLog.info(string);
        while (true) {
            try {
                while (true) {
                    Object object;
                    Object object2;
                    Object object3;
                    if ((object3 = this.serverSocket.accept()) == null) {
                        continue;
                    }
                    if (this.inheritedChannel != null) {
                        object2 = (SSLSocket)this.cltFactory.createSocket((Socket)object3, ((Socket)object3).getInetAddress().getHostName(), ((Socket)object3).getLocalPort(), true);
                        NMServer.nmLog.info(nmText.upgradeToSecure());
                        object = this.sslConfig.getCipherSuite();
                        if (object != null) {
                            ((SSLSocket)object2).setEnabledCipherSuites(new String[]{object});
                            if (!((SSLSocket)object2).getEnabledCipherSuites()[0].equals(object)) {
                                throw new IOException(nmText.getUnsupportedCipher((String)object));
                            }
                        }
                        ((SSLSocket)object2).setUseClientMode(false);
                        ((SSLSocket)object2).setNeedClientAuth(false);
                        try {
                            ((SSLSocket)object2).startHandshake();
                        }
                        catch (IOException iOException) {
                            if (!((Socket)object2).isClosed()) {
                                try {
                                    ((Socket)object2).close();
                                }
                                catch (IOException iOException2) {
                                    // empty catch block
                                }
                            }
                            throw iOException;
                        }
                        object3 = object2;
                    }
                    object2 = new Handler(this.server, (Socket)object3);
                    object = new Thread((Runnable)object2);
                    ((Thread)object).start();
                }
            }
            catch (IOException iOException) {
                NMServer.nmLog.warning(nmText.getFailedSecureConnection(Integer.toString(this.port), this.host.toString()) + "" + iOException);
                continue;
            }
            break;
        }
    }
}

