/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.server;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import weblogic.nodemanager.common.ConfigException;
import weblogic.nodemanager.common.ServerType;
import weblogic.nodemanager.common.StartupConfig;
import weblogic.nodemanager.server.AbstractServerManager;
import weblogic.nodemanager.server.DomainManager;
import weblogic.nodemanager.server.NMServer;
import weblogic.nodemanager.server.NetworkInfo;
import weblogic.nodemanager.server.ServerDir;
import weblogic.nodemanager.server.ServerMonitor;
import weblogic.nodemanager.server.ServerMonitorI;
import weblogic.nodemanager.server.WLSProcess;
import weblogic.nodemanager.system.NodeManagerSystem;
import weblogic.nodemanager.util.ConcurrentFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerManager
extends AbstractServerManager {
    private final NMServer nmServer;
    private static final String RES1 = "bea_wls_management_internal2";
    private static final String RES2 = "bea_wls_management_internal2/wl_management";

    public ServerManager(DomainManager domainManager, String string) throws ConfigException, IOException {
        super(domainManager, string, ServerType.WebLogic);
        this.nmServer = domainManager.getNMServer();
    }

    @Override
    protected ServerMonitorI createServerMonitor(StartupConfig startupConfig) {
        return new ServerMonitor(this, startupConfig);
    }

    @Override
    protected boolean canPingServer(ServerDir serverDir) {
        ConcurrentFile concurrentFile = serverDir.getURLFile();
        if (!concurrentFile.exists()) {
            this.log(Level.FINEST, "No URL File exists");
            return false;
        }
        String string = null;
        try {
            String string2 = concurrentFile.readLine();
            if (string2 == null) {
                return false;
            }
            string = string2.endsWith("/") ? string2 + RES2 : string2 + "/" + RES2;
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setUseCaches(false);
            httpURLConnection.connect();
            int n = httpURLConnection.getResponseCode();
            httpURLConnection.disconnect();
            this.log(Level.FINEST, "The wls URL was available :" + string + ", responded with code:" + n);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            this.log(Level.FINEST, "The wls URL was unavailable :" + string + " with " + malformedURLException);
            return false;
        }
        catch (IOException iOException) {
            this.log(Level.FINEST, "The wls URL was unavailable :" + string + " with " + iOException);
            return false;
        }
    }

    public boolean isAdminServer() throws ConfigException, IOException {
        StartupConfig startupConfig = this.loadStartupConfig();
        return startupConfig.getAdminURL() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isCrashRecoveryNeeded(StartupConfig startupConfig) throws IOException {
        if (this.domainMgr.getNMServer().getConfig().isDomainsDirRemoteSharingEnabled() && startupConfig.getNMHostName() != null && !this.isStartedByNMConfigured(startupConfig)) {
            this.domainDirShared = true;
            return false;
        }
        if (startupConfig.getAdminURL() == null) {
            this.log(Level.INFO, nmText.getRecoveringServerProcess());
            this.startServer();
            ServerMonitorI serverMonitorI = this.monitor;
            synchronized (serverMonitorI) {
                while (!this.monitor.isStarted() && !this.monitor.isFinished()) {
                    try {
                        this.monitor.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw (IOException)new IOException(nmText.getServerFailedToStart()).initCause(interruptedException);
                    }
                }
                if (!this.monitor.isStarted() || this.monitor.isStartupAborted()) {
                    throw new IOException(nmText.getServerFailedToStart());
                }
            }
            return false;
        }
        return true;
    }

    @Override
    protected List<WLSProcess.ExecuteCallbackHook> getStartCallbacks(StartupConfig startupConfig) throws IOException {
        ArrayList<WLSProcess.ExecuteCallbackHook> arrayList = new ArrayList<WLSProcess.ExecuteCallbackHook>();
        if (this.isIPForBinding(startupConfig)) {
            for (String string : startupConfig.getServerIPList()) {
                NetworkInfo networkInfo = this.nmServer.getConfig().getNetworkInfoFor(string);
                arrayList.add(NodeManagerSystem.getInstance().createBindIPHook(this.serverName, string, networkInfo.getInterfaceName(), networkInfo.getNetMask(), this.domainMgr.getDomainDir().getServerDir(this.serverName).getPath(), this.getIfConfigScriptDir(), this.nmServer.getConfig().useMACBroadcast()));
            }
        }
        return arrayList;
    }

    @Override
    protected List<WLSProcess.ExecuteCallbackHook> getStopCallbacks(StartupConfig startupConfig) throws IOException {
        ArrayList<WLSProcess.ExecuteCallbackHook> arrayList = new ArrayList<WLSProcess.ExecuteCallbackHook>();
        if (this.isIPForBinding(startupConfig)) {
            for (String string : startupConfig.getServerIPList()) {
                NetworkInfo networkInfo = this.nmServer.getConfig().getNetworkInfoFor(string);
                arrayList.add(NodeManagerSystem.getInstance().createUnbindIPHook(this.serverName, string, networkInfo.getInterfaceName(), this.domainMgr.getDomainDir().getServerDir(this.serverName).getPath(), this.getIfConfigScriptDir()));
            }
        }
        return arrayList;
    }

    @Override
    protected StartupConfig createStartupConfig(Properties properties) throws ConfigException {
        return new StartupConfig(properties);
    }

    private String getIfConfigScriptDir() {
        String string = this.nmServer.getConfig().getIfConfigDir();
        if (string != null) {
            return string;
        }
        return this.domainMgr.getDomainDir().getIfConfigDir();
    }

    private boolean isIPForBinding(StartupConfig startupConfig) {
        if (startupConfig == null) {
            this.log(Level.WARNING, "The server manager for " + this.serverName + " is not initialized");
            return false;
        }
        return startupConfig.getServerIPList() != null && !startupConfig.getServerIPList().isEmpty();
    }

    private boolean isStartedByNMConfigured(StartupConfig startupConfig) {
        return this.getNMHostName().equals(startupConfig.getNMHostName());
    }
}

