/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.server;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import weblogic.nodemanager.NodeManagerTextTextFormatter;
import weblogic.nodemanager.common.ConfigException;
import weblogic.nodemanager.server.Encryptor;
import weblogic.nodemanager.server.NMProperties;
import weblogic.nodemanager.server.NMServerConfig;
import weblogic.nodemanager.server.SSLConfig;
import weblogic.security.Salt;
import weblogic.security.internal.encryption.EncryptionServiceException;
import weblogic.security.internal.encryption.JSafeEncryptionServiceFactory;
import weblogic.utils.Hex;

public class Upgrader {
    private NMServerConfig conf;
    private static Logger nmLog = Logger.getLogger("weblogic.nodemanager");
    byte[] salt;
    byte[] key;
    private static final NodeManagerTextTextFormatter nmText = NodeManagerTextTextFormatter.getInstance();

    public Upgrader(NMServerConfig nMServerConfig) {
        this.conf = nMServerConfig;
    }

    public static void upgrade(NMServerConfig nMServerConfig) throws ConfigException, IOException {
        new Upgrader(nMServerConfig).upgrade();
    }

    public void upgrade() throws ConfigException, IOException {
        this.upgradeDataProperties();
        this.upgradeConfigProperties();
    }

    private void loadDataProperties(File file) throws IOException {
        String string;
        NMProperties nMProperties = new NMProperties();
        nMProperties.load(file);
        String string2 = nMProperties.getProperty("nameHashKey");
        if (string2 == null) {
            string2 = nMProperties.getProperty("nameHashkey");
        }
        if ((string = nMProperties.getProperty("idHashKey")) == null) {
            string = nMProperties.getProperty("idHashkey");
        }
        if (string2 == null || string == null) {
            throw new IOException(nmText.getInvalidDataFile(file.toString()));
        }
        byte[] byArray = string2.getBytes();
        byte[] byArray2 = string.getBytes();
        this.salt = Hex.fromHexString((byte[])byArray, (int)byArray.length);
        this.key = Hex.fromHexString((byte[])byArray2, (int)byArray2.length);
    }

    public void upgradeDataProperties() {
        File file = new File(this.conf.getNMHome());
        File file2 = new File(file, "nm_data.properties");
        if (file2.exists()) {
            return;
        }
        File file3 = new File(file, "SerializedNodeManagerIni.dat");
        if (!file3.exists()) {
            file3 = new File(file, "NodeManagerProperties");
            if (!file3.exists()) {
                return;
            }
            try {
                byte[] byArray;
                this.loadDataProperties(file3);
                byte[] byArray2 = this.salt;
                byte[] byArray3 = this.key;
                JSafeEncryptionServiceFactory jSafeEncryptionServiceFactory = new JSafeEncryptionServiceFactory();
                byte[] byArray4 = Salt.getRandomBytes(4);
                try {
                    byArray = jSafeEncryptionServiceFactory.reEncryptEncryptedSecretKey(byArray3, byArray2, byArray4, "0x194ce8ab97302f33a77c82de564091f1ac4873be", "0x1f48730ab4957122fccb2856671df094bcc294af");
                }
                catch (EncryptionServiceException encryptionServiceException) {
                    String string = "password";
                    if (this.conf != null && ((string = this.conf.getConfigProperties().getProperty("keyPassword")) == null || string.equals(""))) {
                        string = "password";
                    }
                    byArray = jSafeEncryptionServiceFactory.reEncryptEncryptedSecretKey(byArray3, byArray2, byArray4, string, "0x1f48730ab4957122fccb2856671df094bcc294af");
                }
                NMProperties nMProperties = new NMProperties();
                nMProperties.setProperty("nameHashKey", Hex.asHex((byte[])byArray4, (int)byArray4.length));
                nMProperties.setProperty("idHashKey", Hex.asHex((byte[])byArray, (int)byArray.length));
                nMProperties.save(file2, null);
                file3.delete();
                Upgrader.log(Level.INFO, nmText.getNMDataPropsMigrated(file3.toString(), file2.toString()));
            }
            catch (Throwable throwable) {
                Upgrader.log(Level.INFO, nmText.getNMDataPropsMigrateError(file3.toString(), file2.toString()), throwable);
            }
        } else {
            Upgrader.log(Level.INFO, nmText.getNMDataPropsRenamed(file3.toString(), file2.toString()));
            if (!file3.renameTo(file2)) {
                Upgrader.log(Level.WARNING, nmText.getNMDataPropsRenameError(file3.toString()));
            }
        }
    }

    private void upgradeConfigProperties() throws ConfigException, IOException {
        File file = new File(this.conf.getNMHome());
        NMProperties nMProperties = new NMProperties();
        File file2 = new File(file, "nodemanager.properties");
        if (!file2.exists()) {
            return;
        }
        nMProperties.loadWithComments(file2);
        boolean bl = NMServerConfig.checkUpgrade(nMProperties, true);
        boolean bl2 = bl = SSLConfig.checkUpgrade(nMProperties, new Encryptor(this.conf), true) || bl;
        if (bl) {
            Upgrader.log(Level.INFO, nmText.getSavingUpgradedProps(file2.toString()));
            nMProperties.saveWithComments(file2);
        }
    }

    public static void log(Level level, String string, Throwable throwable) {
        LogRecord logRecord = new LogRecord(level, string);
        logRecord.setParameters(new String[]{"Upgrade"});
        if (throwable != null) {
            logRecord.setThrown(throwable);
        }
        nmLog.log(logRecord);
    }

    public static void log(Level level, String string) {
        Upgrader.log(level, string, null);
    }

    public static void upgrade(File file, boolean bl) throws ConfigException, IOException {
        if (!(file = file.getAbsoluteFile()).exists() || !file.isDirectory()) {
            throw new IOException(nmText.getNMDirError(file.toString()));
        }
        NMProperties nMProperties = new NMProperties();
        File file2 = new File(file, "nodemanager.properties");
        if (file2.exists()) {
            nMProperties.load(file2);
        }
        nMProperties.setProperty("NodeManagerHome", file.getPath());
        if (bl) {
            nMProperties.setProperty("LogLevel", "ALL");
            nMProperties.setProperty("LogToStderr", "true");
        }
        NMServerConfig nMServerConfig = new NMServerConfig(nMProperties);
        Upgrader.log(Level.INFO, nmText.getUpgradeStarted(file.toString()));
        new Upgrader(nMServerConfig).upgrade();
    }

    public static void main(String[] stringArray) throws Throwable {
        boolean bl = false;
        int n = 0;
        File file = new File(".");
        if ("-v".equals(stringArray[0]) || "-verbose".equals(stringArray[0])) {
            bl = true;
            ++n;
        }
        if (stringArray.length > n) {
            file = new File(stringArray[0]);
            ++n;
        }
        if (stringArray.length != n) {
            throw new IllegalArgumentException("Usage: java weblogic.nodemanager.server.Upgrader [-v] [dir]");
        }
        Upgrader.upgrade(file, bl);
    }
}

