/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import weblogic.nodemanager.NodeManagerTextTextFormatter;
import weblogic.nodemanager.server.DomainDir;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.utils.encoders.BASE64Encoder;

public class UserInfo {
    private byte[] salt;
    private String hash;
    private boolean saveNeeded;
    public static final String USERNAME_PROP = "username";
    public static final String PASSWORD_PROP = "password";
    public static final String HASHED_PROP = "hashed";
    private static final String HASH_ALGORITHM = "SHA-256";
    private static final String OLD_HASH_ALGORITHM = "SHA";
    private static final String HASH_ALGORITHM_TAG = "{Algorithm=SHA-256}";
    private static final String HEADER = "Node manager user information";
    private long timestamp = -1L;
    private File userFile;
    private static final NodeManagerTextTextFormatter nmText = NodeManagerTextTextFormatter.getInstance();

    public UserInfo(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            this.salt = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.salt, 0, byArray.length);
        }
    }

    public UserInfo(DomainDir domainDir) throws IOException {
        File file = domainDir.getSaltFile();
        if (!file.exists() && !(file = domainDir.getOldSaltFile()).exists()) {
            throw new FileNotFoundException(nmText.getDomainSaltFileNotFound());
        }
        this.salt = UserInfo.loadSalt(file);
    }

    public synchronized boolean verify(String string, String string2) {
        if (this.hash == null) {
            throw new IllegalStateException("Must set username and password first");
        }
        if (this.timestamp <= this.userFile.lastModified() && this.userFile.canRead()) {
            try {
                this.load(this.userFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String string3 = null;
        string3 = this.hash.startsWith(HASH_ALGORITHM_TAG) ? HASH_ALGORITHM_TAG + UserInfo.hash(HASH_ALGORITHM, this.salt, string, string2) : UserInfo.hash(OLD_HASH_ALGORITHM, this.salt, string, string2);
        return this.hash.equals(string3);
    }

    public synchronized void set(String string, String string2) {
        this.hash = HASH_ALGORITHM_TAG + UserInfo.hash(HASH_ALGORITHM, this.salt, string, string2);
    }

    String getHash() {
        return this.hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(File file) throws IOException {
        Object object;
        if (this.timestamp > 0L && this.timestamp >= file.lastModified()) {
            return;
        }
        this.userFile = file;
        Properties properties = new Properties();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        FileChannel fileChannel = randomAccessFile.getChannel();
        FileLock fileLock = null;
        try {
            fileLock = fileChannel.lock(0L, file.length(), true);
            object = new RandomAccessFileInputStream(randomAccessFile);
            try {
                properties.load((InputStream)object);
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                ((InputStream)object).close();
                if (fileLock != null) {
                    fileLock.release();
                }
                throw throwable;
            }
            ((InputStream)object).close();
            if (fileLock != null) {
                fileLock.release();
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            fileChannel.close();
            randomAccessFile.close();
            throw throwable;
        }
        fileChannel.close();
        randomAccessFile.close();
        object = properties.getProperty(USERNAME_PROP);
        String string = properties.getProperty(PASSWORD_PROP);
        if (object != null && string != null) {
            this.set((String)object, string);
            this.saveNeeded = true;
        } else {
            this.hash = properties.getProperty(HASHED_PROP);
            if (this.hash == null) {
                throw new IllegalStateException(nmText.credentialsFileEmpty());
            }
            this.saveNeeded = false;
        }
        this.timestamp = file.lastModified();
    }

    public synchronized boolean saveNeeded() {
        return this.saveNeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save(File file) throws IOException {
        Properties properties = new Properties();
        properties.setProperty(HASHED_PROP, this.hash);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rws");
        FileChannel fileChannel = randomAccessFile.getChannel();
        try {
            FileLock fileLock = fileChannel.lock(0L, file.length(), false);
            RandomAccessFileOutputStream randomAccessFileOutputStream = new RandomAccessFileOutputStream(randomAccessFile);
            try {
                properties.store(new RandomAccessFileOutputStream(randomAccessFile), HEADER);
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                randomAccessFileOutputStream.close();
                if (fileLock != null) {
                    fileLock.release();
                }
                throw throwable;
            }
            randomAccessFileOutputStream.close();
            if (fileLock != null) {
                fileLock.release();
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            fileChannel.close();
            randomAccessFile.close();
            throw throwable;
        }
        fileChannel.close();
        randomAccessFile.close();
        this.timestamp = file.lastModified();
        this.userFile = file;
    }

    private static String hash(String string, byte[] byArray, String string2, String string3) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw (InternalError)new InternalError(string + " digest algorithm not found").initCause(noSuchAlgorithmException);
        }
        messageDigest.update(byArray);
        messageDigest.update(string2.getBytes());
        messageDigest.update(string3.getBytes());
        return new BASE64Encoder().encodeBuffer(messageDigest.digest());
    }

    private static byte[] loadSalt(File file) throws IOException {
        try {
            return SerializedSystemIni.getSalt(file.getPath());
        }
        catch (RuntimeException runtimeException) {
            throw (IOException)new IOException(runtimeException.getMessage()).initCause(runtimeException);
        }
    }

    private static class RandomAccessFileOutputStream
    extends OutputStream {
        RandomAccessFile raf;

        RandomAccessFileOutputStream(RandomAccessFile randomAccessFile) {
            this.raf = randomAccessFile;
        }

        public void write(int n) throws IOException {
            this.raf.write(n);
        }
    }

    private static class RandomAccessFileInputStream
    extends InputStream {
        RandomAccessFile raf;

        RandomAccessFileInputStream(RandomAccessFile randomAccessFile) {
            this.raf = randomAccessFile;
        }

        public int read() throws IOException {
            return this.raf.read();
        }
    }
}

