/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.server;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import weblogic.nodemanager.common.StartupConfig;
import weblogic.nodemanager.server.DomainDir;
import weblogic.nodemanager.server.DomainManager;
import weblogic.nodemanager.server.NMServerConfig;
import weblogic.nodemanager.server.ServerDir;
import weblogic.nodemanager.server.ServerManagerI;
import weblogic.nodemanager.server.WLSProcess;
import weblogic.nodemanager.server.WLSProcessImpl;
import weblogic.nodemanager.server.WLSProcessNativeImpl;
import weblogic.nodemanager.system.NodeManagerSystem;
import weblogic.nodemanager.util.Platform;
import weblogic.nodemanager.util.ProcessControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WLSProcessBuilder {
    private ServerManagerI serverMgr;
    private StartupConfig conf;
    private String[] cmdLine;
    private Map<String, String> environment;
    private File directory;
    private File outFile;
    private ProcessControl processCtrl;
    private boolean stopCommand = false;
    public static final String CLASSPATH_ENV = "CLASSPATH";
    public static final String ADMIN_URL_ENV = "ADMIN_URL";
    public static final String JAVA_VENDOR_ENV = "JAVA_VENDOR";
    public static final String JAVA_HOME_ENV = "JAVA_HOME";
    public static final String JAVA_OPTIONS_ENV = "JAVA_OPTIONS";
    public static final String SERVER_NAME_ENV = "SERVER_NAME";
    public static final String SERVER_IP_ENV = "SERVER_IP";
    public static final String SECURITY_POLICY_ENV = "SECURITY_POLICY";
    private static final String PATH_ENV = "PATH";
    private static final String LANG_ENV = "LANG";
    private static final String WL_HOME_ENV = "WL_HOME";
    private static final String BEA_HOME_ENV = "BEA_HOME";
    public static final String SERVICE_ENABLED_PROP = "weblogic.nodemanager.ServiceEnabled";

    public WLSProcessBuilder(String[] stringArray, Map map, File file, File file2) {
        this.cmdLine = stringArray;
        this.environment = map;
        this.directory = file;
        this.outFile = file2;
    }

    public WLSProcessBuilder(ServerManagerI serverManagerI, StartupConfig startupConfig) {
        this(serverManagerI, startupConfig, false);
    }

    public WLSProcessBuilder(ServerManagerI serverManagerI, StartupConfig startupConfig, boolean bl) {
        this.serverMgr = serverManagerI;
        this.conf = startupConfig;
        this.stopCommand = bl;
        DomainManager domainManager = serverManagerI.getDomainManager();
        NMServerConfig nMServerConfig = domainManager.getNMServer().getConfig();
        if (bl || nMServerConfig.isStartScriptEnabled()) {
            this.cmdLine = this.getScriptCommandLine();
            this.environment = this.getScriptEnvironment();
        } else {
            this.cmdLine = this.getJavaCommandLine();
        }
        this.directory = domainManager.getDomainDir();
        this.outFile = this.serverMgr.getServerDir().getOutFile();
        this.processCtrl = nMServerConfig.getProcessControl();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WLSProcess createProcess() throws IOException {
        WLSProcess wLSProcess = null;
        if (this.processCtrl == null) return new WLSProcessImpl(this.cmdLine, this.environment, this.directory, this.outFile);
        File file = new File(this.cmdLine[0]);
        if (!file.exists() && file.getName().lastIndexOf(46) < 0 && Platform.isWindows()) {
            file = new File(this.cmdLine[0] + ".exe");
        }
        if (!file.exists()) throw new IOException("Executable " + this.cmdLine[0] + " does not exist");
        return new WLSProcessNativeImpl(this.processCtrl, this.cmdLine, this.environment, this.directory, this.outFile);
    }

    public WLSProcess createProcess(String string) throws IOException {
        if (this.processCtrl != null) {
            return new WLSProcessNativeImpl(this.processCtrl, string);
        }
        throw new IllegalStateException("Native process control unavailable");
    }

    public String[] getCommandLine() {
        String[] stringArray = new String[this.cmdLine.length];
        System.arraycopy(this.cmdLine, 0, stringArray, 0, this.cmdLine.length);
        return stringArray;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public File getDirectory() {
        return this.directory;
    }

    public File getOutFile() {
        return this.outFile;
    }

    public ProcessControl getProcessControl() {
        return this.processCtrl;
    }

    public boolean isNative() {
        return this.processCtrl != null;
    }

    String[] getJavaCommandLine() {
        return this.getJavaCommandLine(this.serverMgr, this.conf);
    }

    String[] getJavaCommandLine(ServerManagerI serverManagerI, StartupConfig startupConfig) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = startupConfig.getJavaHome();
        if (string == null) {
            string = System.getProperty("java.home");
        }
        arrayList.add(string + File.separator + "bin" + File.separator + "java");
        arrayList.add("-Dweblogic.Name=" + serverManagerI.getServerName());
        string = startupConfig.getBeaHome();
        if (string == null) {
            string = System.getProperty("bea.home");
        }
        if (string != null) {
            arrayList.add("-Dbea.home=" + string);
        }
        if ((string = startupConfig.getSecurityPolicyFile()) == null) {
            string = System.getProperty("java.security.policy");
        }
        arrayList.add("-Djava.security.policy=" + string);
        string = startupConfig.getAdminURL();
        if (string != null) {
            arrayList.add("-Dweblogic.management.server=" + string);
        }
        if ((string = System.getProperty("java.library.path")) != null) {
            arrayList.add("-Djava.library.path=" + Platform.preparePathForCommand((String)string));
        }
        String string2 = System.getProperty("java.class.path");
        string = startupConfig.getClassPath();
        string = string == null ? string2 : Platform.parseClassPath((String)string, (String)string2);
        arrayList.add("-Djava.class.path=" + Platform.preparePathForCommand((String)string));
        arrayList.addAll(this.getJavaOptions());
        string = startupConfig.getSSLArguments();
        if (string != null) {
            arrayList.addAll(this.toOptionsList(string));
        }
        if ((string = startupConfig.getArguments()) != null) {
            arrayList.addAll(this.toOptionsList(string));
        }
        arrayList.add("weblogic.Server");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    String[] getScriptCommandLine() {
        ArrayList<String> arrayList = new ArrayList<String>();
        DomainManager domainManager = this.serverMgr.getDomainManager();
        DomainDir domainDir = domainManager.getDomainDir();
        String string = this.stopCommand ? domainManager.getNMServer().getConfig().getStopScriptName() : domainManager.getNMServer().getConfig().getStartScriptName();
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(new File((File)domainDir, "bin"), string);
        }
        arrayList.add(file.getPath());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    Map<String, String> getScriptEnvironment() {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(System.getenv());
        hashMap.put(SERVER_NAME_ENV, this.serverMgr.getServerName());
        String string2 = this.conf.getJavaVendor();
        if (string2 != null) {
            hashMap.put(JAVA_VENDOR_ENV, string2);
        }
        if ((string2 = this.conf.getJavaHome()) != null) {
            hashMap.put(JAVA_HOME_ENV, string2);
        }
        String string3 = this.toOptionsString(this.getJavaOptions());
        string2 = this.conf.getSSLArguments();
        if (string2 != null) {
            string3 = string3 + ' ' + string2;
        }
        if ((string2 = this.conf.getArguments()) != null) {
            string3 = string3 + ' ' + string2;
        }
        if ((string = this.conf.getTransientScriptEnv()) != null) {
            hashMap.putAll(this.getTransientScriptMap(string));
        }
        if ((string2 = this.conf.getSecurityPolicyFile()) != null) {
            hashMap.put(SECURITY_POLICY_ENV, string2);
        }
        hashMap.put(JAVA_OPTIONS_ENV, string3);
        string2 = this.conf.getClassPath();
        if (string2 != null) {
            hashMap.put(CLASSPATH_ENV, string2);
        }
        if ((string2 = this.conf.getAdminURL()) != null) {
            hashMap.put(ADMIN_URL_ENV, string2);
        }
        return hashMap;
    }

    private Map<String, String> getTransientScriptMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("=");
            if (n < 1 || n > string2.length() - 1) {
                throw new AssertionError((Object)("This property is not formed correctly and will be ignored: " + string2));
            }
            String string3 = string2.substring(0, string2.indexOf("="));
            String string4 = string2.substring(string2.indexOf("=") + 1, string2.length());
            if (string3 == null || string3.length() == 0 || string4 == null || string4.length() == 0) {
                throw new AssertionError((Object)("Missing either a name or a value for: " + string3 + " : " + string4));
            }
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    private static Map inheritedEnv() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (Platform.isUnix()) {
            String[] stringArray;
            String string = System.getenv(PATH_ENV);
            if (string != null && string.length() > 0) {
                stringArray = new String[]{System.getenv(WL_HOME_ENV), System.getenv(BEA_HOME_ENV), System.getenv(JAVA_HOME_ENV)};
                String string2 = String.valueOf(File.pathSeparatorChar);
                StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
                StringBuilder stringBuilder = new StringBuilder();
                block0: while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i] != null && stringArray[i].length() > 0 && string3.startsWith(stringArray[i])) continue block0;
                    }
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(string2);
                    }
                    stringBuilder.append(string3.trim());
                }
                if (stringBuilder.length() > 0) {
                    hashMap.put(PATH_ENV, stringBuilder.toString());
                }
            }
            if ((stringArray = System.getenv(LANG_ENV)) != null && stringArray.length() > 0) {
                hashMap.put(LANG_ENV, stringArray);
            }
        }
        return hashMap;
    }

    private List<String> getJavaOptions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ServerDir serverDir = this.serverMgr.getServerDir();
        File file = serverDir.getNMBootIdentityFile();
        if (!file.exists()) {
            file = serverDir.getBootIdentityFile();
        }
        if (file.exists()) {
            arrayList.add("-Dweblogic.system.BootIdentityFile=" + file);
        }
        arrayList.addAll(NodeManagerSystem.getInstance().getAdditionalProcessArgs());
        return arrayList;
    }

    private String toOptionsString(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : list) {
            int n;
            if (string.startsWith("-D") && (n = string.indexOf(61)) != -1) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n);
                if (string3.indexOf(32) != -1 || string3.indexOf(9) != -1) {
                    string = string2 + "=\"" + string3 + '\"';
                }
            }
            stringBuffer.append(' ').append(string);
        }
        return stringBuffer.substring(1);
    }

    protected List<String> toOptionsList(String string) {
        List<String> list = Arrays.asList(string.trim().split("\\s"));
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            if (string2.trim().length() == 0) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }
}

