/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import weblogic.logging.WLLevel;
import weblogic.nodemanager.server.NMServer;
import weblogic.nodemanager.server.WLSProcess;

public class WLSProcessImpl
extends WLSProcess {
    private Process proc;
    private Drainer outDrainer;
    private Drainer errDrainer;

    public WLSProcessImpl(String[] stringArray, Map map, File file, File file2) {
        super(stringArray, map, file, file2);
        this.setLogger(NMServer.nmLog);
        this.setErrorLevel(WLLevel.WARNING);
    }

    protected final void start() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.getOutFile(), true);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        ProcessBuilder processBuilder = this.createProcessObject();
        this.proc = processBuilder.start();
        this.proc.getOutputStream().close();
        this.outDrainer = new Drainer(this.proc.getInputStream(), outputStreamWriter);
        this.errDrainer = new Drainer(this.proc.getErrorStream(), outputStreamWriter);
        this.outDrainer.start();
        this.errDrainer.start();
    }

    ProcessBuilder createProcessObject() {
        ProcessBuilder processBuilder = new ProcessBuilder(Arrays.asList(this.getCommand()));
        Map<String, String> map = processBuilder.environment();
        Map map2 = this.getEnv();
        if (map2 != null) {
            map.putAll(map2);
        }
        processBuilder.directory(this.getDir());
        return processBuilder;
    }

    public void destroy() {
        this.proc.destroy();
    }

    protected final void waitFor() throws InterruptedException {
        this.proc.waitFor();
        this.outDrainer.join();
        this.errDrainer.join();
    }

    public boolean isAlive() {
        try {
            this.proc.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
        return false;
    }

    public String getProcessId() {
        return null;
    }

    private static class Drainer
    extends Thread {
        private BufferedReader in;
        private Writer out;
        private static final String EOL = System.getProperty("line.separator");

        Drainer(InputStream inputStream, Writer writer) {
            this.in = new BufferedReader(new InputStreamReader(inputStream));
            this.out = writer;
        }

        public void run() {
            try {
                String string;
                while ((string = this.in.readLine()) != null) {
                    this.out.write(string + EOL);
                    this.out.flush();
                }
            }
            catch (Throwable throwable) {
                NMServer.nmLog.log((Level)((Object)WLLevel.WARNING), "Uncaught exception in process output drainer", throwable);
            }
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                NMServer.nmLog.log((Level)((Object)WLLevel.WARNING), "Unable to close server output log file", iOException);
            }
        }
    }
}

