/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.server;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import weblogic.logging.WLLevel;
import weblogic.nodemanager.server.NMServer;
import weblogic.nodemanager.server.WLSProcess;
import weblogic.nodemanager.util.ProcessControl;

public class WLSProcessNativeImpl
extends WLSProcess {
    private ProcessControl pc;
    private String pid;
    private final boolean isAnExistingPID;
    private static final int PROCESS_CHECK_INTERVAL = 500;

    public WLSProcessNativeImpl(ProcessControl processControl, String[] stringArray, Map map, File file, File file2) {
        super(stringArray, map, file, file2);
        this.pc = processControl;
        this.isAnExistingPID = false;
        this.setLogger(NMServer.nmLog);
        this.setErrorLevel(WLLevel.WARNING);
    }

    public WLSProcessNativeImpl(ProcessControl processControl, String string) {
        super(null, null, null, null);
        this.pc = processControl;
        this.pid = string;
        this.isAnExistingPID = true;
        this.setLogger(NMServer.nmLog);
        this.setErrorLevel(WLLevel.WARNING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void start() throws IOException {
        if (!this.isAnExistingPID) {
            ProcessControl processControl = this.pc;
            synchronized (processControl) {
                this.pid = this.pc.createProcess(this.getCommand(), this.getEnv(), this.getDir(), this.getOutFile());
            }
        }
    }

    public String getProcessId() {
        return this.pid;
    }

    public boolean isAlive() {
        return this.pc.isProcessAlive(this.pid);
    }

    public void destroy() {
        this.pc.killProcess(this.pid);
    }

    protected final void waitFor() throws InterruptedException {
        while (this.pc.isProcessAlive(this.pid)) {
            Thread.sleep(500L);
        }
    }
}

