/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.system;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import weblogic.nodemanager.NMException;
import weblogic.nodemanager.plugin.NMPlugin;
import weblogic.nodemanager.plugin.NMServerI;
import weblogic.nodemanager.server.NMHelper;
import weblogic.nodemanager.server.NMServer;
import weblogic.nodemanager.server.WLSProcess;
import weblogic.nodemanager.server.WLSProcessImpl;
import weblogic.nodemanager.system.NodeManagerSystem;

public class DefaultNMPlugin
implements NMPlugin {
    private NMServer server = null;
    private Logger logger = null;
    private static final long IFCONFIG_TIMEOUT = 0L;

    public DefaultNMPlugin(NMPlugin nMPlugin) {
        NodeManagerSystem.getInstance().initialize(nMPlugin);
    }

    protected DefaultNMPlugin(NMServer nMServer) {
        this.server = nMServer;
    }

    public WLSProcess createProcess(String[] stringArray, Map map, File file, File file2) throws NMException {
        if (stringArray == null) {
            throw new NMException("Command Line provided is null");
        }
        WLSProcessImpl wLSProcessImpl = new WLSProcessImpl(stringArray, map, file, file2);
        return wLSProcessImpl;
    }

    public NMServerI getNodeManagerServer() throws NMException {
        if (this.server == null) {
            throw new NMException("NodeManager Server is not initiated");
        }
        return this.server;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.setLogger(NMServer.nmLog);
        }
        return this.logger;
    }

    public WLSProcess.ExecuteCallbackHook createBindIPHook(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) throws NMException {
        final File file = new File(string6);
        if (!new File(file, NMHelper.getIFControlScriptName()).exists()) {
            throw new NMException("wlsifconfig script does not exist at " + file.getPath());
        }
        final String[] stringArray = NMHelper.buildAddMigrationCommand(string2, string3, string4, string6);
        final Properties properties = NMHelper.buildMigrationEnv(string, string5, bl);
        WLSProcess.ExecuteCallbackHook executeCallbackHook = new WLSProcess.ExecuteCallbackHook(){

            public void execute() throws IOException {
                int n = NodeManagerSystem.getInstance().executeScript(stringArray, properties, file, 0L);
                if (n != 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringBuffer.append(stringArray[i]);
                        stringBuffer.append(" ");
                    }
                    throw new IOException("Command '" + stringBuffer + "' returned an unsuccessful exit code '" + n + "'. Check NM logs for script output.");
                }
            }
        };
        return executeCallbackHook;
    }

    public WLSProcess.ExecuteCallbackHook createUnbindIPHook(String string, String string2, String string3, String string4, String string5) throws NMException {
        final File file = new File(string5);
        if (!new File(file, NMHelper.getIFControlScriptName()).exists()) {
            throw new NMException("wlsifconfig script does not exist at " + file.getPath());
        }
        final String[] stringArray = NMHelper.buildRemoveMigrationCommand(string2, string3, string5);
        final Properties properties = NMHelper.buildMigrationEnv(string, string4);
        WLSProcess.ExecuteCallbackHook executeCallbackHook = new WLSProcess.ExecuteCallbackHook(){

            public void execute() throws IOException {
                int n = NodeManagerSystem.getInstance().executeScript(stringArray, properties, file, 0L);
                if (n != 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringBuffer.append(stringArray[i]);
                        stringBuffer.append(" ");
                    }
                    throw new IOException("Command '" + stringBuffer + "' returned an unsuccessful exit code '" + n + "'. Check NM logs for script output.");
                }
            }
        };
        return executeCallbackHook;
    }
}

