/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.system;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import weblogic.nodemanager.NMException;
import weblogic.nodemanager.plugin.NMPlugin;
import weblogic.nodemanager.plugin.NMServerI;
import weblogic.nodemanager.server.NMHelper;
import weblogic.nodemanager.server.NMServer;
import weblogic.nodemanager.server.WLSProcess;
import weblogic.nodemanager.system.DefaultNMPlugin;

public final class NodeManagerSystem {
    private static NodeManagerSystem singleton = null;
    private NMPlugin nmPlugin = null;

    private NodeManagerSystem() {
    }

    public static NodeManagerSystem getInstance() {
        if (singleton == null) {
            singleton = SingletonMaker.singleton;
        }
        return singleton;
    }

    public void initialize(NMServer nMServer) {
        if (nMServer == null) {
            throw new NullPointerException("NMServer is null");
        }
        this.nmPlugin = new DefaultNMPlugin(nMServer);
    }

    public void initialize(NMPlugin nMPlugin) {
        if (nMPlugin == null) {
            throw new NullPointerException("Plugin is null");
        }
        this.nmPlugin = nMPlugin;
    }

    public NMServerI getNodeManagerServer() throws NMException {
        this.checkForInitialized();
        return this.nmPlugin.getNodeManagerServer();
    }

    public Thread initializeAndStartMonitor(WLSProcess wLSProcess) throws NMException {
        NMServerI nMServerI = this.getNodeManagerServer();
        return nMServerI.initializeAndStartServerMonitor(wLSProcess);
    }

    public WLSProcess createProcess(String[] stringArray, Map map, File file, File file2) throws NMException {
        this.checkForInitialized();
        return this.nmPlugin.createProcess(stringArray, map, file, file2);
    }

    public List getAdditionalProcessArgs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-Dweblogic.nodemanager.ServiceEnabled=true");
        return arrayList;
    }

    public Logger getLogger() {
        if (this.nmPlugin == null) {
            return NMServer.nmLog;
        }
        return this.nmPlugin.getLogger();
    }

    public WLSProcess.ExecuteCallbackHook createBindIPHook(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) throws NMException {
        this.checkForInitialized();
        return this.nmPlugin.createBindIPHook(string, string2, string3, string4, string5, string6, bl);
    }

    public WLSProcess.ExecuteCallbackHook createUnbindIPHook(String string, String string2, String string3, String string4, String string5) throws NMException {
        this.checkForInitialized();
        return this.nmPlugin.createUnbindIPHook(string, string2, string3, string4, string5);
    }

    public synchronized int executeScript(String[] stringArray, Properties properties, File file, long l) throws IOException {
        return NMHelper.executeScript(stringArray, properties, file, l);
    }

    private void checkForInitialized() throws NMException {
        if (this.nmPlugin == null) {
            throw new NMException("NodeManager System not initialized");
        }
    }

    private static class SingletonMaker {
        public static final NodeManagerSystem singleton = new NodeManagerSystem();

        private SingletonMaker() {
        }
    }
}

