/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.util;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import weblogic.nodemanager.util.ProcessControl;

public class UnixProcessControl
extends ProcessControl {
    private static final int REAPER_INTERVAL_MS = 10000;
    private boolean initialized;
    private Set<Integer> childPIDs;
    private Timer reaperTimer;

    UnixProcessControl() throws UnsatisfiedLinkError {
        System.loadLibrary("nodemanager");
        this.childPIDs = new HashSet<Integer>();
        this.reaperTimer = new Timer("NM Reaper", true);
        this.reaperTimer.schedule((TimerTask)new ReaperTask(), 10000L, 10000L);
    }

    public String getProcessId() {
        return String.valueOf(this.getProcessId0());
    }

    public boolean changeFileOwnership(File file, String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (file != null) {
            return this.changeFileOwnership0(file.getAbsolutePath(), string, string2);
        }
        return false;
    }

    public boolean killProcess(String string) {
        try {
            return this.killProcess0(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid pid format: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProcessAlive(String string) {
        int n = Integer.parseInt(string);
        Set<Integer> set = this.childPIDs;
        synchronized (set) {
            int n2;
            if (this.childPIDs.contains(n) && (n2 = this.waitNonBlocking0(n)) == n) {
                this.childPIDs.remove(n);
                return false;
            }
        }
        try {
            return this.isProcessAlive0(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid pid format: " + string);
        }
    }

    public String createProcess(String[] stringArray, Map map, File file, File file2) throws IOException {
        int n;
        String string = null;
        String string2 = null;
        byte[] byArray = null;
        if (stringArray.length < 1) {
            throw new IndexOutOfBoundsException();
        }
        if (file != null) {
            string = file.getAbsolutePath();
        }
        if (file2 != null) {
            string2 = file2.getAbsolutePath();
        }
        if (map != null) {
            byArray = this.getEnvironmentBlock(map);
        }
        if ((n = this.createProcess0(this.getArgumentBlock(stringArray), stringArray.length, byArray, map != null ? map.size() : 0, string, string2)) <= 0) {
            throw new IOException("Invalid pid [" + n + "] returned while creating process for " + Arrays.toString(stringArray));
        }
        this.addChild(n);
        return String.valueOf(n);
    }

    private byte[] getArgumentBlock(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < stringArray.length; ++i) {
            n += stringArray[i].getBytes().length;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[n]);
        for (int i = 0; i < stringArray.length; ++i) {
            byteBuffer.put(stringArray[i].getBytes());
            byteBuffer.put((byte)0);
        }
        return byteBuffer.array();
    }

    private byte[] getEnvironmentBlock(Map map) {
        int n = map.size() * 2;
        for (Map.Entry object : map.entrySet()) {
            n += ((String)object.getKey()).getBytes().length;
            n += ((String)object.getValue()).getBytes().length;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[n]);
        for (Map.Entry entry : map.entrySet()) {
            byteBuffer.put(((String)entry.getKey()).getBytes());
            byteBuffer.put((byte)61);
            byteBuffer.put(((String)entry.getValue()).getBytes());
            byteBuffer.put((byte)0);
        }
        return byteBuffer.array();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChild(int n) {
        Set<Integer> set = this.childPIDs;
        synchronized (set) {
            this.childPIDs.add(n);
        }
    }

    private native int getProcessId0();

    private native boolean killProcess0(int var1);

    private native boolean isProcessAlive0(int var1);

    private native boolean changeFileOwnership0(String var1, String var2, String var3);

    private native int createProcess0(byte[] var1, int var2, byte[] var3, int var4, String var5, String var6) throws IOException;

    private native int waitNonBlocking0(int var1);

    class ReaperTask
    extends TimerTask {
        ReaperTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Set set = UnixProcessControl.this.childPIDs;
            synchronized (set) {
                if (UnixProcessControl.this.childPIDs.size() == 0) {
                    return;
                }
                Iterator iterator = UnixProcessControl.this.childPIDs.iterator();
                while (iterator.hasNext()) {
                    Integer n = (Integer)iterator.next();
                    int n2 = UnixProcessControl.this.waitNonBlocking0(n);
                    if (n2 == 0 || n2 == -1 || n2 != n) continue;
                    iterator.remove();
                }
            }
        }
    }
}

