/*
 * Decompiled with CFR 0.152.
 */
package weblogic.nodemanager.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import weblogic.nodemanager.util.ProcessControl;

class WindowsProcessControl
extends ProcessControl {
    WindowsProcessControl() throws UnsatisfiedLinkError {
        System.loadLibrary("nodemanager");
    }

    public String getProcessId() {
        return String.valueOf(this.getProcessId0());
    }

    public boolean killProcess(String string) {
        try {
            return this.killProcess0(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid pid format");
        }
    }

    public boolean isProcessAlive(String string) {
        try {
            return this.isProcessAlive0(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid pid format");
        }
    }

    public String createProcess(String[] stringArray, Map map, File file, File file2) throws IOException {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (stringArray.length < 1) {
            throw new IndexOutOfBoundsException();
        }
        stringArray[0] = new File(stringArray[0]).getPath();
        if (file != null) {
            string = file.getAbsolutePath();
        }
        if (file2 != null) {
            string2 = file2.getAbsolutePath();
        }
        if (map != null) {
            string3 = this.getEnvironmentBlock(map);
        }
        int n = this.createProcess0(null, this.getCommandLine(stringArray), string3, string, string2);
        return String.valueOf(n);
    }

    private String getCommandLine(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringArray[0] = new File(stringArray[0]).getPath();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (i > 0) {
                stringBuffer.append(' ');
            }
            if (((string = stringArray[i]).indexOf(32) >= 0 || string.indexOf(9) >= 0) && string.indexOf(34) < 0) {
                stringBuffer.append('\"').append(string).append('\"');
                continue;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String getEnvironmentBlock(Map map) {
        ArrayList arrayList = new ArrayList(map.entrySet());
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = (Map.Entry)object2;
                return ((String)entry.getKey()).compareToIgnoreCase((String)entry2.getKey());
            }
        });
        StringBuffer stringBuffer = new StringBuffer(arrayList.size() * 32);
        for (Map.Entry entry : arrayList) {
            stringBuffer.append((String)entry.getKey()).append('=').append((String)entry.getValue()).append('\u0000');
        }
        stringBuffer.append('\u0000');
        return stringBuffer.toString();
    }

    private native int getProcessId0();

    private native boolean killProcess0(int var1);

    private native boolean isProcessAlive0(int var1);

    private native int createProcess0(String var1, String var2, String var3, String var4, String var5) throws IOException;
}

