/*
 * Decompiled with CFR 0.152.
 */
package weblogic.persist;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StreamCorruptedException;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import weblogic.jndi.Environment;
import weblogic.management.provider.ManagementService;
import weblogic.persist.TxIndexedFileRemote;
import weblogic.persist.TxIndexedFileStub;
import weblogic.rmi.utils.enumerations.BatchingEnumerationWrapper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.t3.srvr.T3Srvr;
import weblogic.transaction.Transaction;
import weblogic.transaction.TransactionManager;
import weblogic.utils.PlatformConstants;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.UnsyncHashtable;
import weblogic.utils.io.UnsyncByteArrayOutputStream;

public class TxIndexedFileImpl
implements TxIndexedFileRemote,
XAResource,
PlatformConstants {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final boolean VERBOSE = false;
    int fullWriteInterval = Integer.getInteger("txindexedfile.fullwriteinterval", 100);
    static PrintStream ps;
    private String name;
    private String commitFilename;
    private String prepareFilename;
    private UnsyncHashtable database;
    private CommitThread commitThread;
    private PrepareThread prepareThread;
    private UnsyncHashtable bytes = new UnsyncHashtable();
    private ByteArrayOutputStream baos;
    private UnsyncHashtable enrolled = new UnsyncHashtable();
    private static Object exists;
    private UnsyncHashtable writeLocks = new UnsyncHashtable();
    private UnsyncHashtable changes = new UnsyncHashtable();
    private static Object removeObject;
    private int numWrites = 0;
    protected Object preparationMutex = new Object();
    protected Object commitMutex = new Object();
    protected UnsyncHashtable preparationChanges;
    protected IOException preparationIOE;
    protected UnsyncHashtable commitChanges;
    protected IOException commitIOE;
    protected File commitFile;
    protected File prepareFile;
    private static final int MIN_MILLIS_BETWEEN_WRITES;
    private Object prepareWriteMutex = new Object();
    private Object commitWriteMutex = new Object();
    protected boolean isShutdown = false;
    private static TransactionManager tms;

    public static void main(String[] stringArray) {
        try {
            String string = stringArray.length >= 1 ? stringArray[0] : "DefaultStore";
            String string2 = stringArray.length >= 2 ? stringArray[1] : ManagementService.getRuntimeAccess(kernelId).getServer().getName();
            String string3 = stringArray.length >= 3 ? stringArray[2] : ManagementService.getRuntimeAccess(kernelId).getServer().getName();
            TxIndexedFileStub txIndexedFileStub = new TxIndexedFileStub(string, string2, string3);
            try {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("weblogic.jndi.createIntermediateContexts", "true");
                InitialContext initialContext = new InitialContext(hashtable);
                initialContext.rebind(string, (Object)txIndexedFileStub);
            }
            catch (NamingException namingException) {
                T3Srvr.getT3Srvr().getLog().error("There was a communication problem -- this Impl must be in the server", namingException);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    private UnsyncHashtable readDatabase(File var1_1) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void loadDatabase(File file, File file2) throws IOException {
        block12: {
            this.database = new UnsyncHashtable();
            this.ensureDirectories(file, file2);
            this.commitFile = new File(this.commitFilename);
            this.prepareFile = new File(this.prepareFilename);
            if (this.commitFile.exists()) {
                if (this.prepareFile.exists() && this.prepareFile.lastModified() > this.commitFile.lastModified()) {
                    try {
                        this.database = this.readDatabase(this.prepareFile);
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    this.database = this.readDatabase(this.commitFile);
                    return;
                }
                catch (Exception exception) {
                    try {
                        if (this.prepareFile.exists() && this.prepareFile.lastModified() < this.commitFile.lastModified()) {
                            this.database = this.readDatabase(this.prepareFile);
                            return;
                        }
                        break block12;
                    }
                    catch (Exception exception2) {
                        return;
                    }
                }
            }
            try {
                if (this.prepareFile.exists()) {
                    this.database = this.readDatabase(this.prepareFile);
                    return;
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    private void ensureDirectories(File file, File file2) throws IOException {
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Couldn't create " + file);
        }
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("Couldn't create " + file2);
        }
    }

    protected TxIndexedFileImpl(String string, String string2, String string3) throws IOException {
        this.name = string;
        this.commitFilename = string2 + File.separator + string + ".dat";
        this.prepareFilename = string3 + File.separator + string + "Tmp.dat";
        this.loadDatabase(new File(string2), new File(string3));
        this.commitThread = new CommitThread(string + "-CommitThread");
        this.commitThread.start();
        this.prepareThread = new PrepareThread(string + "-PrepareThread");
        this.prepareThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.isShutdown = true;
        Object object = this.preparationMutex;
        synchronized (object) {
            this.preparationMutex.notifyAll();
        }
        object = this.commitMutex;
        synchronized (object) {
            this.commitMutex.notifyAll();
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String string, Object object) throws IOException, TransactionRolledbackException {
        Transaction transaction = null;
        try {
            transaction = TxIndexedFileImpl.getTransaction();
        }
        catch (SystemException systemException) {
            throw new TransactionRolledbackException("Could not obtain transaction:\n " + systemException.getMessage());
        }
        if (transaction == null) {
            try {
                TxIndexedFileImpl.getTransactionManager().begin("persist internal");
                transaction = TxIndexedFileImpl.getTransaction();
                transaction.enlistResource((XAResource)this);
                this.write(transaction.getXID(), string, object);
                transaction.commit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new TransactionRolledbackException("Could not complete transaction . . . Rolled back: " + exception.getMessage());
            }
        }
        try {
            TxIndexedFileImpl txIndexedFileImpl = this;
            synchronized (txIndexedFileImpl) {
                if (this.enrolled.put((Object)transaction.getXID(), exists) == null) {
                    transaction.enlistResource((XAResource)this);
                }
            }
        }
        catch (Exception exception) {
            throw new TransactionRolledbackException("Could not enroll resource: " + exception.getMessage());
        }
        this.write(transaction.getXID(), string, object);
    }

    public Object retrieve(String string) {
        Transaction transaction = null;
        try {
            transaction = TxIndexedFileImpl.getTransaction();
        }
        catch (SystemException systemException) {
            systemException.printStackTrace();
            return null;
        }
        return this.read(transaction == null ? null : transaction.getXID(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration keys() {
        TxIndexedFileImpl txIndexedFileImpl = this;
        synchronized (txIndexedFileImpl) {
            UnsyncHashtable unsyncHashtable;
            if (this.baos == null) {
                this.baos = new ByteArrayOutputStream();
            } else {
                this.baos.reset();
            }
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.baos);
                objectOutputStream.writeObject(this.database);
                objectOutputStream.flush();
                objectOutputStream.close();
                byte[] byArray = this.baos.toByteArray();
                MyObjectInputStream myObjectInputStream = new MyObjectInputStream(new ByteArrayInputStream(byArray));
                unsyncHashtable = (UnsyncHashtable)myObjectInputStream.readObject();
                myObjectInputStream.close();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Could not make clone of object: " + exception);
            }
            return new BatchingEnumerationWrapper(unsyncHashtable.keys(), 10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Xid xid, String string, Object object) {
        Transaction transaction;
        UnsyncHashtable unsyncHashtable = this.writeLocks;
        synchronized (unsyncHashtable) {
            transaction = (Transaction)this.writeLocks.get((Object)string);
            while (transaction != null && !transaction.equals(xid)) {
                Transaction transaction2 = transaction;
                synchronized (transaction2) {
                    try {
                        transaction.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    transaction = (Transaction)this.writeLocks.get((Object)string);
                }
            }
            this.writeLocks.put((Object)string, (Object)xid);
        }
        unsyncHashtable = this.changes;
        synchronized (unsyncHashtable) {
            transaction = (UnsyncHashtable)this.changes.get((Object)xid);
            if (transaction == null) {
                transaction = new UnsyncHashtable();
                this.changes.put((Object)xid, (Object)transaction);
            }
            if (object == null) {
                object = removeObject;
            }
            transaction.put((Object)string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object read(Xid xid, String string) {
        Xid xid2;
        Xid xid3;
        Object object = this.writeLocks;
        synchronized (object) {
            xid3 = (Xid)this.writeLocks.get((Object)string);
            while (xid3 != null && !xid3.equals(xid)) {
                xid2 = xid3;
                synchronized (xid2) {
                    try {
                        xid3.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    xid3 = (Xid)this.writeLocks.get((Object)string);
                }
            }
        }
        object = this;
        synchronized (object) {
            if (xid != null && xid.equals(xid3) && (xid2 = (UnsyncHashtable)this.changes.get((Object)xid)) != null) {
                Object object2 = xid2.get(string);
                if (object2 == removeObject) {
                    return null;
                }
                if (object2 != null) {
                    return object2;
                }
            }
            return this.database.get((Object)string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void releaseLocks(Xid xid) {
        Object object;
        this.enrolled.remove((Object)xid);
        this.bytes.remove((Object)xid);
        UnsyncHashtable unsyncHashtable = (UnsyncHashtable)this.changes.remove((Object)xid);
        Enumeration enumeration = unsyncHashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            Object object2 = this.writeLocks.remove(object);
            if (object2 == null || xid.equals(object2)) continue;
            Object object3 = object2;
            synchronized (object3) {
                object2.notifyAll();
            }
        }
        object = xid;
        synchronized (object) {
            xid.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(UnsyncHashtable unsyncHashtable, File file) throws IOException {
        Object object;
        int n;
        boolean bl = (n = this.numWrites++ >> 2) % this.fullWriteInterval != 0;
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)unsyncByteArrayOutputStream);
        if (bl) {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(unsyncHashtable);
        } else {
            TxIndexedFileImpl txIndexedFileImpl = this;
            synchronized (txIndexedFileImpl) {
                object = (UnsyncHashtable)this.database.clone();
            }
            this.fillInDatabase((UnsyncHashtable)object, unsyncHashtable);
            objectOutputStream.writeObject(object);
        }
        objectOutputStream.flush();
        objectOutputStream.close();
        unsyncByteArrayOutputStream.close();
        object = new FileOutputStream(file.getAbsolutePath(), bl);
        ((FileOutputStream)object).write(unsyncByteArrayOutputStream.toByteArray());
        ((OutputStream)object).flush();
        ((FileOutputStream)object).getFD().sync();
        ((FileOutputStream)object).close();
    }

    public void end(Xid xid, int n) throws XAException {
    }

    public void forget(Xid xid) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        return this == xAResource;
    }

    public Xid[] recover(int n) throws XAException {
        return null;
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return true;
    }

    public void start(Xid xid, int n) throws XAException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        try {
            Object object = this.preparationMutex;
            synchronized (object) {
                Object object2 = this.prepareWriteMutex;
                synchronized (object2) {
                    if (this.preparationChanges == null) {
                        this.preparationChanges = new UnsyncHashtable();
                    }
                    this.copy(this.preparationChanges, (UnsyncHashtable)this.changes.get((Object)xid));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.prepareThread.write();
        if (this.preparationIOE != null) {
            throw new XAException(StackTraceUtils.throwable2StackTrace((Throwable)this.preparationIOE));
        }
        return 0;
    }

    public void rollback(Xid xid) throws XAException {
        this.commitThread.write();
        this.releaseLocks(xid);
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        if (bl) {
            try {
                int n = this.prepare(xid);
                if (n == 0) {
                    this.commit(xid);
                }
            }
            catch (XAException xAException) {
                this.decipherFailure("prepare", this.prepareFilename, null);
            }
            return;
        }
        this.commit(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid) throws XAException {
        Object object = this.commitMutex;
        synchronized (object) {
            Object object2 = this.commitWriteMutex;
            synchronized (object2) {
                if (this.commitChanges == null) {
                    this.commitChanges = new UnsyncHashtable();
                }
                this.copy(this.commitChanges, (UnsyncHashtable)this.changes.get((Object)xid));
            }
        }
        this.commitThread.write();
        if (this.commitIOE != null) {
            this.decipherFailure("commit", this.commitFilename, this.commitIOE);
        }
        this.fillInDatabase(this.database, xid);
        this.releaseLocks(xid);
    }

    private void decipherFailure(String string, String string2, IOException iOException) throws XAException {
        String string3;
        String string4 = string2.substring(0, string2.lastIndexOf(FILE_SEP));
        File file = new File(string4);
        File file2 = new File(string2);
        String string5 = "Could not " + string + ": ";
        String string6 = string3 = iOException == null ? "" : EOL + "Caught " + iOException;
        if (!file.exists()) {
            throw new XAException(string5 + "Directory '" + file + "' does not exist." + string3);
        }
        if (!file.isDirectory()) {
            throw new XAException(string5 + "File '" + file + "' exists but is not a directory." + string3);
        }
        if (!file2.canWrite()) {
            throw new XAException(string5 + "Can't write to file '" + file2 + "'." + string3);
        }
        if (iOException != null) {
            throw new XAException(string5 + string3);
        }
        throw new XAException(string5 + "Possible problems: " + EOL + "  Disk full" + EOL + "  No available file descriptors (Unix)" + EOL + "  File owned by different process (NT)" + EOL + "  Hardware error");
    }

    private void fillInDatabase(UnsyncHashtable unsyncHashtable, Xid xid) {
        this.fillInDatabase(unsyncHashtable, null, xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillInDatabase(UnsyncHashtable unsyncHashtable, UnsyncHashtable unsyncHashtable2, Xid xid) {
        TxIndexedFileImpl txIndexedFileImpl = this;
        synchronized (txIndexedFileImpl) {
            UnsyncHashtable unsyncHashtable3 = (UnsyncHashtable)this.changes.get((Object)xid);
            Enumeration enumeration = unsyncHashtable3.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object = unsyncHashtable3.get((Object)string);
                if (unsyncHashtable2 != null) {
                    unsyncHashtable2.put((Object)string, object);
                }
                if (object.equals(removeObject)) {
                    unsyncHashtable.remove((Object)string);
                    continue;
                }
                unsyncHashtable.put((Object)string, object);
            }
        }
    }

    private void fillInDatabase(UnsyncHashtable unsyncHashtable, UnsyncHashtable unsyncHashtable2) {
        Enumeration enumeration = unsyncHashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = unsyncHashtable2.get((Object)string);
            if (object.equals(removeObject)) {
                unsyncHashtable.remove((Object)string);
                continue;
            }
            unsyncHashtable.put((Object)string, object);
        }
    }

    private void copy(UnsyncHashtable unsyncHashtable, UnsyncHashtable unsyncHashtable2) {
        Enumeration enumeration = unsyncHashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = unsyncHashtable2.get((Object)string);
            unsyncHashtable.put((Object)string, object);
        }
    }

    private static Transaction getTransaction() throws SystemException {
        return (Transaction)TxIndexedFileImpl.getTransactionManager().getTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TransactionManager getTransactionManager() throws SystemException {
        if (tms != null) return tms;
        Class<TxIndexedFileImpl> clazz = TxIndexedFileImpl.class;
        synchronized (TxIndexedFileImpl.class) {
            if (tms != null) return tms;
            try {
                Environment environment = new Environment();
                environment.setCreateIntermediateContexts(true);
                Context context = environment.getInitialContext();
                tms = (TransactionManager)context.lookup("weblogic.transaction.TransactionManager");
            }
            catch (NamingException namingException) {
                throw new SystemException("Naming lookup problem: " + StackTraceUtils.throwable2StackTrace((Throwable)namingException));
            }
            return tms;
        }
    }

    static {
        exists = new Object();
        removeObject = "\u00000\u00000\u00000\u00000";
        MIN_MILLIS_BETWEEN_WRITES = Integer.getInteger("txindexedfile.writemillis", 50);
        tms = null;
    }

    private class CommitThread
    extends Thread {
        private int writeCalled;
        private int writeDone;

        public CommitThread(String string) {
            super(string);
            this.writeCalled = 0;
            this.writeDone = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object = TxIndexedFileImpl.this.commitMutex;
                synchronized (object) {
                    long l = MIN_MILLIS_BETWEEN_WRITES;
                    while (true) {
                        if (TxIndexedFileImpl.this.commitChanges == null) {
                            l = MIN_MILLIS_BETWEEN_WRITES;
                        } else if (l <= 0L) break;
                        long l2 = System.currentTimeMillis();
                        try {
                            TxIndexedFileImpl.this.commitMutex.wait(l);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (TxIndexedFileImpl.this.isShutdown) break;
                        l -= System.currentTimeMillis() - l2;
                    }
                    if (TxIndexedFileImpl.this.commitChanges != null) {
                        try {
                            TxIndexedFileImpl.this.write(TxIndexedFileImpl.this.commitChanges, TxIndexedFileImpl.this.commitFile);
                            TxIndexedFileImpl.this.commitIOE = null;
                        }
                        catch (IOException iOException) {
                            TxIndexedFileImpl.this.commitIOE = iOException;
                        }
                    }
                    Object object2 = TxIndexedFileImpl.this.commitWriteMutex;
                    synchronized (object2) {
                        TxIndexedFileImpl.this.commitChanges = null;
                        TxIndexedFileImpl.this.commitWriteMutex.notifyAll();
                    }
                    if (TxIndexedFileImpl.this.isShutdown) {
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write() {
            if (TxIndexedFileImpl.this.isShutdown) {
                throw new RuntimeException("Database has been shutdown");
            }
            Object object = TxIndexedFileImpl.this.commitWriteMutex;
            synchronized (object) {
                while (TxIndexedFileImpl.this.commitChanges != null) {
                    try {
                        TxIndexedFileImpl.this.commitWriteMutex.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private class PrepareThread
    extends Thread {
        private int writeCalled;
        private int writeDone;

        public PrepareThread(String string) {
            super(string);
            this.writeCalled = 0;
            this.writeDone = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object = TxIndexedFileImpl.this.preparationMutex;
                synchronized (object) {
                    long l = MIN_MILLIS_BETWEEN_WRITES;
                    while (true) {
                        if (TxIndexedFileImpl.this.preparationChanges == null) {
                            l = MIN_MILLIS_BETWEEN_WRITES;
                        } else if (l <= 0L) break;
                        long l2 = System.currentTimeMillis();
                        try {
                            TxIndexedFileImpl.this.preparationMutex.wait(l);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (TxIndexedFileImpl.this.isShutdown) break;
                        l -= System.currentTimeMillis() - l2;
                    }
                    if (TxIndexedFileImpl.this.preparationChanges != null) {
                        try {
                            TxIndexedFileImpl.this.write(TxIndexedFileImpl.this.preparationChanges, TxIndexedFileImpl.this.prepareFile);
                            TxIndexedFileImpl.this.preparationIOE = null;
                        }
                        catch (IOException iOException) {
                            TxIndexedFileImpl.this.preparationIOE = iOException;
                        }
                    }
                    Object object2 = TxIndexedFileImpl.this.prepareWriteMutex;
                    synchronized (object2) {
                        TxIndexedFileImpl.this.preparationChanges = null;
                        TxIndexedFileImpl.this.prepareWriteMutex.notifyAll();
                    }
                    if (TxIndexedFileImpl.this.isShutdown) {
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write() {
            if (TxIndexedFileImpl.this.isShutdown) {
                throw new RuntimeException("Database has been shutdown");
            }
            Object object = TxIndexedFileImpl.this.prepareWriteMutex;
            synchronized (object) {
                while (TxIndexedFileImpl.this.preparationChanges != null) {
                    try {
                        TxIndexedFileImpl.this.prepareWriteMutex.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private static class MyObjectInputStream
    extends ObjectInputStream {
        public MyObjectInputStream(InputStream inputStream) throws IOException, StreamCorruptedException {
            super(inputStream);
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return classLoader.loadClass(objectStreamClass.getName());
        }
    }
}

