/*
 * Decompiled with CFR 0.152.
 */
package weblogic.persist;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import javax.naming.NamingException;
import weblogic.persist.TxIndexedFile;
import weblogic.persist.TxIndexedFileImpl;
import weblogic.persist.TxIndexedFileRemote;
import weblogic.utils.StackTraceUtils;

public class TxIndexedFileStub
implements Externalizable,
TxIndexedFile {
    static final long serialVersionUID = -1563396532888782603L;
    private TxIndexedFileRemote ph;
    private ByteArrayOutputStream baos;

    public TxIndexedFileStub() {
    }

    public TxIndexedFileStub(String string, String string2, String string3) throws NamingException {
        try {
            this.ph = new TxIndexedFileImpl(string, string2, string3);
        }
        catch (IOException iOException) {
            NamingException namingException = new NamingException("Can't create impl.");
            namingException.setRootCause(iOException);
            throw namingException;
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.ph = (TxIndexedFileRemote)objectInput.readObject();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.ph);
    }

    public String getName() {
        return this.ph.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String string, Object object) throws IOException {
        if (this.ph instanceof TxIndexedFileImpl) {
            if (this.baos == null) {
                this.baos = new ByteArrayOutputStream(){

                    public void close() {
                    }
                };
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = this.baos;
                synchronized (byteArrayOutputStream) {
                    this.baos.reset();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.baos);
                    objectOutputStream.writeObject(object);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    byte[] byArray = this.baos.toByteArray();
                    ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                    object = (Serializable)objectInputStream.readObject();
                    objectInputStream.close();
                }
            }
            catch (Exception exception) {
                throw new IOException("Could not make clone of object: " + StackTraceUtils.throwable2StackTrace((Throwable)exception));
            }
        }
        this.ph.store(string, object);
    }

    public Object retrieve(String string) {
        return this.ph.retrieve(string);
    }

    public Enumeration keys() {
        return this.ph.keys();
    }

    public void shutdown() {
        this.ph.shutdown();
    }
}

