/*
 * Decompiled with CFR 0.152.
 */
package weblogic.persist;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import weblogic.management.provider.ManagementService;
import weblogic.persist.DeadlockException;
import weblogic.persist.QueueTimeoutException;
import weblogic.persist.TxQueueFileRemote;
import weblogic.persist.TxQueueFileStub;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.t3.srvr.T3Srvr;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TxHelper;
import weblogic.utils.NestedRuntimeException;
import weblogic.utils.PlatformConstants;
import weblogic.utils.UnsyncHashtable;
import weblogic.utils.io.UnsyncByteArrayOutputStream;

public class TxQueueFileImpl
implements TxQueueFileRemote,
XAResource,
PlatformConstants {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final boolean verbose = false;
    private String name;
    private String commitFilename;
    private String prepareFilename;
    private Vector queue;
    private Object headMutex = new Object(){};
    private Object tailMutex = new Object(){};
    private Object headLocker;
    private Object tailLocker;
    private UnsyncHashtable enrolled = new UnsyncHashtable();
    private static Object exists = new Object(){};
    private Vector inserts = new Vector();
    private int numRemoved = 0;
    private int numWrites = 0;
    private int fullWriteInterval = 100;
    private int minMillisBetweenWrites = 20;
    private boolean isShutdown;
    private Object preparationMutex = new Object(){};
    private Vector preparationInserts;
    private int preparationNumRemoved;
    private Object prepareWriteMutex = new Object(){};
    private Vector preparationQueue;
    private File prepareFile;
    private IOException preparationIOE;
    private PrepareThread prepareThread;
    private Object commitMutex = new Object(){};
    private Object commitCompleteMutex = new Object(){};
    private Object commitWriteMutex = new Object(){};
    private Vector commitInserts;
    private int commitNumRemoved;
    private Vector commitQueue;
    private File commitFile;
    private IOException commitIOE;
    private CommitThread commitThread;

    public static void main(String[] stringArray) {
        try {
            String string = stringArray.length >= 1 ? stringArray[0] : "DefaultStore";
            String string2 = stringArray.length >= 2 ? stringArray[1] : ManagementService.getRuntimeAccess(kernelId).getServer().getName();
            String string3 = stringArray.length >= 3 ? stringArray[2] : ManagementService.getRuntimeAccess(kernelId).getServer().getName();
            TxQueueFileStub txQueueFileStub = new TxQueueFileStub(string, string2, string3);
            try {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("weblogic.jndi.createIntermediateContexts", "true");
                InitialContext initialContext = new InitialContext(hashtable);
                initialContext.rebind(string, (Object)txQueueFileStub);
            }
            catch (NamingException namingException) {
                T3Srvr.getT3Srvr().getLog().error("There was a communication problem -- this Impl must be in the server", namingException);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected TxQueueFileImpl(String string, String string2, String string3) throws IOException {
        this.name = string;
        this.commitFilename = string2 + File.separator + string + ".dat";
        this.prepareFilename = string3 + File.separator + string + "Tmp.dat";
        this.loadQueue(new File(string2), new File(string3));
        this.commitThread = new CommitThread(string + "-CommitThread");
        this.commitThread.start();
        this.prepareThread = new PrepareThread(string + "-PrepareThread");
        this.prepareThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.isShutdown = true;
        Object object = this.preparationMutex;
        synchronized (object) {
            this.preparationMutex.notifyAll();
        }
        object = this.commitMutex;
        synchronized (object) {
            this.commitMutex.notifyAll();
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object) throws TransactionRolledbackException {
        weblogic.transaction.Transaction transaction = null;
        transaction = TxHelper.getTransaction();
        if (transaction == null) {
            try {
                TransactionManager transactionManager = TxHelper.getTransactionManager();
                transactionManager.begin();
                transaction = transactionManager.getTransaction();
                transaction.enlistResource((XAResource)this);
                this.put((Transaction)transaction, object);
                transaction.commit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new TransactionRolledbackException("Could not complete transaction . . . Rolled back: " + exception.getMessage());
            }
        }
        try {
            TxQueueFileImpl txQueueFileImpl = this;
            synchronized (txQueueFileImpl) {
                if (this.enrolled.put((Object)transaction, exists) == null) {
                    transaction.enlistResource((XAResource)this);
                }
            }
        }
        catch (Exception exception) {
            throw new TransactionRolledbackException("Could not enroll resource: " + exception.getMessage());
        }
        this.put((Transaction)transaction, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() throws TransactionRolledbackException {
        Object object;
        weblogic.transaction.Transaction transaction = null;
        transaction = TxHelper.getTransaction();
        if (transaction == null) {
            try {
                TransactionManager transactionManager = TxHelper.getTransactionManager();
                transactionManager.begin();
                transaction = transactionManager.getTransaction();
                transaction.enlistResource((XAResource)this);
                object = this.get((Transaction)transaction);
                transaction.commit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new TransactionRolledbackException("Could not complete transaction . . . Rolled back: " + exception.getMessage());
            }
        }
        try {
            TxQueueFileImpl txQueueFileImpl = this;
            synchronized (txQueueFileImpl) {
                if (this.enrolled.put((Object)transaction, exists) == null) {
                    transaction.enlistResource((XAResource)this);
                }
            }
        }
        catch (Exception exception) {
            throw new TransactionRolledbackException("Could not enroll resource: " + exception.getMessage());
        }
        object = this.get((Transaction)transaction);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getW() throws DeadlockException, TransactionRolledbackException {
        Object object;
        weblogic.transaction.Transaction transaction = null;
        transaction = TxHelper.getTransaction();
        int n = this.queue.size();
        if (transaction != null && transaction.equals(this.tailLocker)) {
            n += this.inserts.size();
        }
        if (transaction != null && transaction.equals(this.headLocker)) {
            n -= this.numRemoved;
        }
        if (n == 0 && transaction != null && transaction.equals(this.tailLocker)) {
            throw new DeadlockException("Attempting to do a get in transaction that will never succeed\nInserts: " + this.inserts.size() + " Original Size: " + this.queue.size() + " Removes: " + this.numRemoved + "\ntailLocker: " + this.tailLocker + " Tx: " + transaction);
        }
        Object object2 = this.commitCompleteMutex;
        synchronized (object2) {
            while ((object = this.get()) == null) {
                try {
                    this.commitCompleteMutex.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return object;
    }

    public Object getW(long l) throws QueueTimeoutException, TransactionRolledbackException {
        Object object;
        weblogic.transaction.Transaction transaction = TxHelper.getTransaction();
        long l2 = System.currentTimeMillis();
        while ((object = this.get()) == null && l > 0L) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l -= l3 - l2;
            l2 = l3;
        }
        if (object == null) {
            throw new QueueTimeoutException("GetW() timed out");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(Transaction transaction, Object object) {
        Object object2 = this.tailMutex;
        synchronized (object2) {
            while (this.tailLocker != null && !transaction.equals(this.tailLocker)) {
                try {
                    this.tailMutex.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.tailLocker == null) {
                this.inserts = new Vector();
            }
            this.tailLocker = transaction;
        }
        this.inserts.addElement(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object get(Transaction transaction) {
        Object object = this.headMutex;
        synchronized (object) {
            while (this.headLocker != null && !transaction.equals(this.headLocker)) {
                try {
                    this.headMutex.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.headLocker == null) {
                this.numRemoved = 0;
            }
            this.headLocker = transaction;
        }
        int n = this.numRemoved - this.queue.size();
        if (n >= 0) {
            if (!transaction.equals(this.tailLocker) || this.inserts.size() <= n) {
                return null;
            }
            object = this.inserts.elementAt(n);
        } else {
            object = this.queue.elementAt(this.numRemoved);
        }
        ++this.numRemoved;
        return object;
    }

    private void decipherFailure(String string, String string2, IOException iOException) throws XAException {
        String string3;
        String string4 = string2.substring(0, string2.lastIndexOf(FILE_SEP));
        File file = new File(string4);
        File file2 = new File(string2);
        String string5 = "Could not " + string + ": ";
        String string6 = string3 = iOException == null ? "" : EOL + "Caught " + iOException;
        if (!file.exists()) {
            throw new XAException(string5 + "Directory '" + file + "' does not exist." + string3);
        }
        if (!file.isDirectory()) {
            throw new XAException(string5 + "File '" + file + "' exists but is not a directory." + string3);
        }
        if (!file2.canWrite()) {
            throw new XAException(string5 + "Can't write to file '" + file2 + "'." + string3);
        }
        if (iOException != null) {
            throw new XAException(string5 + string3);
        }
        throw new XAException(string5 + "Possible problems: " + EOL + "  Disk full" + EOL + "  File owned by different process (NT)" + EOL + "  Hardware error");
    }

    public void end(Xid xid, int n) throws XAException {
    }

    public void forget(Xid xid) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        return this == xAResource;
    }

    public Xid[] recover(int n) throws XAException {
        return null;
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return true;
    }

    public void start(Xid xid, int n) throws XAException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        weblogic.transaction.Transaction transaction = TxHelper.getTransaction();
        if (transaction == null) {
            throw new XAException("Transaction unexpectedly null");
        }
        Object object = this.preparationMutex;
        synchronized (object) {
            Object object2 = this.prepareWriteMutex;
            synchronized (object2) {
                if (this.preparationQueue == null) {
                    this.preparationQueue = (Vector)this.queue.clone();
                }
            }
            this.preparationNumRemoved = transaction.equals(this.headLocker) ? this.numRemoved : 0;
            this.preparationInserts = transaction.equals(this.tailLocker) ? this.inserts : null;
            this.fillInQueue(this.preparationQueue, this.preparationInserts, this.preparationNumRemoved);
        }
        this.prepareThread.write();
        if (this.preparationIOE != null) {
            throw new XAException(this.preparationIOE.getMessage());
        }
        return 0;
    }

    public void rollback(Xid xid) throws XAException {
        this.commitThread.write();
        this.releaseLocks();
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        if (bl) {
            this.commitOnePhase(xid);
        } else {
            this.commit(xid);
        }
    }

    private void commitOnePhase(Xid xid) throws XAException {
        int n = this.prepare(xid);
        if (n == 0) {
            this.commit(xid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(Xid xid) throws XAException {
        int n;
        Vector vector;
        weblogic.transaction.Transaction transaction = null;
        transaction = TxHelper.getTransaction();
        if (transaction == null) {
            throw new XAException("No transaction");
        }
        Object object = this.commitMutex;
        synchronized (object) {
            Object object2 = this.commitWriteMutex;
            synchronized (object2) {
                if (this.commitQueue == null) {
                    this.commitQueue = (Vector)this.queue.clone();
                }
            }
            this.commitNumRemoved = transaction.equals(this.headLocker) ? this.numRemoved : 0;
            this.commitInserts = transaction.equals(this.tailLocker) ? this.inserts : null;
            vector = this.commitInserts;
            n = this.commitNumRemoved;
            this.fillInQueue(this.commitQueue, vector, n);
        }
        this.commitThread.write();
        if (this.commitIOE != null) {
            this.decipherFailure("commit", this.commitFilename, this.commitIOE);
        }
        this.fillInQueue(this.queue, vector, n);
        this.releaseLocks();
        object = this.commitCompleteMutex;
        synchronized (object) {
            this.commitCompleteMutex.notifyAll();
        }
    }

    protected void write(Vector vector, Vector vector2, int n, File file) throws IOException {
        int n2;
        boolean bl = (n2 = this.numWrites++ >> 2) % this.fullWriteInterval != 0;
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)unsyncByteArrayOutputStream);
        if (bl) {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(vector2);
            objectOutputStream.writeInt(n);
        } else {
            objectOutputStream.writeObject(vector);
        }
        objectOutputStream.flush();
        objectOutputStream.close();
        unsyncByteArrayOutputStream.close();
        FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath(), bl);
        fileOutputStream.write(unsyncByteArrayOutputStream.toByteArray());
        fileOutputStream.flush();
        fileOutputStream.getFD().sync();
        fileOutputStream.close();
    }

    /*
     * Exception decompiling
     */
    private Vector readQueue(File var1_1) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void loadQueue(File file, File file2) throws IOException {
        block12: {
            this.queue = new Vector();
            this.ensureDirectories(file, file2);
            this.commitFile = new File(this.commitFilename);
            this.prepareFile = new File(this.prepareFilename);
            if (this.commitFile.exists()) {
                if (this.prepareFile.exists() && this.prepareFile.lastModified() > this.commitFile.lastModified()) {
                    try {
                        this.queue = this.readQueue(this.prepareFile);
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    this.queue = this.readQueue(this.commitFile);
                    return;
                }
                catch (Exception exception) {
                    try {
                        if (this.prepareFile.exists() && this.prepareFile.lastModified() < this.commitFile.lastModified()) {
                            this.queue = this.readQueue(this.prepareFile);
                            return;
                        }
                        break block12;
                    }
                    catch (Exception exception2) {
                        return;
                    }
                }
            }
            try {
                if (this.prepareFile.exists()) {
                    this.queue = this.readQueue(this.prepareFile);
                    return;
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    private void ensureDirectories(File file, File file2) throws IOException {
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Couldn't create " + file);
        }
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("Couldn't create " + file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillInQueue(Vector vector, Vector vector2, int n) {
        TxQueueFileImpl txQueueFileImpl = this;
        synchronized (txQueueFileImpl) {
            if (vector2 != null) {
                int n2 = vector2.size();
                for (int i = 0; i < n2; ++i) {
                    vector.addElement(vector2.elementAt(i));
                }
            }
            while (n > 0) {
                vector.removeElementAt(0);
                --n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void releaseLocks() {
        weblogic.transaction.Transaction transaction = null;
        transaction = TxHelper.getTransaction();
        if (transaction == null) {
            throw new NestedRuntimeException("Transaction is unexpectedly null");
        }
        this.enrolled.remove((Object)transaction);
        Object object = this.tailMutex;
        synchronized (object) {
            if (transaction.equals(this.tailLocker)) {
                this.tailLocker = null;
                this.inserts = null;
            }
            this.tailMutex.notifyAll();
        }
        object = this.headMutex;
        synchronized (object) {
            if (transaction.equals(this.headLocker)) {
                this.headLocker = null;
                this.numRemoved = 0;
            }
            this.headMutex.notifyAll();
        }
    }

    private class CommitThread
    extends Thread {
        private int writeCalled;
        private int writeDone;

        public CommitThread(String string) {
            super(string);
            this.writeCalled = 0;
            this.writeDone = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object = TxQueueFileImpl.this.commitMutex;
                synchronized (object) {
                    long l = TxQueueFileImpl.this.minMillisBetweenWrites;
                    while (true) {
                        if (TxQueueFileImpl.this.commitQueue == null) {
                            l = TxQueueFileImpl.this.minMillisBetweenWrites;
                        } else if (l <= 0L) break;
                        long l2 = System.currentTimeMillis();
                        try {
                            TxQueueFileImpl.this.commitMutex.wait(l);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (TxQueueFileImpl.this.isShutdown) break;
                        l -= System.currentTimeMillis() - l2;
                    }
                    if (TxQueueFileImpl.this.commitQueue != null) {
                        try {
                            TxQueueFileImpl.this.write(TxQueueFileImpl.this.commitQueue, TxQueueFileImpl.this.commitInserts, TxQueueFileImpl.this.commitNumRemoved, TxQueueFileImpl.this.commitFile);
                            TxQueueFileImpl.this.commitIOE = null;
                        }
                        catch (IOException iOException) {
                            TxQueueFileImpl.this.commitIOE = iOException;
                        }
                    }
                    Object object2 = TxQueueFileImpl.this.commitWriteMutex;
                    synchronized (object2) {
                        TxQueueFileImpl.this.commitQueue = null;
                        TxQueueFileImpl.this.commitWriteMutex.notifyAll();
                    }
                    if (TxQueueFileImpl.this.isShutdown) {
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write() {
            if (TxQueueFileImpl.this.isShutdown) {
                throw new RuntimeException("Queue has been shutdown");
            }
            Object object = TxQueueFileImpl.this.commitWriteMutex;
            synchronized (object) {
                while (TxQueueFileImpl.this.commitQueue != null) {
                    try {
                        TxQueueFileImpl.this.commitWriteMutex.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private class PrepareThread
    extends Thread {
        private int writeCalled;
        private int writeDone;

        public PrepareThread(String string) {
            super(string);
            this.writeCalled = 0;
            this.writeDone = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object = TxQueueFileImpl.this.preparationMutex;
                synchronized (object) {
                    long l = TxQueueFileImpl.this.minMillisBetweenWrites;
                    while (true) {
                        if (TxQueueFileImpl.this.preparationQueue == null) {
                            l = TxQueueFileImpl.this.minMillisBetweenWrites;
                        } else if (l <= 0L) break;
                        long l2 = System.currentTimeMillis();
                        try {
                            TxQueueFileImpl.this.preparationMutex.wait(l);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (TxQueueFileImpl.this.isShutdown) break;
                        l -= System.currentTimeMillis() - l2;
                    }
                    if (TxQueueFileImpl.this.preparationQueue != null) {
                        try {
                            TxQueueFileImpl.this.write(TxQueueFileImpl.this.preparationQueue, TxQueueFileImpl.this.preparationInserts, TxQueueFileImpl.this.preparationNumRemoved, TxQueueFileImpl.this.prepareFile);
                            TxQueueFileImpl.this.preparationIOE = null;
                        }
                        catch (IOException iOException) {
                            TxQueueFileImpl.this.preparationIOE = iOException;
                        }
                    }
                    Object object2 = TxQueueFileImpl.this.prepareWriteMutex;
                    synchronized (object2) {
                        TxQueueFileImpl.this.preparationQueue = null;
                        TxQueueFileImpl.this.prepareWriteMutex.notifyAll();
                    }
                    if (TxQueueFileImpl.this.isShutdown) {
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write() {
            if (TxQueueFileImpl.this.isShutdown) {
                throw new RuntimeException("Queue has been shutdown");
            }
            Object object = TxQueueFileImpl.this.prepareWriteMutex;
            synchronized (object) {
                while (TxQueueFileImpl.this.preparationQueue != null) {
                    try {
                        TxQueueFileImpl.this.prepareWriteMutex.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

