/*
 * Decompiled with CFR 0.152.
 */
package weblogic.persist;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.naming.NamingException;
import javax.transaction.TransactionRolledbackException;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.persist.DeadlockException;
import weblogic.persist.QueueTimeoutException;
import weblogic.persist.TxQueueFile;
import weblogic.persist.TxQueueFileImpl;
import weblogic.persist.TxQueueFileRemote;

public class TxQueueFileStub
implements TxQueueFile,
Externalizable {
    private TxQueueFileRemote queue;
    private ByteArrayOutputStream baos;

    public TxQueueFileStub() {
    }

    public TxQueueFileStub(String string, String string2, String string3) throws NamingException {
        try {
            this.queue = new TxQueueFileImpl(string, string2, string3);
        }
        catch (IOException iOException) {
            NamingException namingException = new NamingException("Can't create impl.");
            namingException.setRootCause(iOException);
            throw namingException;
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.queue = (TxQueueFileRemote)((WLObjectInput)objectInput).readObjectWL();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        ((WLObjectOutput)objectOutput).writeObjectWL((Object)this.queue);
    }

    public String getName() {
        return this.queue.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object) throws IOException {
        if (this.queue instanceof TxQueueFileImpl) {
            if (this.baos == null) {
                this.baos = new ByteArrayOutputStream();
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = this.baos;
                synchronized (byteArrayOutputStream) {
                    this.baos.reset();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.baos);
                    objectOutputStream.writeObject(object);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    byte[] byArray = this.baos.toByteArray();
                    ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                    object = (Serializable)objectInputStream.readObject();
                    objectInputStream.close();
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Could not make clone of object: " + exception);
            }
        }
        this.queue.put(object);
    }

    public Object get() throws TransactionRolledbackException {
        return this.queue.get();
    }

    public Object getW() throws DeadlockException, TransactionRolledbackException {
        return this.queue.getW();
    }

    public Object getW(long l) throws QueueTimeoutException, TransactionRolledbackException {
        return this.queue.getW(l);
    }

    public void shutdown() {
        this.queue.shutdown();
    }
}

