/*
 * Decompiled with CFR 0.152.
 */
package weblogic.protocol;

import java.security.AccessController;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.ServerIdentity;
import weblogic.protocol.ServerIdentityManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class AdminServerIdentity {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static ServerIdentity adminIdentity;

    public static ServerIdentity getIdentity() {
        if (ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            return LocalServerIdentity.getIdentity();
        }
        return ServerIdentityManager.findServerIdentity((String)ManagementService.getRuntimeAccess(kernelId).getDomainName(), (String)ManagementService.getRuntimeAccess(kernelId).getAdminServerName());
    }

    public static ServerIdentity getBootstrapIdentity() {
        if (ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            return LocalServerIdentity.getIdentity();
        }
        return adminIdentity;
    }

    public static void setBootstrapIdentity(ServerIdentity serverIdentity) {
        adminIdentity = serverIdentity;
    }
}

