/*
 * Decompiled with CFR 0.152.
 */
package weblogic.protocol;

import java.net.MalformedURLException;
import java.security.AccessController;
import java.util.ArrayList;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import weblogic.jndi.Environment;
import weblogic.jndi.internal.ThreadEnvironment;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.ClusterURL;
import weblogic.security.SimpleCallbackHandler;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.DefaultUserInfoImpl;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterURLImpl
implements ClusterURL {
    private static final String CLUSTER_URL_PREFIX = "cluster:";
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public String parseClusterURL(String string) throws MalformedURLException {
        if (!string.startsWith(CLUSTER_URL_PREFIX)) {
            return string;
        }
        String string2 = this.extractProtocol(string);
        String string3 = this.extractClusterName(string);
        ClusterMBean clusterMBean = this.getClusterMBean(string3);
        if (clusterMBean == null) {
            throw new MalformedURLException("No cluster named '" + string3 + "' found.");
        }
        ServerMBean[] serverMBeanArray = clusterMBean.getServers();
        if (serverMBeanArray == null || serverMBeanArray.length == 0) {
            throw new MalformedURLException("No servers configured in cluster: " + string3);
        }
        String string4 = clusterMBean.getClusterAddress();
        if (string4 != null && string4.length() != 0) {
            return this.constructClusterAddress(string2, serverMBeanArray, string4);
        }
        ArrayList<String> arrayList = this.buildListOfAddresses(string3, serverMBeanArray, string2.endsWith("s"));
        String string5 = this.buildClusterAddressURL(string2, string3, arrayList);
        return string5;
    }

    protected String constructClusterAddress(String string, ServerMBean[] serverMBeanArray, String string2) {
        boolean bl = string.endsWith("s");
        String[] stringArray = StringUtils.splitCompletely((String)string2, (String)",", (boolean)false);
        String string3 = string != null ? string : "t3";
        String string4 = string3 + "://" + string2;
        if (stringArray.length == 1) {
            if (string2.contains(":")) {
                return string4;
            }
            int n = serverMBeanArray[0].getListenPort();
            if (bl) {
                DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
                if (domainMBean.isAdministrationPortEnabled() && this.isUserAdministrator()) {
                    n = serverMBeanArray[0].getAdministrationPort();
                } else if (serverMBeanArray[0].getSSL() != null && serverMBeanArray[0].getSSL().isListenPortEnabled()) {
                    n = serverMBeanArray[0].getSSL().getListenPort();
                }
            }
            string4 = string4 + ":" + n;
        }
        return string4;
    }

    protected ArrayList<String> buildListOfAddresses(String string, ServerMBean[] serverMBeanArray, boolean bl) throws MalformedURLException {
        if (serverMBeanArray == null || serverMBeanArray.length == 0) {
            throw new MalformedURLException("No servers configured in cluster: " + string);
        }
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            Object object;
            MachineMBean machineMBean;
            ServerMBean serverMBean = serverMBeanArray[i];
            String string2 = null;
            string2 = serverMBean.getListenAddress();
            if ((string2 == null || string2.length() == 0) && (machineMBean = serverMBean.getMachine()) != null && (object = machineMBean.getNodeManager()) != null) {
                string2 = object.getListenAddress();
            }
            if (string2 == null) continue;
            int n = serverMBean.getListenPort();
            if (bl) {
                if (domainMBean.isAdministrationPortEnabled() && this.isUserAdministrator()) {
                    n = serverMBean.getAdministrationPort();
                } else {
                    if (serverMBean.getSSL() == null || !serverMBean.getSSL().isListenPortEnabled()) continue;
                    n = serverMBean.getSSL().getListenPort();
                }
            }
            object = new StringBuilder();
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(":");
            ((StringBuilder)object).append(n);
            arrayList.add(((StringBuilder)object).toString());
        }
        return arrayList;
    }

    protected String buildClusterAddressURL(String string, String string2, ArrayList<String> arrayList) throws MalformedURLException {
        if (arrayList == null || arrayList.isEmpty()) {
            throw new MalformedURLException("Unable to construct proper cluster address URL since no listening addresses found for any configured server(s) in cluster: " + string2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("://");
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(arrayList.get(i));
        }
        return stringBuilder.toString();
    }

    protected String extractClusterName(String string) {
        int n = string.lastIndexOf("://");
        String string2 = string.substring(n + 3, string.length());
        return string2;
    }

    protected String extractProtocol(String string) {
        int n = string.indexOf(58);
        int n2 = string.indexOf("://");
        String string2 = string.substring(n + 1, n2);
        return string2;
    }

    protected ClusterMBean getClusterMBean(String string) {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        ClusterMBean clusterMBean = domainMBean.lookupCluster(string);
        return clusterMBean;
    }

    protected boolean isUserAdministrator() {
        Environment environment = ThreadEnvironment.get();
        UserInfo userInfo = environment.getSecurityUser();
        if (userInfo != null) {
            try {
                AuthenticatedSubject authenticatedSubject = ClusterURLImpl.authenticateLocally(userInfo);
                if (authenticatedSubject != null) {
                    return SubjectUtils.isUserAnAdministrator((AuthenticatedSubject)authenticatedSubject);
                }
            }
            catch (LoginException loginException) {
                // empty catch block
            }
        }
        return false;
    }

    private static AuthenticatedSubject authenticateLocally(UserInfo userInfo) throws LoginException {
        String string = "weblogicDEFAULT";
        PrincipalAuthenticator principalAuthenticator = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)kernelId, (String)string, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
        AuthenticatedSubject authenticatedSubject = null;
        if (userInfo instanceof DefaultUserInfoImpl) {
            DefaultUserInfoImpl defaultUserInfoImpl = (DefaultUserInfoImpl)userInfo;
            SimpleCallbackHandler simpleCallbackHandler = new SimpleCallbackHandler(defaultUserInfoImpl.getName(), defaultUserInfoImpl.getPassword());
            authenticatedSubject = principalAuthenticator.authenticate((CallbackHandler)simpleCallbackHandler);
        }
        return authenticatedSubject;
    }
}

