/*
 * Decompiled with CFR 0.152.
 */
package weblogic.protocol;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.AbstractProtocolService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServerLogger;
import weblogic.server.ServerService;
import weblogic.server.ServiceFailureException;
import weblogic.utils.jars.ManifestManager;

public class ProtocolHandlerService
extends AbstractServerService {
    private ServerService[] handlers;

    public void start() throws ServiceFailureException {
        ArrayList arrayList = ManifestManager.getServices(AbstractProtocolService.class);
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        ServerLogger.logProtocolConfigured((String)Arrays.asList(ManagementService.getRuntimeAccess(authenticatedSubject).getServer().getSupportedProtocols()).toString());
        this.handlers = arrayList.toArray(new ServerService[arrayList.size()]);
        HashSet<String> hashSet = new HashSet<String>(this.handlers.length);
        for (int i = 0; i < this.handlers.length; ++i) {
            if (hashSet.contains(this.handlers[i].getName())) continue;
            this.handlers[i].start();
            hashSet.add(this.handlers[i].getName());
        }
    }

    public void stop() throws ServiceFailureException {
        for (int i = 0; i < this.handlers.length; ++i) {
            this.handlers[i].stop();
        }
    }

    public void halt() throws ServiceFailureException {
        for (int i = 0; i < this.handlers.length; ++i) {
            this.handlers[i].halt();
        }
    }
}

