/*
 * Decompiled with CFR 0.152.
 */
package weblogic.protocol;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Locale;
import weblogic.protocol.AbstractProtocolService;
import weblogic.protocol.ProtocolManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServerLogger;
import weblogic.server.ServiceFailureException;
import weblogic.utils.jars.ManifestManager;

public class ProtocolService
extends AbstractServerService {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void start() throws ServiceFailureException {
        ProtocolService.loadProtocol("t3", "weblogic.rjvm.t3.ProtocolHandlerT3", true);
        ProtocolService.loadProtocol("http", "weblogic.servlet.internal.ProtocolHandlerHTTP", true);
        ProtocolService.loadProtocol("iiop", true);
        ProtocolService.loadProtocol("ldap", true);
        ProtocolService.loadProtocol("ons", true);
        ProtocolService.loadProtocol("cluster", "weblogic.cluster.messaging.protocol.ProtocolHandlerClusterBroadcast", true);
        ProtocolService.loadProtocol("snmp", "weblogic.diagnostics.snmp.muxer.ProtocolHandlerSNMP", false);
        ProtocolService.loadProtocol("admin", "weblogic.protocol.ProtocolHandlerAdmin");
        ServerLogger.logAdminProtocolConfigured((String)ProtocolManager.getDefaultAdminProtocol().getAsURLPrefix());
        ManifestManager.getServices(AbstractProtocolService.class);
    }

    public static void loadProtocol(String string, String string2) {
        try {
            Class<?> clazz = Class.forName(string2);
            Method method = clazz.getMethod("getProtocolHandler", new Class[0]);
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
            ServerLogger.logProtocolConfigured((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadProtocol(String string, String string2, boolean bl) {
        ProtocolService.loadProtocol(string, string2);
        if (bl) {
            ProtocolService.loadProtocol(string + "s", string2 + "S");
        }
    }

    public static void loadProtocol(String string, boolean bl) {
        ProtocolService.loadProtocol(string, "weblogic." + string.toLowerCase(Locale.ENGLISH) + ".ProtocolHandler" + string.toUpperCase(Locale.ENGLISH), bl);
    }

    public static void loadProtocol(String string) {
        ProtocolService.loadProtocol(string, false);
    }

    public static boolean legalProtocol(String string) {
        return true;
    }
}

