/*
 * Decompiled with CFR 0.152.
 */
package weblogic.protocol;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URL;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.security.AccessController;
import java.util.Locale;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelStatus;
import weblogic.management.provider.ManagementService;
import weblogic.net.http.HttpsURLConnection;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolHandlerAdmin;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.ServerIdentity;
import weblogic.protocol.ServerIdentityManager;
import weblogic.protocol.UnknownProtocolException;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.rmi.spi.Channel;
import weblogic.rmi.spi.HostID;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.channels.RemoteChannelService;
import weblogic.server.channels.RemoteChannelServiceImpl;
import weblogic.server.channels.ServerChannelImpl;
import weblogic.socket.ChannelSSLSocketFactory;
import weblogic.socket.ChannelSocketFactory;

public final class URLManager {
    public static final String PREFIX_ADMIN = "admin";
    public static final String PREFIX_HTTP = "http";
    public static final String PREFIX_HTTPS = "https";
    public static final String PREFIX_LDAP = "ldap";
    public static final String PREFIX_LDAPS = "ldaps";
    private static final boolean DEBUG = false;
    private static final String ADMIN_HOST_PROP = "weblogic.management.server";
    private static final String OLD_ADMIN_HOST_PROP = "weblogic.admin.host";
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static String findURL(String string) throws UnknownHostException {
        ServerIdentity serverIdentity = ServerIdentityManager.findServerIdentity((String)DomainNameMaker.DOMAIN_NAME, (String)string);
        if (serverIdentity == null) {
            throw new UnknownHostException("Could not discover URL for server '" + string + "'");
        }
        return URLManager.findURL(serverIdentity);
    }

    public static String findURL(String string, Protocol protocol) throws UnknownHostException {
        ServerIdentity serverIdentity = ServerIdentityManager.findServerIdentity((String)DomainNameMaker.DOMAIN_NAME, (String)string);
        if (serverIdentity == null) {
            throw new UnknownHostException("Could not discover URL for server '" + string + "'");
        }
        return URLManager.findURL(serverIdentity, protocol);
    }

    public static String findAdministrationURL(String string) throws UnknownHostException {
        ServerIdentity serverIdentity = ServerIdentityManager.findServerIdentity((String)DomainNameMaker.DOMAIN_NAME, (String)string);
        if (serverIdentity == null) {
            throw new UnknownHostException("Could not discover administration URL for server '" + string + "'");
        }
        return URLManager.findAdministrationURL(serverIdentity);
    }

    public static String findURL(ServerIdentity serverIdentity) {
        return ChannelHelper.createURL((Channel)ServerChannelManager.findServerChannel((HostID)serverIdentity));
    }

    public static String findURL(ServerIdentity serverIdentity, Protocol protocol) {
        return ChannelHelper.createURL((Channel)ServerChannelManager.findServerChannel((HostID)serverIdentity, (Protocol)protocol));
    }

    public static String findURL(ServerIdentity serverIdentity, String string) {
        String string2 = ChannelHelper.createURL((Channel)ServerChannelManager.findServerChannel((HostID)serverIdentity, (String)string));
        if (string2 == null && (string2 = URLManager.findURL(serverIdentity, ProtocolManager.getDefaultProtocol())) == null) {
            string2 = URLManager.findURL(serverIdentity, ProtocolManager.getDefaultSecureProtocol());
        }
        return string2;
    }

    public static String findIPv4URL(ServerIdentity serverIdentity, Protocol protocol) {
        String string = ChannelHelper.createURL((Channel)ServerChannelManager.getServerChannelManager().getIPv4ServerChannel((HostID)serverIdentity, protocol));
        if (string == null && (string = ChannelHelper.createURL((Channel)ServerChannelManager.getServerChannelManager().getIPv4ServerChannel((HostID)serverIdentity, ProtocolManager.getDefaultProtocol()))) == null) {
            string = ChannelHelper.createURL((Channel)ServerChannelManager.getServerChannelManager().getIPv4ServerChannel((HostID)serverIdentity, ProtocolManager.getDefaultSecureProtocol()));
        }
        return string;
    }

    public static String findIPv6URL(ServerIdentity serverIdentity, Protocol protocol) {
        String string = ChannelHelper.createURL((Channel)ServerChannelManager.getServerChannelManager().getIPv6ServerChannel((HostID)serverIdentity, protocol));
        if (string == null && (string = ChannelHelper.createURL((Channel)ServerChannelManager.getServerChannelManager().getIPv6ServerChannel((HostID)serverIdentity, ProtocolManager.getDefaultProtocol()))) == null) {
            string = ChannelHelper.createURL((Channel)ServerChannelManager.getServerChannelManager().getIPv6ServerChannel((HostID)serverIdentity, ProtocolManager.getDefaultSecureProtocol()));
        }
        return string;
    }

    public static String findURL(ServerIdentity serverIdentity, String string, boolean bl) {
        String string2 = ChannelHelper.createURL((Channel)ServerChannelManager.findServerChannel((HostID)serverIdentity, (String)string));
        if (string2 == null) {
            Protocol protocol = ProtocolManager.getDefaultProtocol();
            Protocol protocol2 = ProtocolManager.getDefaultSecureProtocol();
            if (bl) {
                protocol = ProtocolManager.getDefaultSecureProtocol();
                protocol2 = ProtocolManager.getDefaultProtocol();
            }
            if ((string2 = URLManager.findURL(serverIdentity, protocol)) == null) {
                string2 = URLManager.findURL(serverIdentity, protocol2);
            }
        }
        return string2;
    }

    public static String findAdministrationURL(ServerIdentity serverIdentity) {
        String string = URLManager.findURL(serverIdentity, ProtocolHandlerAdmin.PROTOCOL_ADMIN);
        if (string == null && (string = URLManager.findURL(serverIdentity, ProtocolManager.getDefaultProtocol())) == null) {
            string = URLManager.findURL(serverIdentity, ProtocolManager.getDefaultSecureProtocol());
        }
        return string;
    }

    public static HttpURLConnection createAdminHttpConnection(URL uRL) throws IOException {
        if (KernelStatus.isServer()) {
            ServerChannel serverChannel = null;
            if (!KernelStatus.isConfigured()) {
                serverChannel = ServerChannelImpl.createBootstrapChannel(uRL.getProtocol());
                if (serverChannel == null) {
                    return (HttpURLConnection)uRL.openConnection();
                }
            } else if (kernelId.getQOS() == 103) {
                serverChannel = ServerChannelManager.findOutboundServerChannel((Protocol)ProtocolHandlerAdmin.PROTOCOL_ADMIN);
            } else {
                try {
                    serverChannel = ServerChannelManager.findOutboundServerChannel((Protocol)ProtocolManager.findProtocol((String)uRL.getProtocol()));
                }
                catch (UnknownProtocolException unknownProtocolException) {
                    throw new AssertionError((Object)unknownProtocolException);
                }
            }
            if (serverChannel == null || !serverChannel.isHttpEnabledForThisProtocol()) {
                throw new IOException("Admin channel does exist or does not have HTTP enabled");
            }
            if (serverChannel.supportsTLS()) {
                HttpsURLConnection httpsURLConnection = new HttpsURLConnection(uRL);
                httpsURLConnection.setSSLSocketFactory(new ChannelSSLSocketFactory(serverChannel).initializeFromThread());
                return httpsURLConnection;
            }
            weblogic.net.http.HttpURLConnection httpURLConnection = new weblogic.net.http.HttpURLConnection(uRL);
            httpURLConnection.setSocketFactory(new ChannelSocketFactory(serverChannel));
            return httpURLConnection;
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        return httpURLConnection;
    }

    public static String normalizeToAdminProtocol(String string) {
        int n = string.indexOf("://");
        Protocol protocol = ProtocolManager.getDefaultAdminProtocol();
        boolean bl = ChannelHelper.isLocalAdminChannelEnabled();
        if (n < 0) {
            String string2 = bl ? protocol.getAsURLPrefix() + "://" + string : ProtocolManager.getDefaultProtocol().getAsURLPrefix() + "://" + string;
            return string2;
        }
        String string3 = string.substring(0, n).toLowerCase(Locale.ENGLISH);
        string = string.substring(n);
        String string4 = bl && (string3.equals(PREFIX_ADMIN) || string3.equals(PREFIX_HTTP) && !protocol.isSecure() || string3.equals(PREFIX_HTTPS) && protocol.isSecure()) ? protocol.getAsURLPrefix() + string : (string3.equals(PREFIX_HTTP) || string3.equals(PREFIX_ADMIN) ? Kernel.getConfig().getDefaultProtocol() + string : (string3.startsWith(PREFIX_HTTPS) ? Kernel.getConfig().getDefaultSecureProtocol() + string : string3 + string));
        return string4;
    }

    public static String normalizeToHttpProtocol(String string) {
        int n = string.indexOf("://");
        if (n < 0) {
            return "http://" + string;
        }
        String string2 = string.substring(0, n).toLowerCase(Locale.ENGLISH);
        string = string.substring(n);
        if (string2.equals(PREFIX_ADMIN)) {
            string2 = ProtocolManager.getDefaultAdminProtocol().getAsURLPrefix();
        }
        if (string2.endsWith("s")) {
            return PREFIX_HTTPS + string;
        }
        return PREFIX_HTTP + string;
    }

    public static String normalizeToLDAPProtocol(String string) {
        int n = string.indexOf("://");
        if (n < 0) {
            return "ldap://" + string;
        }
        String string2 = string.substring(0, n).toLowerCase(Locale.ENGLISH);
        string = string.substring(n);
        if (string2.endsWith("s")) {
            return PREFIX_LDAPS + string;
        }
        return PREFIX_LDAP + string;
    }

    public static String[] getConnectedServers() {
        return URLManager.getConnectedServers(DomainNameMaker.DOMAIN_NAME);
    }

    public static String[] getDomainConnectedServers() throws RemoteException {
        RemoteChannelService remoteChannelService = RemoteChannelServiceImpl.getDomainGateway();
        if (remoteChannelService == null) {
            throw new UnknownHostException("The admin server could not be found");
        }
        return remoteChannelService.getConnectedServers();
    }

    public static String[] getConnectedServers(String string) {
        return ServerIdentityManager.getConnectedServers((String)string);
    }

    public static boolean isConnected(String string) {
        return URLManager.isConnected(string, DomainNameMaker.DOMAIN_NAME);
    }

    public static boolean isConnected(String string, String string2) {
        return ServerIdentityManager.isConnected((String)string, (String)string2);
    }

    private static final String findAdminServerURL(String string) {
        if (!KernelStatus.isServer()) {
            return string;
        }
        String string2 = null;
        String string3 = AdminPropMaker.ADMIN_HOST;
        if (string3 == null) {
            return null;
        }
        int n = string3.indexOf("://");
        if (n != -1) {
            string2 = string3.substring(0, n).toLowerCase(Locale.ENGLISH) + string3.substring(n);
        } else {
            String string4 = string == null ? Kernel.getConfig().getDefaultProtocol() : string.substring(0, string.indexOf("://"));
            string2 = string4 + "://" + string3;
        }
        if (string2.indexOf(58) == string2.lastIndexOf(58)) {
            string2 = string2 + string.substring(string.lastIndexOf(58));
        }
        return string2;
    }

    private static final void p(String string) {
        System.out.println("<URLManager>: " + string);
    }

    public static String[] findAllAddressesForHost(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = string;
        int n = string.indexOf("://");
        if (n != -1) {
            string2 = string.substring(0, n);
            string = string.substring(n + 3);
        }
        if ((n = string.indexOf("]:")) != -1) {
            string3 = string.substring(n + 2);
            string = string.substring(0, n + 1);
        } else {
            n = string.indexOf(":");
            if (n != -1) {
                string3 = string.substring(n + 1);
                string = string.substring(0, n);
            }
        }
        try {
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
            String[] stringArray = new String[inetAddressArray.length];
            for (int i = 0; i < inetAddressArray.length; ++i) {
                stringArray[i] = inetAddressArray[i] instanceof Inet6Address ? "[" + inetAddressArray[i].getHostAddress() + "]" : inetAddressArray[i].getHostAddress();
                if (string2 != null && !"".equals(string2)) {
                    stringArray[i] = string2 + "://" + stringArray[i];
                }
                if (string3 == null || "".equals(string3)) continue;
                stringArray[i] = stringArray[i] + ":" + string3;
            }
            return stringArray;
        }
        catch (Exception exception) {
            if (string.equalsIgnoreCase("localhost")) {
                return new String[]{string4};
            }
            return null;
        }
    }

    static /* synthetic */ AuthenticatedSubject access$000() {
        return kernelId;
    }

    private static class DomainNameMaker {
        private static final String DOMAIN_NAME = ManagementService.getRuntimeAccess(URLManager.access$000()).getDomainName();

        private DomainNameMaker() {
        }
    }

    private static final class AdminPropMaker {
        private static final String ADMIN_HOST = AdminPropMaker.getHostProp();

        private AdminPropMaker() {
        }

        private static final String getHostProp() {
            try {
                String string = System.getProperty(URLManager.ADMIN_HOST_PROP);
                if (string == null) {
                    string = System.getProperty(URLManager.OLD_ADMIN_HOST_PROP);
                }
                return string;
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
    }
}

