/*
 * Decompiled with CFR 0.152.
 */
package weblogic.protocol.configuration;

import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import weblogic.cluster.ClusterAddressHelper;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.NetworkAccessPointMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.ChannelHelperBase;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolHandlerAdmin;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.ServerChannelStream;
import weblogic.rjvm.RJVMLogger;
import weblogic.rmi.spi.Channel;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServerLogger;
import weblogic.server.channels.AddressUtils;
import weblogic.servlet.internal.WebService;
import weblogic.utils.UnsyncStringBuffer;

public final class ChannelHelper
extends ChannelHelperBase {
    private static boolean DEBUG = false;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static boolean checkConsistency(ServerMBean serverMBean) {
        int n;
        String[] stringArray;
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, NetworkAccessPointMBean> hashMap = new HashMap<String, NetworkAccessPointMBean>();
        if (serverMBean.getListenAddress() != null && serverMBean.getListenAddress().length() > 0) {
            stringArray = new String[]{serverMBean.getListenAddress()};
        } else {
            InetAddress[] inetAddressArray = AddressUtils.getIPAny();
            stringArray = new String[inetAddressArray.length];
            for (n = 0; n < inetAddressArray.length; ++n) {
                stringArray[n] = inetAddressArray[n].getHostAddress();
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (serverMBean.isListenPortEnabled()) {
                hashSet.add(stringArray[i] + serverMBean.getListenPort());
            }
            if (serverMBean.getSSL().isListenPortEnabled()) {
                hashSet.add(stringArray[i] + serverMBean.getSSL().getListenPort());
            }
            if (!serverMBean.isAdministrationPortEnabled()) continue;
            hashSet.add(stringArray[i] + serverMBean.getAdministrationPort());
        }
        NetworkAccessPointMBean[] networkAccessPointMBeanArray = (NetworkAccessPointMBean[])serverMBean.getNetworkAccessPoints().clone();
        Arrays.sort(networkAccessPointMBeanArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((NetworkAccessPointMBean)object).getProtocol().compareTo(((NetworkAccessPointMBean)object2).getProtocol());
            }
        });
        for (n = 0; n < networkAccessPointMBeanArray.length; ++n) {
            NetworkAccessPointMBean networkAccessPointMBean = networkAccessPointMBeanArray[n];
            if (!networkAccessPointMBean.isEnabled()) continue;
            String[] stringArray2 = new String[]{networkAccessPointMBean.getListenAddress()};
            if (stringArray2[0] != null && stringArray2[0].length() > 0) {
                try {
                    stringArray2[0] = InetAddress.getByName(stringArray2[0]).getHostAddress();
                }
                catch (UnknownHostException unknownHostException) {
                    return false;
                }
            } else {
                stringArray2 = stringArray;
            }
            for (int i = 0; i < stringArray2.length; ++i) {
                String string = stringArray2[i] + networkAccessPointMBean.getListenPort();
                if (hashSet.contains(string)) {
                    ServerLogger.logPortConflict((String)networkAccessPointMBean.getName(), (String)(networkAccessPointMBean.getProtocol() + "://" + stringArray2[i] + ":" + networkAccessPointMBean.getListenPort()), (String)"Default Channel", (String)(serverMBean.getListenAddress() + ":" + serverMBean.getListenPort()));
                    return false;
                }
                NetworkAccessPointMBean networkAccessPointMBean2 = (NetworkAccessPointMBean)hashMap.get(string);
                if (networkAccessPointMBean2 == null) {
                    hashMap.put(string, networkAccessPointMBean);
                } else if (networkAccessPointMBean2.isSDPEnabled() != networkAccessPointMBean.isSDPEnabled()) {
                    ServerLogger.logPortSDPConflict((String)networkAccessPointMBean.getName(), (String)networkAccessPointMBean2.getName(), (String)(stringArray2[i] + ":" + networkAccessPointMBean.getListenPort()));
                    return false;
                }
                String string2 = networkAccessPointMBean.getProtocol() + stringArray2[i] + networkAccessPointMBean.getListenPort();
                NetworkAccessPointMBean networkAccessPointMBean3 = (NetworkAccessPointMBean)hashMap.get(string2);
                if (networkAccessPointMBean3 == null && !networkAccessPointMBean.getProtocol().equalsIgnoreCase("ADMIN")) {
                    networkAccessPointMBean3 = (NetworkAccessPointMBean)hashMap.get("ADMIN".toLowerCase(Locale.ENGLISH) + stringArray2[i] + networkAccessPointMBean.getListenPort());
                }
                if (networkAccessPointMBean3 != null) {
                    ServerLogger.logPortConflict((String)networkAccessPointMBean.getName(), (String)(networkAccessPointMBean.getProtocol() + "://" + stringArray2[i] + ":" + networkAccessPointMBean.getListenPort()), (String)networkAccessPointMBean3.getName(), (String)(networkAccessPointMBean3.getProtocol() + "://" + stringArray2[i] + ":" + networkAccessPointMBean3.getListenPort()));
                    return false;
                }
                hashMap.put(string2, networkAccessPointMBean);
            }
        }
        if (DEBUG) {
            ChannelHelper.p(hashSet.toString());
        }
        if (DEBUG) {
            ChannelHelper.p(hashMap.toString());
        }
        return true;
    }

    public static void logChannelConfiguration(ServerMBean serverMBean) {
        boolean bl = ChannelHelper.isAdminChannelEnabled(serverMBean);
        if (serverMBean.isListenPortEnabled()) {
            RJVMLogger.logChannelConfiguration((String)serverMBean.getName(), (String)(serverMBean.getListenAddress() == null ? "*" : serverMBean.getListenAddress() + ":" + serverMBean.getListenPort()), (String)(serverMBean.getExternalDNSName() == null ? "N/A" : "<all>://" + serverMBean.getExternalDNSName() + ":" + serverMBean.getListenPort()), (boolean)serverMBean.isHttpdEnabled(), (boolean)serverMBean.isTunnelingEnabled(), (boolean)false, (!bl ? 1 : 0) != 0);
        }
        if (serverMBean.getSSL().isEnabled()) {
            RJVMLogger.logChannelConfiguration((String)serverMBean.getName(), (String)(serverMBean.getListenAddress() + ":" + serverMBean.getSSL().getListenPort() + " (SSL)"), (String)(serverMBean.getExternalDNSName() == null ? "N/A" : serverMBean.getExternalDNSName() + " (SSL)" + ":" + serverMBean.getSSL().getListenPort()), (boolean)serverMBean.isHttpdEnabled(), (boolean)serverMBean.isTunnelingEnabled(), (boolean)false, (!bl ? 1 : 0) != 0);
        }
        RJVMLogger.logChannelSettings((String)serverMBean.getName(), (int)50, (int)serverMBean.getAcceptBacklog(), (int)serverMBean.getLoginTimeoutMillis(), (int)serverMBean.getMaxMessageSize(), (int)serverMBean.getCompleteMessageTimeout(), (int)serverMBean.getIdleConnectionTimeout(), (int)serverMBean.getTunnelingClientTimeoutSecs(), (int)serverMBean.getTunnelingClientPingSecs());
        NetworkAccessPointMBean[] networkAccessPointMBeanArray = serverMBean.getNetworkAccessPoints();
        for (int i = 0; i < networkAccessPointMBeanArray.length; ++i) {
            NetworkAccessPointMBean networkAccessPointMBean = networkAccessPointMBeanArray[i];
            if (!networkAccessPointMBean.isEnabled()) continue;
            RJVMLogger.logChannelConfiguration((String)networkAccessPointMBean.getName(), (String)(networkAccessPointMBean.getProtocol() + "://" + networkAccessPointMBean.getListenAddress() + ":" + networkAccessPointMBean.getListenPort()), (String)(networkAccessPointMBean.getProtocol() + "://" + networkAccessPointMBean.getPublicAddress() + ":" + networkAccessPointMBean.getPublicPort()), (boolean)networkAccessPointMBean.isHttpEnabledForThisProtocol(), (boolean)networkAccessPointMBean.isTunnelingEnabled(), (boolean)networkAccessPointMBean.isOutboundEnabled(), (!bl || networkAccessPointMBean.getProtocol().equalsIgnoreCase("ADMIN") ? 1 : 0) != 0);
            RJVMLogger.logChannelSettings((String)networkAccessPointMBean.getName(), (int)networkAccessPointMBean.getChannelWeight(), (int)networkAccessPointMBean.getAcceptBacklog(), (int)networkAccessPointMBean.getLoginTimeoutMillis(), (int)networkAccessPointMBean.getMaxMessageSize(), (int)networkAccessPointMBean.getCompleteMessageTimeout(), (int)networkAccessPointMBean.getIdleConnectionTimeout(), (int)networkAccessPointMBean.getTunnelingClientTimeoutSecs(), (int)networkAccessPointMBean.getTunnelingClientPingSecs());
        }
    }

    public static boolean isAdminChannelEnabled(ServerMBean serverMBean) {
        if (ManagementService.getRuntimeAccess(kernelId).getDomain().isAdministrationPortEnabled()) {
            return true;
        }
        NetworkAccessPointMBean[] networkAccessPointMBeanArray = serverMBean.getNetworkAccessPoints();
        for (int i = 0; i < networkAccessPointMBeanArray.length; ++i) {
            if (!networkAccessPointMBeanArray[i].isEnabled() || !networkAccessPointMBeanArray[i].getProtocol().equalsIgnoreCase("ADMIN")) continue;
            return true;
        }
        return false;
    }

    public static boolean isSSLChannelEnabled(ServerMBean serverMBean) {
        if (serverMBean.getSSL().isListenPortEnabled()) {
            return true;
        }
        NetworkAccessPointMBean[] networkAccessPointMBeanArray = serverMBean.getNetworkAccessPoints();
        for (int i = 0; i < networkAccessPointMBeanArray.length; ++i) {
            if (!ChannelHelper.isNAPSecure(networkAccessPointMBeanArray[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isNAPSecure(NetworkAccessPointMBean networkAccessPointMBean) {
        byte by = ProtocolManager.getProtocolByName((String)networkAccessPointMBean.getProtocol()).getQOS();
        return by == 102 || by == 103;
    }

    public static String getLocalAdministrationURL() {
        String string = ChannelHelper.getURL(ProtocolHandlerAdmin.PROTOCOL_ADMIN);
        if (string == null && (string = ChannelHelper.getURL(ProtocolManager.getDefaultProtocol())) == null) {
            string = ChannelHelper.getURL(ProtocolManager.getDefaultSecureProtocol());
        }
        return string;
    }

    public static String getURL(Protocol protocol) {
        return ChannelHelper.createURL((Channel)ServerChannelManager.findLocalServerChannel((Protocol)protocol));
    }

    public static String getIPv4URL(Protocol protocol) {
        return ChannelHelper.createURL((Channel)ServerChannelManager.findIPv4LocalServerChannel((Protocol)protocol));
    }

    public static String getIPv6URL(Protocol protocol) {
        return ChannelHelper.createURL((Channel)ServerChannelManager.findIPv6LocalServerChannel((Protocol)protocol));
    }

    public static String createCodebaseURL(Channel channel) {
        UnsyncStringBuffer unsyncStringBuffer = new UnsyncStringBuffer();
        if (channel.supportsTLS()) {
            unsyncStringBuffer.append("https://");
        } else {
            unsyncStringBuffer.append("http://");
        }
        unsyncStringBuffer.append(channel.getPublicAddress()).append(":").append(channel.getPublicPort());
        if (!WebService.getInternalWebAppContextPath().startsWith("/")) {
            unsyncStringBuffer.append('/');
        }
        unsyncStringBuffer.append(WebService.getInternalWebAppContextPath()).append("/classes").append('/');
        return unsyncStringBuffer.toString();
    }

    public static String createClusterURL(ServerChannel serverChannel) {
        return ClusterAddressHelper.getClusterAddressURL(serverChannel);
    }

    public static String createDefaultClusterURL() {
        return ClusterAddressHelper.getClusterAddressURL(ServerChannelManager.findDefaultLocalServerChannel());
    }

    public static String getClusterURL(ObjectOutput objectOutput) {
        ServerChannel serverChannel;
        if (objectOutput instanceof ServerChannelStream && (serverChannel = ((ServerChannelStream)objectOutput).getServerChannel()) != null) {
            return ChannelHelper.createClusterURL(serverChannel);
        }
        return ChannelHelper.createDefaultClusterURL();
    }

    public static boolean isMultipleReplicationChannelsConfigured(ServerMBean serverMBean) {
        ClusterMBean clusterMBean;
        String string = serverMBean.getReplicationPorts();
        if (string != null && string.length() > 0 && (clusterMBean = serverMBean.getCluster()) != null) {
            NetworkAccessPointMBean[] networkAccessPointMBeanArray;
            String string2 = clusterMBean.getReplicationChannel();
            for (NetworkAccessPointMBean networkAccessPointMBean : networkAccessPointMBeanArray = serverMBean.getNetworkAccessPoints()) {
                if (!networkAccessPointMBean.isEnabled() || !networkAccessPointMBean.getName().equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private static void p(String string) {
        System.out.println("<ChannelHelper>: " + string);
    }
}

