/*
 * Decompiled with CFR 0.152.
 */
package weblogic.protocol.configuration;

import java.security.AccessController;
import javax.management.InvalidAttributeValueException;
import weblogic.kernel.NetworkAccessPointMBeanStub;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.Protocol;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class NetworkAccessPointDefaultMBean
extends NetworkAccessPointMBeanStub {
    private final Protocol p;
    private final String name;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public NetworkAccessPointDefaultMBean(Protocol protocol, ServerMBean serverMBean) {
        super(protocol.getProtocolName(), serverMBean);
        this.p = protocol;
        this.name = this.p.getQOS() == 103 ? "DefaultAdministration" : (this.p.isSecure() ? "DefaultSecure" : "Default");
    }

    private final ServerMBean getConfig() {
        return (ServerMBean)this.config;
    }

    public String getName() {
        return this.name;
    }

    public String getListenAddress() {
        return this.getConfig().getListenAddress();
    }

    public String getPublicAddress() {
        String string = this.getConfig().getExternalDNSName();
        return string == null ? this.getListenAddress() : string;
    }

    public int getListenPort() {
        if (this.p.getQOS() == 103) {
            return this.getConfig().getAdministrationPort();
        }
        if (this.p.isSecure()) {
            return this.getConfig().getSSL().getListenPort();
        }
        return this.getConfig().getListenPort();
    }

    public int getPublicPort() {
        return this.getListenPort();
    }

    public boolean isHttpEnabledForThisProtocol() {
        return this.getConfig().isHttpdEnabled();
    }

    public int getAcceptBacklog() {
        return this.getConfig().getAcceptBacklog();
    }

    public int getMaxBackoffBetweenFailures() {
        return this.getConfig().getMaxBackoffBetweenFailures();
    }

    public int getLoginTimeoutMillis() {
        if ((this.p.getQOS() == 103 || this.p.isSecure()) && this.getConfig().getSSL() != null) {
            return this.getConfig().getSSL().getLoginTimeoutMillis();
        }
        return this.getConfig().getLoginTimeoutMillis();
    }

    public int getTunnelingClientPingSecs() {
        return this.getConfig().getTunnelingClientPingSecs();
    }

    public int getTunnelingClientTimeoutSecs() {
        return this.getConfig().getTunnelingClientTimeoutSecs();
    }

    public boolean isTunnelingEnabled() {
        return this.getConfig().isTunnelingEnabled();
    }

    public boolean isOutboundEnabled() {
        return this.p.getQOS() == 103 ? true : this.getConfig().isOutboundEnabled();
    }

    public boolean isOutboundPrivateKeyEnabled() {
        return this.getConfig().isOutboundPrivateKeyEnabled();
    }

    public int getChannelWeight() {
        return 50;
    }

    public String getClusterAddress() {
        String string = this.getConfig().getCluster() != null ? this.getConfig().getCluster().getClusterAddress() : null;
        return string == null ? this.getPublicAddress() : string;
    }

    public boolean isEnabled() {
        if (this.p.getQOS() == 103) {
            return ManagementService.getRuntimeAccess(kernelId).getDomain().isAdministrationPortEnabled();
        }
        if (this.p.isSecure()) {
            if (this.getConfig().getSSL() != null) {
                return this.getConfig().getSSL().isEnabled() && this.getConfig().getSSL().isListenPortEnabled();
            }
            return false;
        }
        return this.getConfig().isListenPortEnabled();
    }

    public void setEnabled(boolean bl) throws InvalidAttributeValueException {
    }

    public int getMaxConnectedClients() {
        return Integer.MAX_VALUE;
    }

    public void setMaxConnectedClients(int n) throws InvalidAttributeValueException {
    }

    public boolean isTwoWaySSLEnabled() {
        if (this.p.isSecure() && this.getConfig().getSSL() != null) {
            return this.getConfig().getSSL().isTwoWaySSLEnabled();
        }
        return false;
    }

    public void setTwoWaySSLEnabled(boolean bl) {
    }

    public boolean isChannelIdentityCustomized() {
        return false;
    }

    public void setChannelIdentityCustomized(boolean bl) {
    }

    public String getCustomPrivateKeyAlias() {
        if (this.p.isSecure() && this.getConfig().getSSL() != null) {
            return this.getConfig().getSSL().getServerPrivateKeyAlias();
        }
        return null;
    }

    public void setCustomPrivateKeyAlias(String string) {
    }

    public String getCustomPrivateKeyPassPhrase() {
        if (this.p.isSecure() && this.getConfig().getSSL() != null) {
            return this.getConfig().getSSL().getServerPrivateKeyPassPhrase();
        }
        return null;
    }

    public void setCustomPrivateKeyPassPhrase(String string) {
    }

    public boolean isClientCertificateEnforced() {
        if (this.p.isSecure() && this.getConfig().getSSL() != null) {
            return this.getConfig().getSSL().isClientCertificateEnforced();
        }
        return false;
    }

    public void setClientCertificateEnforced(boolean bl) {
    }

    public String getExternalDNSName() {
        return this.getPublicAddress();
    }

    public String getOutboundPrivateKeyAlias() {
        if (this.p.isSecure() && this.getConfig().getSSL() != null) {
            return this.getConfig().getSSL().getOutboundPrivateKeyAlias();
        }
        return null;
    }

    public String getOutboundPrivateKeyPassPhrase() {
        if (this.p.isSecure() && this.getConfig().getSSL() != null) {
            return this.getConfig().getSSL().getOutboundPrivateKeyPassPhrase();
        }
        return null;
    }
}

