/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.servlet.WebLogicServletContext;

public final class InternalWebAppListener
implements ServletContextListener {
    private final Map EMPTY_MAP = new HashMap();
    private static final String TUNNEL_PACKAGE = "weblogic.rjvm.http.";
    private static final String IIOP_TUNNEL_PACKAGE = "weblogic.corba.iiop.http.";
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        WebLogicServletContext webLogicServletContext = (WebLogicServletContext)servletContextEvent.getServletContext();
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        try {
            webLogicServletContext.registerServlet("HTTPClntSend", "weblogic.rjvm.http.TunnelSendServlet", new String[]{"/HTTPClntSend/*"}, this.EMPTY_MAP, -1);
            webLogicServletContext.registerServlet("HTTPClntRecv", "weblogic.rjvm.http.TunnelRecvServlet", new String[]{"/HTTPClntRecv/*"}, this.EMPTY_MAP, -1);
            webLogicServletContext.registerServlet("HTTPClntLogin", "weblogic.rjvm.http.TunnelLoginServlet", new String[]{"/HTTPClntLogin/*"}, this.EMPTY_MAP, -1);
            webLogicServletContext.registerServlet("HTTPClntClose", "weblogic.rjvm.http.TunnelCloseServlet", new String[]{"/HTTPClntClose/*"}, this.EMPTY_MAP, -1);
        }
        catch (DeploymentException deploymentException) {
            throw new AssertionError((Object)("Unexpected exception registering t3 tunnelling servlets" + (Object)((Object)deploymentException)));
        }
        try {
            if (serverMBean.isIIOPEnabled()) {
                webLogicServletContext.registerServlet("ClientSend", "weblogic.corba.iiop.http.TunnelSendServlet", new String[]{"/iiop/ClientSend/*"}, this.EMPTY_MAP, -1);
                webLogicServletContext.registerServlet("ClientRecv", "weblogic.corba.iiop.http.TunnelRecvServlet", new String[]{"/iiop/ClientRecv/*"}, this.EMPTY_MAP, -1);
                webLogicServletContext.registerServlet("ClientLogin", "weblogic.corba.iiop.http.TunnelLoginServlet", new String[]{"/iiop/ClientLogin/*"}, this.EMPTY_MAP, -1);
                webLogicServletContext.registerServlet("ClientClose", "weblogic.corba.iiop.http.TunnelCloseServlet", new String[]{"/iiop/ClientClose/*"}, this.EMPTY_MAP, -1);
            }
        }
        catch (DeploymentException deploymentException) {
            throw new AssertionError((Object)("Unexpected exception registering IIOP tunnelling servlets" + (Object)((Object)deploymentException)));
        }
        try {
            if (serverMBean.isCOMEnabled()) {
                webLogicServletContext.registerServlet("COM", "weblogic.com.GetORMServlet", new String[]{"/com/*"}, this.EMPTY_MAP, -1);
            }
        }
        catch (DeploymentException deploymentException) {
            throw new AssertionError((Object)("Unexpected exception COM Servlet" + (Object)((Object)deploymentException)));
        }
        try {
            if (serverMBean.getIIOP().getEnableIORServlet()) {
                webLogicServletContext.registerServlet("getior", "weblogic.servlet.utils.iiop.GetIORServlet", new String[]{"/getior/*"}, this.EMPTY_MAP, -1);
            }
        }
        catch (DeploymentException deploymentException) {
            throw new AssertionError((Object)("Unexpected exception IORServlet " + (Object)((Object)deploymentException)));
        }
        try {
            if (!serverMBean.isClasspathServletDisabled()) {
                webLogicServletContext.registerServlet("classes", "weblogic.servlet.ClasspathServlet", new String[]{"/classes/*"}, this.EMPTY_MAP, -1);
            }
        }
        catch (DeploymentException deploymentException) {
            throw new AssertionError((Object)("Unexpected exception registering classpath servlet" + (Object)((Object)deploymentException)));
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

