/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import java.net.UnknownHostException;
import java.security.AccessController;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.provider.ManagementService;
import weblogic.rjvm.JVMID;
import weblogic.rjvm.t3.ProtocolHandlerT3;
import weblogic.rjvm.t3.ProtocolHandlerT3S;
import weblogic.rmi.utils.io.Codebase;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.servlet.internal.WebService;

public class RJVMService
extends AbstractServerService {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void start() throws ServiceFailureException {
        try {
            this.setJVMID();
            this.initGenericClassLoader();
        }
        catch (UnknownHostException unknownHostException) {
            throw new ServiceFailureException((Throwable)unknownHostException);
        }
        catch (ConfigurationException configurationException) {
            throw new ServiceFailureException((Throwable)configurationException);
        }
    }

    public void setJVMID() throws UnknownHostException, ConfigurationException {
        String string = ManagementService.getRuntimeAccess(kernelId).getServer().getListenAddress();
        String string2 = ManagementService.getRuntimeAccess(kernelId).getServer().getExternalDNSName();
        ProtocolHandlerT3.getProtocolHandler();
        ProtocolHandlerT3S.getProtocolHandler();
        JVMID.setLocalID((String)string, (String)string2, (String)ManagementService.getRuntimeAccess(kernelId).getDomainName(), (String)ManagementService.getRuntimeAccess(kernelId).getServerName());
    }

    private void initGenericClassLoader() {
        Codebase.setDefaultCodebase((String)this.getServerURL(false));
    }

    private String getServerURL(boolean bl) {
        JVMID jVMID = JVMID.localID();
        String string = jVMID.getClusterAddress();
        if (string == null) {
            string = jVMID.address().getHostAddress();
        }
        int n = bl ? ManagementService.getRuntimeAccess(kernelId).getServer().getSSL().getListenPort() : ManagementService.getRuntimeAccess(kernelId).getServer().getListenPort();
        StringBuffer stringBuffer = new StringBuffer(bl ? "https://" : "http://");
        stringBuffer.append(string).append(':').append(n).append(WebService.getInternalWebAppContextPath()).append("/classes").append('/');
        return stringBuffer.toString();
    }
}

