/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm.http;

import com.bea.security.utils.random.SecureRandomData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import weblogic.common.internal.VersionInfo;
import weblogic.kernel.KernelStatus;
import weblogic.management.commandline.tools.AdminToolHelper;
import weblogic.protocol.OutgoingMessage;
import weblogic.protocol.ServerChannel;
import weblogic.rjvm.MsgAbbrevJVMConnection;
import weblogic.rjvm.RJVMEnvironment;
import weblogic.rjvm.RJVMLogger;
import weblogic.rjvm.TransportUtils;
import weblogic.utils.Debug;
import weblogic.utils.io.Chunk;

public class HTTPClientJVMConnection
extends MsgAbbrevJVMConnection
implements Runnable {
    private static final boolean ASSERT = true;
    private static final boolean DEBUG = false;
    private static final String URL_EXTENSION = "/a.tun";
    private boolean closed;
    private String host;
    private int port;
    private final ServerChannel networkChannel;
    private String connectionID = null;
    private String cookie = null;

    public final ServerChannel getChannel() {
        return this.networkChannel;
    }

    private static void drainStream(InputStream inputStream) throws IOException {
        if (inputStream != null) {
            int n = 0;
            while ((n = inputStream.read()) != -1) {
            }
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Chunk readPacket(InputStream inputStream) throws IOException {
        Chunk chunk = Chunk.getChunk();
        try {
            int n = Chunk.chunkFully((Chunk)chunk, (InputStream)inputStream);
            Debug.assertion((n > 4 ? 1 : 0) != 0);
        }
        finally {
            inputStream.close();
        }
        return chunk;
    }

    HTTPClientJVMConnection(ServerChannel serverChannel) {
        this.networkChannel = serverChannel;
        this.closed = true;
    }

    URLConnection createURLConnection(URL uRL) throws IOException {
        return RJVMEnvironment.getEnvironment().createURLConnection(uRL, this.networkChannel);
    }

    public final String toString() {
        return super.toString() + " - id: '" + this.connectionID + "', host: '" + this.host + "', port: '" + this.port + " closed: '" + this.closed + "'";
    }

    public final InetAddress getLocalAddress() {
        return null;
    }

    public final int getLocalPort() {
        return -1;
    }

    private final String getRequestArgs() {
        return "?connectionID=" + this.connectionID + "&rand=" + SecureRandomData.getInstance().getRandomNonNegativeLong();
    }

    private final void handleNullResponse(URLConnection uRLConnection) throws ProtocolException {
        throw new ProtocolException("Tunneling result unspecified - is the HTTP server at host: '" + this.host + "' and port: '" + this.port + "' a WebLogic Server?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void connect(InetAddress inetAddress, int n) throws IOException {
        URLConnection uRLConnection;
        if (!this.closed) {
            throw new ProtocolException("Already connected");
        }
        this.host = null;
        this.port = n;
        this.host = inetAddress.getHostName();
        String string = URLEncoder.encode(this.getProtocol().getProtocolName() + " dummy WLREQS " + VersionInfo.theOne().getReleaseVersion() + " dummy \n");
        URL uRL = new URL(this.getProtocol().getProtocolName(), this.host, n, KernelStatus.getTunellingURL((String)"/bea_wls_internal/HTTPClntLogin") + URL_EXTENSION + "?wl-login=" + string + "&rand=" + SecureRandomData.getInstance().getRandomNonNegativeLong() + "&" + "AS" + "=" + ABBREV_TABLE_SIZE + "&" + "HL" + "=" + 19);
        try {
            uRLConnection = this.createURLConnection(uRL);
        }
        catch (IOException iOException) {
            RJVMLogger.logOpenFailed((Exception)iOException);
            return;
        }
        uRLConnection.setUseCaches(false);
        InputStream inputStream = null;
        try {
            inputStream = uRLConnection.getInputStream();
            int n2 = 1;
            String string2 = null;
            while ((string2 = uRLConnection.getHeaderFieldKey(n2++)) != null) {
                if (!string2.equals("Set-Cookie")) continue;
                string2 = uRLConnection.getHeaderField(n2 - 1);
                int n3 = string2.indexOf(";");
                if (n3 != -1) {
                    string2 = string2.substring(0, n3);
                }
                if (this.cookie == null) {
                    this.cookie = string2;
                    continue;
                }
                this.cookie = this.cookie + "; " + string2;
            }
            String string3 = uRLConnection.getHeaderField("WL-Result");
            if (string3 == null) {
                this.handleNullResponse(uRLConnection);
            }
            if (!string3.equals("OK")) {
                throw new ProtocolException("Tunneling result not OK, result: '" + string3 + "'");
            }
            String string4 = uRLConnection.getHeaderField("WL-Version");
            if (string4 == null) {
                this.doDownGrade();
            }
            this.connectionID = uRLConnection.getHeaderField("Conn-Id");
            if (this.connectionID == null) {
                throw new ProtocolException("Tunneling could not ascertain a connection ID from the server");
            }
            this.readConnectionParams(inputStream);
            this.closed = false;
        }
        finally {
            HTTPClientJVMConnection.drainStream(inputStream);
        }
    }

    private void readConnectionParams(InputStream inputStream) throws IOException {
        TransportUtils.BootstrapResult bootstrapResult = TransportUtils.readBootstrapParams((InputStream)inputStream);
        if (!bootstrapResult.isSuccess()) {
            throw new ProtocolException("Invalid parameter: " + bootstrapResult.getInvalidLine());
        }
        this.init(bootstrapResult.getAbbrevSize(), bootstrapResult.getHeaderLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void run() {
        try {
            while (!this.closed) {
                this.receiveAndDispatch();
            }
            return;
        }
        catch (ThreadDeath threadDeath) {
            try {
                this.gotExceptionReceiving(threadDeath);
                this.close();
            }
            finally {
                throw threadDeath;
            }
        }
        catch (Throwable throwable) {
            if (AdminToolHelper.shutdownCommand) {
                AdminToolHelper.shutdownCommand = false;
            } else {
                RJVMLogger.logExecuteFailed((Throwable)throwable);
            }
            this.gotExceptionReceiving(throwable);
            this.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendMsg(OutgoingMessage outgoingMessage) throws IOException {
        if (this.closed) {
            throw new IOException("Connection closed");
        }
        URL uRL = new URL(this.getProtocol().getProtocolName(), this.host, this.port, KernelStatus.getTunellingURL((String)"/bea_wls_internal/HTTPClntSend") + URL_EXTENSION + this.getRequestArgs());
        URLConnection uRLConnection = this.createURLConnection(uRL);
        uRLConnection.setUseCaches(false);
        uRLConnection.setRequestProperty("Content-Type", "application/octet-stream");
        if (this.cookie != null) {
            uRLConnection.setRequestProperty("Cookie", this.cookie);
        }
        InputStream inputStream = null;
        try {
            uRLConnection.setDoOutput(true);
            OutputStream outputStream = uRLConnection.getOutputStream();
            outgoingMessage.writeTo(outputStream);
            outputStream.flush();
            inputStream = uRLConnection.getInputStream();
            String string = uRLConnection.getHeaderField("WL-Result");
            if (string == null) {
                this.handleNullResponse(uRLConnection);
            }
            if (!string.equals("OK")) {
                throw new ProtocolException("Tunneling result not OK, result: '" + string + "', id: '" + this.connectionID + "'");
            }
        }
        catch (Throwable throwable) {
            HTTPClientJVMConnection.drainStream(inputStream);
            throw throwable;
        }
        HTTPClientJVMConnection.drainStream(inputStream);
    }

    public final void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }

    private final synchronized void receiveAndDispatch() throws IOException {
        if (this.closed) {
            return;
        }
        while (!this.closed) {
            URL uRL = new URL(this.getProtocol().getProtocolName(), this.host, this.port, KernelStatus.getTunellingURL((String)"/bea_wls_internal/HTTPClntRecv") + URL_EXTENSION + this.getRequestArgs());
            URLConnection uRLConnection = this.createURLConnection(uRL);
            uRLConnection.setUseCaches(false);
            if (this.cookie != null) {
                uRLConnection.setRequestProperty("Cookie", this.cookie);
            }
            InputStream inputStream = uRLConnection.getInputStream();
            String string = uRLConnection.getHeaderField("WL-Result");
            if (string == null) {
                this.handleNullResponse(uRLConnection);
            }
            if (string.equals("RETRY")) {
                inputStream.close();
                continue;
            }
            if (!string.equals("OK")) {
                throw new ProtocolException("Tunneling result not OK, result: '" + string + "', id: '" + this.connectionID + "'");
            }
            super.dispatch(HTTPClientJVMConnection.readPacket(inputStream));
        }
        return;
    }
}

