/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.runtime.SocketRuntime;
import weblogic.protocol.MessageReceiverStatistics;
import weblogic.protocol.MessageSenderStatistics;
import weblogic.protocol.OutgoingMessage;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.rjvm.ConnectionManager;
import weblogic.rjvm.MsgAbbrevJVMConnection;
import weblogic.rjvm.RJVMLogger;
import weblogic.rjvm.http.HTTPSServerJVMConnection;
import weblogic.rjvm.http.Utils;
import weblogic.security.service.ContextHandler;
import weblogic.server.channels.ServerChannelImpl;
import weblogic.server.channels.ServerConnectionRuntimeImpl;
import weblogic.server.channels.SocketRuntimeImpl;
import weblogic.servlet.FutureServletResponse;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.VirtualConnection;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.Debug;
import weblogic.utils.collections.CircularQueue;
import weblogic.utils.io.Chunk;

class HTTPServerJVMConnection
extends MsgAbbrevJVMConnection {
    private static final boolean DEBUG = false;
    private static final boolean ASSERT = true;
    private static final DebugLogger debugMessaging = DebugLogger.getDebugLogger((String)"DebugMessaging");
    private static final DebugLogger debugTunnelingConnection = DebugLogger.getDebugLogger((String)"DebugTunnelingConnection");
    private static final DebugLogger debugTunnelingConnectionTimeout = DebugLogger.getDebugLogger((String)"DebugTunnelingConnectionTimeout");
    private SocketRuntime sockRuntime;
    private VirtualConnection connection;
    private static final ConcurrentHashMap channelOpenSocksMap = new ConcurrentHashMap();
    private static long idCount = 0L;
    private final String sockID = HTTPServerJVMConnection.getNextID();
    private final CircularQueue queue = new CircularQueue();
    private FutureServletResponse pending;
    private long lastRecv;
    private boolean closed;
    private int localPort;
    private InetAddress localAddress = null;

    private static void initialize(ServerChannel serverChannel) {
        int n = serverChannel.getTunnelingClientPingSecs() * 1000;
        TimerManagerFactory.getTimerManagerFactory().getTimerManager("HTTPTunScavanger", "weblogic.kernel.System").schedule((TimerListener)new TunnelScavenger(serverChannel), (long)n, (long)n);
    }

    private static synchronized String getNextID() {
        return String.valueOf(idCount++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String acceptJVMConnection(HttpServletRequest httpServletRequest, int n, int n2, HttpServletResponse httpServletResponse) throws ProtocolException {
        ConcurrentHashMap<String, HTTPServerJVMConnection> concurrentHashMap;
        HTTPServerJVMConnection hTTPServerJVMConnection;
        ServletRequestImpl servletRequestImpl = (ServletRequestImpl)httpServletRequest;
        ServerChannel serverChannel = servletRequestImpl.getConnection().getChannel();
        if (!serverChannel.isTunnelingEnabled()) {
            throw new ProtocolException("HTTP tunneling is disabled");
        }
        SocketRuntimeImpl socketRuntimeImpl = new SocketRuntimeImpl(servletRequestImpl.getConnection().getSocketRuntime());
        String string = httpServletRequest.getScheme();
        if ("https".equalsIgnoreCase(string)) {
            hTTPServerJVMConnection = new HTTPSServerJVMConnection(httpServletRequest, n, n2, socketRuntimeImpl, servletRequestImpl.getConnection());
            if (ChannelHelper.isAdminChannel((ServerChannel)serverChannel)) {
                hTTPServerJVMConnection.setAdminQOS();
            }
        } else if ("http".equalsIgnoreCase(string)) {
            hTTPServerJVMConnection = new HTTPServerJVMConnection(n, n2, socketRuntimeImpl, servletRequestImpl.getConnection());
        } else {
            throw new ProtocolException("Unknown protocol: '" + string + "'");
        }
        hTTPServerJVMConnection.setLocalPort(httpServletRequest.getServerPort());
        if (httpServletResponse != null) {
            hTTPServerJVMConnection.setLocalAddress(servletRequestImpl.getConnection().getSocket().getLocalAddress());
        }
        if ((concurrentHashMap = (ConcurrentHashMap<String, HTTPServerJVMConnection>)channelOpenSocksMap.get(serverChannel)) == null) {
            ConcurrentHashMap concurrentHashMap2 = channelOpenSocksMap;
            synchronized (concurrentHashMap2) {
                concurrentHashMap = (ConcurrentHashMap)channelOpenSocksMap.get(serverChannel);
                if (concurrentHashMap == null) {
                    HTTPServerJVMConnection.initialize(serverChannel);
                    concurrentHashMap = new ConcurrentHashMap<String, HTTPServerJVMConnection>();
                    channelOpenSocksMap.put(serverChannel, concurrentHashMap);
                }
            }
        }
        concurrentHashMap.put(hTTPServerJVMConnection.sockID, hTTPServerJVMConnection);
        if (debugTunnelingConnection.isDebugEnabled()) {
            RJVMLogger.logDebug((String)("Opened connection - id: '" + hTTPServerJVMConnection.sockID + "'"));
        }
        return hTTPServerJVMConnection.sockID;
    }

    static HTTPServerJVMConnection findByID(String string) {
        for (ConcurrentHashMap concurrentHashMap : channelOpenSocksMap.values()) {
            if (!concurrentHashMap.containsKey(string)) continue;
            return (HTTPServerJVMConnection)((Object)concurrentHashMap.get(string));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Chunk readPacket(HttpServletRequest httpServletRequest) throws IOException {
        Chunk chunk = Chunk.getChunk();
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        Debug.assertion((servletInputStream != null ? 1 : 0) != 0);
        try {
            int n = Chunk.chunkFully((Chunk)chunk, (InputStream)servletInputStream);
            if (n < 4) {
                throw new ProtocolException("Fewer than: '4' bytes read - nread: '" + n + "', content-length: '" + httpServletRequest.getContentLength() + "', method: '" + httpServletRequest.getMethod() + "', uri: '" + httpServletRequest.getRequestURI() + "', path info: '" + httpServletRequest.getPathInfo() + "', query params: '" + httpServletRequest.getQueryString() + "'");
            }
        }
        finally {
            servletInputStream.close();
        }
        return chunk;
    }

    HTTPServerJVMConnection(int n, int n2, SocketRuntime socketRuntime, VirtualConnection virtualConnection) {
        this.init(n, n2);
        this.closed = false;
        this.lastRecv = System.currentTimeMillis();
        this.connection = virtualConnection;
        this.sockRuntime = socketRuntime;
        ServerConnectionRuntimeImpl serverConnectionRuntimeImpl = new ServerConnectionRuntimeImpl((MessageSenderStatistics)this, (MessageReceiverStatistics)this, socketRuntime);
        ServerChannel serverChannel = this.getChannel();
        if (serverChannel instanceof ServerChannelImpl && ((ServerChannelImpl)serverChannel).getRuntime() != null) {
            ((ServerChannelImpl)serverChannel).getRuntime().addServerConnectionRuntime(serverConnectionRuntimeImpl);
        }
        this.setDispatcher(ConnectionManager.create(null));
    }

    public final String toString() {
        return super.toString() + " - id: '" + this.sockID + "', closed: '" + this.closed + "', lastRecv: '" + this.lastRecv + "'";
    }

    public final void setLocalAddress(InetAddress inetAddress) {
        this.localAddress = inetAddress;
    }

    public final InetAddress getLocalAddress() {
        return this.localAddress;
    }

    final void setLocalPort(int n) {
        this.localPort = n;
    }

    public final ServerChannel getChannel() {
        return this.connection.getChannel();
    }

    public final ContextHandler getContextHandler() {
        return this.connection.getContextHandler();
    }

    public final int getLocalPort() {
        if (this.localPort == 0) {
            return -1;
        }
        return this.localPort;
    }

    final int getQueueCount() {
        return this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkIsDead() {
        ServerChannel serverChannel = this.getChannel();
        int n = serverChannel.getTunnelingClientTimeoutSecs() * 1000;
        if (n == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = l - this.lastRecv;
        if ((long)n >= l2) {
            return;
        }
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)channelOpenSocksMap.get(serverChannel);
        if (this.pending == null) {
            concurrentHashMap.remove(this.sockID);
            this.closed = true;
            String string = "Timed out HTTP tunneling connection: '" + (Object)((Object)this) + "' because it had been unavailable for: '" + l2 / 1000L + "' seconds, timeout of: '" + n / 1000 + "' seconds.";
            this.gotExceptionReceiving(new IOException(string));
            if (debugTunnelingConnectionTimeout.isDebugEnabled()) {
                RJVMLogger.logDebug((String)string);
            }
            return;
        }
        try {
            if (debugTunnelingConnectionTimeout.isDebugEnabled()) {
                RJVMLogger.logDebug((String)("Pinging HTTP tunneling connection: '" + (Object)((Object)this) + "' because it had been idle for: '" + l2 / 1000L + "' seconds, timeout of: '" + n / 1000 + "' seconds."));
            }
            this.lastRecv = l;
            this.pending.setHeader("WL-Result", "RETRY");
            this.pending.getOutputStream().print("RETRY");
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                this.pending.send();
            }
            catch (IOException iOException) {}
            this.pending = null;
        }
    }

    final synchronized OutgoingMessage getNextMessage() {
        this.lastRecv = System.currentTimeMillis();
        return (OutgoingMessage)this.queue.remove();
    }

    public final void connect(InetAddress inetAddress, int n) throws IOException {
        throw new ProtocolException("HTTPServerJVMConnection doesn't connect!");
    }

    final synchronized void registerPending(FutureServletResponse futureServletResponse) {
        if (this.closed) {
            try {
                Utils.sendDeadResponse((HttpServletResponse)futureServletResponse);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.lastRecv = System.currentTimeMillis();
        Debug.assertion((this.pending == null ? 1 : 0) != 0);
        this.pending = futureServletResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void sendMsg(OutgoingMessage outgoingMessage) throws IOException {
        if (this.closed) {
            throw new IOException("HTTPServerJVMConnection closed");
        }
        if (this.pending == null) {
            if (!this.queue.add((Object)outgoingMessage)) {
                this.close();
                throw new IOException();
            }
            return;
        }
        this.lastRecv = System.currentTimeMillis();
        try {
            this.pending.setContentType("application/octet-stream");
            this.pending.setContentLength(outgoingMessage.getLength());
            this.pending.setHeader("WL-Result", "OK");
            ServletOutputStream servletOutputStream = this.pending.getOutputStream();
            outgoingMessage.writeTo((OutputStream)servletOutputStream);
        }
        finally {
            try {
                this.pending.send();
            }
            finally {
                this.pending = null;
            }
        }
    }

    final void dispatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Socket is closed");
        }
        super.dispatch(HTTPServerJVMConnection.readPacket(httpServletRequest));
    }

    final synchronized boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void close() {
        ServerChannel serverChannel;
        if (this.closed) {
            return;
        }
        this.closed = true;
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)channelOpenSocksMap.get(this.getChannel());
        concurrentHashMap.remove(this.sockID);
        if (debugTunnelingConnection.isDebugEnabled()) {
            RJVMLogger.logDebug((String)("Closing JVM socket: '" + (Object)((Object)this) + "'" + new Throwable("Stack trace")));
        }
        if (this.pending != null) {
            try {
                Utils.sendDeadResponse((HttpServletResponse)this.pending);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    this.pending.send();
                }
                catch (IOException iOException) {}
                this.pending = null;
            }
        }
        if ((serverChannel = this.getChannel()) instanceof ServerChannelImpl && ((ServerChannelImpl)serverChannel).getRuntime() != null) {
            ((ServerChannelImpl)serverChannel).getRuntime().removeServerConnectionRuntime(this.sockRuntime);
        }
    }

    static final class TunnelScavenger
    implements NakedTimerListener {
        ServerChannel networkChannel;
        ServerChannelImpl networkChannelimpl;

        TunnelScavenger(ServerChannel serverChannel) {
            this.networkChannel = serverChannel;
            if (serverChannel instanceof ServerChannelImpl) {
                this.networkChannelimpl = (ServerChannelImpl)serverChannel;
            }
        }

        public final void timerExpired(Timer timer) {
            ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)channelOpenSocksMap.get(this.networkChannel);
            for (HTTPServerJVMConnection hTTPServerJVMConnection : concurrentHashMap.values()) {
                hTTPServerJVMConnection.checkIsDead();
            }
            if (concurrentHashMap.isEmpty() && this.networkChannelimpl != null && this.networkChannelimpl.getRuntime() == null) {
                channelOpenSocksMap.remove(this.networkChannel);
                this.networkChannel = null;
                this.networkChannelimpl = null;
                timer.cancel();
            }
        }
    }
}

