/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm.http;

import java.io.IOException;
import java.net.ProtocolException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.common.internal.VersionInfo;
import weblogic.rjvm.MsgAbbrevJVMConnection;
import weblogic.rjvm.http.HTTPServerJVMConnection;
import weblogic.rjvm.http.Utils;
import weblogic.socket.Login;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.StringUtils;

public final class TunnelLoginServlet
extends HttpServlet {
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = Utils.getQueryStringParameter(httpServletRequest, "wl-login");
        if (string == null) {
            this.rejectConnection(1, "No version information", httpServletResponse);
            return;
        }
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)" \t");
        String string2 = null;
        if (stringArray.length == 1) {
            string2 = stringArray[0];
        } else if (stringArray.length > 3) {
            string2 = stringArray[3];
        } else {
            this.rejectConnection(1, "Malformed first line - perhaps an attempt to onnect to a plaintext port using SSL or vice versa?", httpServletResponse);
            return;
        }
        if (!VersionInfo.theOne().compatible(string2)) {
            this.rejectConnection(6, VersionInfo.theOne().rejectionReason(string2), httpServletResponse);
            return;
        }
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(Utils.getQueryStringParameter(httpServletRequest, "AS"));
            n2 = Integer.parseInt(Utils.getQueryStringParameter(httpServletRequest, "HL"));
        }
        catch (NumberFormatException numberFormatException) {
            this.rejectConnection(1, "Malformed first line", httpServletResponse);
        }
        n = Math.min(MsgAbbrevJVMConnection.ABBREV_TABLE_SIZE, n);
        httpServletRequest.getSession();
        String string3 = null;
        try {
            string3 = HTTPServerJVMConnection.acceptJVMConnection(httpServletRequest, n, n2, httpServletResponse);
        }
        catch (ProtocolException protocolException) {
            this.rejectConnection(1, StackTraceUtils.throwable2StackTrace((Throwable)protocolException), httpServletResponse);
            return;
        }
        httpServletResponse.setHeader("Conn-Id", string3);
        Utils.sendOKResponse(httpServletResponse);
    }

    private void rejectConnection(int n, String string, HttpServletResponse httpServletResponse) throws IOException {
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        if (n >= Login.RET_CODES.length) {
            n = 7;
        }
        servletOutputStream.println(Login.RET_CODES[n] + ":" + string);
        this.log("Login rejected with code: '" + Login.RET_TEXT[n] + "', reason: " + string + "'");
    }
}

