/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm.http;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import weblogic.common.internal.VersionInfo;
import weblogic.rjvm.MsgAbbrevJVMConnection;
import weblogic.rjvm.http.HTTPServerJVMConnection;

final class Utils {
    static final String TUNNEL_SEND = "/bea_wls_internal/HTTPClntSend";
    static final String TUNNEL_RECV = "/bea_wls_internal/HTTPClntRecv";
    static final String TUNNEL_LOGIN = "/bea_wls_internal/HTTPClntLogin";
    static final String TUNNEL_CLOSE = "/bea_wls_internal/HTTPClntClose";
    static final String TUNNEL_OK = "OK";
    static final String TUNNEL_DEAD = "DEAD";
    static final String TUNNEL_RETRY = "RETRY";
    static final String TUNNEL_UNAVAIL = "UNAVAIL";
    static final String RESULT_HEADER = "WL-Result";
    static final String VERSION_HEADER = "WL-Version";
    static final String ID_HEADER = "Conn-Id";

    private Utils() {
    }

    static final HTTPServerJVMConnection getConnectionFromID(HttpServletRequest httpServletRequest) throws IOException {
        String string = Utils.getQueryStringParameter(httpServletRequest, "connectionID");
        if (string == null) {
            return null;
        }
        HTTPServerJVMConnection hTTPServerJVMConnection = HTTPServerJVMConnection.findByID(string);
        return hTTPServerJVMConnection;
    }

    static final void sendDeadResponse(HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setHeader(RESULT_HEADER, TUNNEL_DEAD);
        httpServletResponse.getOutputStream().print(TUNNEL_DEAD);
        httpServletResponse.getOutputStream().flush();
    }

    static final void sendOKResponse(HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setContentType("application/octet-stream");
        httpServletResponse.setHeader(RESULT_HEADER, TUNNEL_OK);
        httpServletResponse.setHeader(VERSION_HEADER, VersionInfo.theOne().getMajor() + "." + VersionInfo.theOne().getMinor() + "." + VersionInfo.theOne().getServicePack() + "." + VersionInfo.theOne().getRollingPatch() + "." + VersionInfo.theOne().hasTemporaryPatch());
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        servletOutputStream.print("OK\n");
        servletOutputStream.print("AS:" + MsgAbbrevJVMConnection.ABBREV_TABLE_SIZE + "\n" + "HL" + ":" + 19 + "\n\n");
    }

    static final String getQueryStringParameter(HttpServletRequest httpServletRequest, String string) {
        String string2 = httpServletRequest.getQueryString();
        Hashtable hashtable = HttpUtils.parseQueryString((String)string2);
        String[] stringArray = (String[])hashtable.get(string);
        return stringArray == null ? null : stringArray[0];
    }
}

