/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm.t3;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import weblogic.protocol.ServerChannel;
import weblogic.rjvm.JVMID;
import weblogic.rjvm.MsgAbbrevJVMConnection;
import weblogic.rjvm.RJVMConnectionFactory;
import weblogic.rjvm.t3.MuxableSocketT3S;
import weblogic.security.utils.SSLIOContext;
import weblogic.security.utils.SSLIOContextTable;
import weblogic.socket.JSSESocket;
import weblogic.socket.SSLFilter;
import weblogic.socket.SocketMuxer;
import weblogic.socket.utils.JSSEUtils;

public class ConnectionFactoryT3S
implements RJVMConnectionFactory {
    public MsgAbbrevJVMConnection createConnection(InetAddress inetAddress, int n, ServerChannel serverChannel, JVMID jVMID, int n2) throws IOException {
        MuxableSocketT3S muxableSocketT3S = new MuxableSocketT3S(serverChannel);
        MsgAbbrevJVMConnection msgAbbrevJVMConnection = muxableSocketT3S.getConnection();
        muxableSocketT3S.initializeClientCertPlugin(jVMID, serverChannel);
        MuxableSocketT3S muxableSocketT3S2 = muxableSocketT3S;
        int n3 = n2 > 0 ? n2 : serverChannel.getConnectTimeout() * 1000;
        try {
            muxableSocketT3S.connect(inetAddress, n, n3);
        }
        catch (SSLException sSLException) {
            Socket socket = muxableSocketT3S2.getSocket();
            if (socket != null && !socket.isClosed()) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw sSLException;
        }
        SSLSocket sSLSocket = (SSLSocket)muxableSocketT3S2.getSocket();
        JSSESocket jSSESocket = JSSEUtils.getJSSESocket(sSLSocket);
        if (jSSESocket != null) {
            JSSEUtils.registerJSSEFilter(jSSESocket, muxableSocketT3S2);
            if (muxableSocketT3S2.isMessageComplete()) {
                muxableSocketT3S2.dispatch();
            } else {
                SocketMuxer.getMuxer().read(jSSESocket.getFilter());
            }
        } else {
            SSLIOContext sSLIOContext = SSLIOContextTable.findContext(sSLSocket);
            SSLFilter sSLFilter = (SSLFilter)sSLIOContext.getFilter();
            muxableSocketT3S.setSocketFilter(sSLFilter);
            sSLFilter.setDelegate(muxableSocketT3S2);
            sSLFilter.activate();
        }
        return msgAbbrevJVMConnection;
    }
}

