/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm.t3;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import weblogic.common.T3Exception;
import weblogic.common.internal.VersionInfo;
import weblogic.kernel.Kernel;
import weblogic.protocol.MessageSenderStatistics;
import weblogic.protocol.OutgoingMessage;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.rjvm.ConnectionManager;
import weblogic.rjvm.MsgAbbrevJVMConnection;
import weblogic.rjvm.TransportUtils;
import weblogic.security.service.ContextHandler;
import weblogic.socket.AbstractMuxableSocket;
import weblogic.socket.AsyncOutputStream;
import weblogic.socket.Login;
import weblogic.socket.MaxMessageSizeExceededException;
import weblogic.socket.NIOConnection;
import weblogic.socket.SocketMuxer;
import weblogic.socket.UnrecoverableConnectException;
import weblogic.utils.StringUtils;
import weblogic.utils.io.Chunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuxableSocketT3
extends AbstractMuxableSocket
implements AsyncOutputStream {
    private static final long serialVersionUID = -3990131100112713491L;
    private static final byte[] CONNECT_PARAMS = ("AS:" + MsgAbbrevJVMConnection.ABBREV_TABLE_SIZE + "\n" + "HL" + ":" + 19 + "\n\n").getBytes();
    private static final String MALFORMED_FIRST_LINE = "Malformed first line\nAre you trying to connect to a standard port using SSL or vice versa?";
    private static final boolean ASSERT = false;
    private static final int INITIAL_SO_TIMEOUT = 60000;
    private static final int HEADER_SIZE_LIMIT = 512;
    private static final int CONNECT_MAX_RETRY = 1;
    private static final int CONNECT_BACKOFF_INTERVAL = 1000;
    private boolean bootstrapped;
    protected final T3MsgAbbrevJVMConnection connection = new T3MsgAbbrevJVMConnection();
    private Chunk sendHead;
    private IOException sendException;

    public MuxableSocketT3(Chunk chunk, Socket socket, ServerChannel serverChannel) throws IOException {
        super(chunk, socket, serverChannel);
        this.acceptConnect(socket);
        this.connection.setDispatcher(ConnectionManager.create(null));
        if (Kernel.getConfig().isSocketBufferSizeAsChunkSize()) {
            this.getSocket().setSendBufferSize(Chunk.CHUNK_SIZE);
            this.getSocket().setReceiveBufferSize(Chunk.CHUNK_SIZE);
        }
    }

    protected MuxableSocketT3(ServerChannel serverChannel) {
        super(serverChannel);
    }

    protected final void acceptConnect(Socket socket) throws IOException {
        this.connect(socket);
        this.setSoTimeout(60000);
    }

    private void readBootstrapMessage(Chunk chunk) throws IOException {
        int n;
        String string = new String(chunk.buf);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        if (!stringTokenizer.hasMoreTokens()) {
            this.rejectConnection(1, "No version information");
        }
        String string2 = stringTokenizer.nextToken();
        String[] stringArray = StringUtils.splitCompletely((String)string2, (String)" \t");
        String string3 = null;
        if (stringArray.length == 2) {
            string3 = stringArray[1];
        } else if (stringArray.length > 3) {
            string3 = stringArray[3];
        } else {
            this.rejectConnection(1, MALFORMED_FIRST_LINE);
        }
        if (!VersionInfo.theOne().compatible(string3)) {
            this.rejectConnection(6, VersionInfo.theOne().rejectionReason(string3));
        }
        if (!stringTokenizer.hasMoreTokens()) {
            this.rejectConnection(1, "Invalid parameter.");
        }
        string2 = stringTokenizer.nextToken();
        int n2 = T3MsgAbbrevJVMConnection.ABBREV_TABLE_SIZE;
        if (string2.charAt(0) == "AS".charAt(0)) {
            if (string2.charAt(1) == "AS".charAt(1)) {
                try {
                    n = Integer.parseInt(string2.substring(string2.indexOf(58) + 1, string2.length()));
                    n2 = Math.min(n2, n);
                }
                catch (Exception exception) {
                    this.rejectConnection(1, "Invalid parameter: " + string2);
                }
            }
        }
        if (!stringTokenizer.hasMoreTokens()) {
            this.rejectConnection(1, "Invalid parameter.");
        }
        string2 = stringTokenizer.nextToken();
        n = 19;
        if (string2.charAt(0) == "HL".charAt(0)) {
            if (string2.charAt(1) == "HL".charAt(1)) {
                try {
                    n = Integer.parseInt(string2.substring(string2.indexOf(58) + 1, string2.length()));
                }
                catch (Exception exception) {
                    this.rejectConnection(1, "Invalid parameter: " + string2);
                }
            }
        }
        this.connection.init(n2, n);
        Login.connectReplyOK((Socket)this.getSocket(), (byte[])CONNECT_PARAMS, (VersionInfo)VersionInfo.theOne());
    }

    private void readConnectionParams(InputStream inputStream) throws IOException {
        TransportUtils.BootstrapResult bootstrapResult = TransportUtils.readBootstrapParams((InputStream)inputStream);
        if (!bootstrapResult.isSuccess()) {
            this.rejectConnection(1, "Invalid parameter: " + bootstrapResult.getInvalidLine());
        }
        this.connection.init(bootstrapResult.getAbbrevSize(), bootstrapResult.getHeaderLength());
    }

    private Socket newSocketWithRetry(InetAddress inetAddress, int n, int n2) throws IOException {
        int n3 = 0;
        while (true) {
            try {
                return this.createSocket(inetAddress, n, n2);
            }
            catch (SocketException socketException) {
                if (n3 == 1) {
                    throw socketException;
                }
                try {
                    Thread.sleep((long)(Math.random() * (double)(1000 << n3)));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n3;
                continue;
            }
            break;
        }
    }

    public OutputStream getOutputStream() {
        return this.getSocketOutputStream();
    }

    public final Chunk getOutputBuffer() {
        return this.sendHead;
    }

    public final void handleException(IOException iOException) {
        this.sendException = iOException;
    }

    public final void handleWrite(Chunk chunk) {
        this.sendHead = chunk.next;
        Chunk.releaseChunk((Chunk)chunk);
    }

    private boolean canReadFirstMessage() {
        int n = this.getAvailableBytes();
        boolean bl = false;
        for (int i = 0; i < n - 1; ++i) {
            if (i > 512) {
                return false;
            }
            if (this.getHeaderByte(i) != 10 || this.getHeaderByte(i + 1) != 10) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    protected int getHeaderLength() {
        if (!this.bootstrapped) {
            return 2;
        }
        return 4;
    }

    @Override
    protected int getMessageLength() {
        if (!this.bootstrapped) {
            if (this.canReadFirstMessage()) {
                return this.getAvailableBytes();
            }
            return -1;
        }
        int n = this.getHeaderByte(0) & 0xFF;
        int n2 = this.getHeaderByte(1) & 0xFF;
        int n3 = this.getHeaderByte(2) & 0xFF;
        int n4 = this.getHeaderByte(3) & 0xFF;
        return n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    @Override
    public final int getIdleTimeoutMillis() {
        return 0;
    }

    @Override
    public final void dispatch(Chunk chunk) {
        if (!this.bootstrapped) {
            try {
                this.readBootstrapMessage(chunk);
                this.bootstrapped = true;
            }
            catch (IOException iOException) {
                SocketMuxer.getMuxer().deliverHasException(this.getSocketFilter(), iOException);
            }
        } else {
            this.connection.dispatch(chunk);
        }
    }

    @Override
    public final void hasException(Throwable throwable) {
        this.connection.gotExceptionReceiving(throwable);
        super.hasException(throwable);
    }

    @Override
    public final boolean timeout() {
        this.connection.gotExceptionReceiving(new EOFException("Connection timed out"));
        return super.timeout();
    }

    @Override
    public final void endOfStream() {
        this.connection.gotExceptionReceiving(new EOFException());
        super.endOfStream();
    }

    @Override
    public void incrementBufferOffset(int n) throws MaxMessageSizeExceededException {
        super.incrementBufferOffset(n);
        if (n > 0 && this.getConnection().getDispatcher() != null) {
            this.getConnection().getDispatcher().messageReceived();
        }
    }

    private void rejectConnection(int n, String string) throws T3Exception, IOException {
        Login.connectReply((Socket)this.getSocket(), (int)n, (String)string);
        this.close();
        throw new T3Exception(string);
    }

    public MsgAbbrevJVMConnection getConnection() {
        return this.connection;
    }

    @Override
    public final void connect(InetAddress inetAddress, int n) throws UnrecoverableConnectException, IOException, UnknownHostException {
        this.connect(inetAddress, n, 0);
    }

    @Override
    public final void connect(InetAddress inetAddress, int n, int n2) throws UnrecoverableConnectException, IOException, UnknownHostException {
        this.connect(this.newSocketWithRetry(inetAddress, n, n2));
        this.setSoTimeout(60000);
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(this.getSocketOutputStream()));
        dataOutputStream.writeBytes(this.getRealProtocolName() + " " + VersionInfo.theOne().getReleaseVersion() + "\n");
        dataOutputStream.write(CONNECT_PARAMS);
        dataOutputStream.flush();
        DataInputStream dataInputStream = new DataInputStream(this.getSocketInputStream());
        String string = dataInputStream.readLine();
        String string2 = Login.checkLoginSuccess((String)string);
        if (string2 != null) {
            this.close();
            throw new IOException(string2);
        }
        String string3 = Login.getVersionString((String)string);
        if (string3 == null) {
            this.connection.doDownGrade();
        }
        this.readConnectionParams(dataInputStream);
        this.bootstrapped = true;
    }

    private String getRealProtocolName() {
        return ProtocolManager.getRealProtocol((Protocol)this.getProtocol()).getProtocolName().toLowerCase(Locale.ENGLISH);
    }

    protected X509Certificate[] getJavaCertChain() {
        return null;
    }

    @Override
    public boolean supportsScatteredRead() {
        return true;
    }

    @Override
    public long read(NIOConnection nIOConnection) throws IOException {
        int n = nIOConnection.getOptimalNumberOfBuffers();
        assert (n > 0);
        this.tail = Chunk.tail((Chunk)this.head);
        int n2 = Chunk.CHUNK_SIZE - this.tail.end;
        int n3 = this.head.end < 4 ? Chunk.CHUNK_SIZE : this.getMessageLength();
        n3 -= this.availBytes;
        ByteBuffer[] byteBufferArray = new ByteBuffer[n];
        boolean bl = false;
        int n4 = 0;
        if (n2 > 0) {
            byteBufferArray[n4++] = this.tail.getReadByteBuffer();
            bl = true;
        }
        Chunk chunk = this.tail;
        while (n4 < n && n3 > n2) {
            chunk = chunk.next = Chunk.getChunk();
            n2 += Chunk.CHUNK_SIZE - chunk.end;
            byteBufferArray[n4++] = chunk.getReadByteBuffer();
        }
        long l = nIOConnection.getScatteringByteChannel().read(byteBufferArray, 0, n4);
        int n5 = 0;
        if (bl) {
            this.tail.end = byteBufferArray[n5++].position();
        }
        while (n5 < n4) {
            Chunk chunk2 = this.tail.next;
            if (byteBufferArray[n5].position() == 0) {
                Chunk.releaseChunks((Chunk)chunk2);
                this.tail.next = null;
                break;
            }
            chunk2.end = byteBufferArray[n5].position();
            this.tail = chunk2;
            ++n5;
        }
        if (l > 0L) {
            this.availBytes = (int)((long)this.availBytes + l);
        }
        if (this.availBytes > this.maxMessageSize) {
            throw new MaxMessageSizeExceededException(this.availBytes, this.maxMessageSize, this.channel.getConfiguredProtocol());
        }
        return l;
    }

    public boolean supportsGatheringWrite() {
        return true;
    }

    public long write(NIOConnection nIOConnection) throws IOException {
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>(nIOConnection.getOptimalNumberOfBuffers());
        Chunk chunk = this.sendHead;
        while (chunk != null) {
            ByteBuffer byteBuffer = chunk.getWriteByteBuffer();
            arrayList.add(byteBuffer);
            chunk = chunk.next;
        }
        chunk = this.toArray(arrayList);
        long l = nIOConnection.getGatheringByteChannel().write((ByteBuffer[])chunk, 0, ((Chunk)chunk).length);
        while (this.sendHead != null) {
            Chunk chunk2 = this.sendHead;
            this.sendHead = this.sendHead.next;
            Chunk.releaseChunk((Chunk)chunk2);
        }
        return l;
    }

    private ByteBuffer[] toArray(List<ByteBuffer> list) {
        int n = list.size();
        ByteBuffer[] byteBufferArray = new ByteBuffer[n];
        for (int i = 0; i < n; ++i) {
            byteBufferArray[i] = list.get(i);
        }
        return byteBufferArray;
    }

    protected class T3MsgAbbrevJVMConnection
    extends MsgAbbrevJVMConnection {
        private T3MsgAbbrevJVMConnection() {
            MuxableSocketT3.this.addSenderStatistics((MessageSenderStatistics)this);
        }

        public final InetAddress getLocalAddress() {
            return MuxableSocketT3.this.getSocket().getLocalAddress();
        }

        public final int getLocalPort() {
            return MuxableSocketT3.this.getSocket().getLocalPort();
        }

        public final ServerChannel getChannel() {
            return MuxableSocketT3.this.getChannel();
        }

        public final ContextHandler getContextHandler() {
            return MuxableSocketT3.this;
        }

        public final void connect(InetAddress inetAddress, int n) throws UnrecoverableConnectException, IOException, UnknownHostException {
            MuxableSocketT3.this.connect(inetAddress, n);
        }

        public final void sendMsg(OutgoingMessage outgoingMessage) throws IOException {
            if (MuxableSocketT3.this.isClosed()) {
                throw new IOException("Attempt to send message on closed socket");
            }
            MuxableSocketT3.this.sendHead = outgoingMessage.getChunks();
            SocketMuxer.getMuxer().write(MuxableSocketT3.this);
            if (MuxableSocketT3.this.sendException != null) {
                throw MuxableSocketT3.this.sendException;
            }
        }

        public final void close() {
            SocketMuxer.getMuxer().closeSocket(MuxableSocketT3.this.getSocketFilter());
        }

        public final X509Certificate[] getJavaCertChain() {
            return MuxableSocketT3.this.getJavaCertChain();
        }
    }
}

