/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm.t3;

import java.io.IOException;
import java.net.Socket;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocket;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.rjvm.JVMID;
import weblogic.rjvm.t3.MuxableSocketT3;
import weblogic.security.SSL.CertCallback;
import weblogic.security.SSL.ClientCertificatePlugin;
import weblogic.security.SSL.SSLClientInfo;
import weblogic.security.utils.SSLCertUtility;
import weblogic.socket.ChannelSSLSocketFactory;
import weblogic.socket.SSLFilter;
import weblogic.socket.SocketMuxer;
import weblogic.utils.io.Chunk;

public final class MuxableSocketT3S
extends MuxableSocketT3 {
    private static final long serialVersionUID = -1499853227078510946L;
    private static String clientCertPlugin;

    public MuxableSocketT3S(Chunk chunk, Socket socket, ServerChannel serverChannel) throws IOException {
        super(chunk, socket, serverChannel);
        if (ChannelHelper.isAdminChannel((ServerChannel)serverChannel)) {
            this.connection.setAdminQOS();
        }
    }

    void initializeClientCertPlugin(JVMID jVMID, ServerChannel serverChannel) throws IOException {
        SSLClientInfo sSLClientInfo;
        if (clientCertPlugin != null && (sSLClientInfo = MuxableSocketT3S.getClientCertificate(jVMID, serverChannel)) != null) {
            ChannelSSLSocketFactory channelSSLSocketFactory = (ChannelSSLSocketFactory)this.socketFactory;
            channelSSLSocketFactory.setSSLClientInfo(sSLClientInfo);
        }
    }

    MuxableSocketT3S(ServerChannel serverChannel) {
        super(serverChannel);
        if (ChannelHelper.isAdminChannel((ServerChannel)serverChannel)) {
            this.connection.setAdminQOS();
        }
    }

    static SSLClientInfo getClientCertificate(JVMID jVMID, ServerChannel serverChannel) {
        try {
            Class<?> clazz = Class.forName(clientCertPlugin);
            ClientCertificatePlugin clientCertificatePlugin = (ClientCertificatePlugin)clazz.newInstance();
            CertCallback certCallback = new CertCallback(SocketMuxer.getMuxer().isAsyncMuxer(), serverChannel.getAddress(), serverChannel.getPort(), jVMID.getPublicAddress(), jVMID.getPublicPort());
            clientCertificatePlugin.loadClientCertificate(certCallback, jVMID.getDomainName(), jVMID.getServerName());
            return certCallback.getSSLClientInfo();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public X509Certificate[] getJavaCertChain() {
        SSLSocket sSLSocket = (SSLSocket)this.getSocket();
        try {
            return SSLCertUtility.getPeerCertChain(sSLSocket);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void ensureForceClose() {
        ((SSLFilter)this.getSocketFilter()).ensureForceClose();
    }

    static {
        if (KernelStatus.isServer()) {
            clientCertPlugin = System.getProperty("weblogic.security.SSL.ClientCertPlugin");
        }
    }
}

