/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm.t3.client;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.StringTokenizer;
import weblogic.common.T3Exception;
import weblogic.common.internal.VersionInfo;
import weblogic.protocol.OutgoingMessage;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.rjvm.MsgAbbrevJVMConnection;
import weblogic.rjvm.TransportUtils;
import weblogic.security.service.ContextHandler;
import weblogic.socket.AsyncOutputStream;
import weblogic.socket.BaseAbstractMuxableSocket;
import weblogic.socket.Login;
import weblogic.socket.MaxMessageSizeExceededException;
import weblogic.socket.NIOConnection;
import weblogic.socket.SocketMuxer;
import weblogic.socket.UnrecoverableConnectException;
import weblogic.utils.StringUtils;
import weblogic.utils.io.Chunk;

public class MuxableSocketT3
extends BaseAbstractMuxableSocket
implements AsyncOutputStream {
    private static final long serialVersionUID = -3990131100112713491L;
    private static final byte[] CONNECT_PARAMS = ("AS:" + MsgAbbrevJVMConnection.ABBREV_TABLE_SIZE + "\n" + "HL" + ":" + 19 + "\n\n").getBytes();
    private static final String MALFORMED_FIRST_LINE = "Malformed first line\nAre you trying to connect to a standard port using SSL or vice versa?";
    private static final boolean ASSERT = false;
    private static final int INITIAL_SO_TIMEOUT = 60000;
    private static final int HEADER_SIZE_LIMIT = 512;
    private static final int CONNECT_MAX_RETRY = 1;
    private static final int CONNECT_BACKOFF_INTERVAL = 1000;
    private boolean bootstrapped;
    protected final T3MsgAbbrevJVMConnection connection = new T3MsgAbbrevJVMConnection();
    private Chunk sendHead;
    private IOException sendException;

    protected MuxableSocketT3(ServerChannel serverChannel) {
        super(serverChannel);
    }

    private void readBootstrapMessage(Chunk chunk) throws IOException {
        int n;
        String string = new String(chunk.buf);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        if (!stringTokenizer.hasMoreTokens()) {
            this.rejectConnection(1, "No version information");
        }
        String string2 = stringTokenizer.nextToken();
        String[] stringArray = StringUtils.splitCompletely((String)string2, (String)" \t");
        String string3 = null;
        if (stringArray.length == 2) {
            string3 = stringArray[1];
        } else if (stringArray.length > 3) {
            string3 = stringArray[3];
        } else {
            this.rejectConnection(1, MALFORMED_FIRST_LINE);
        }
        if (!VersionInfo.theOne().compatible(string3)) {
            this.rejectConnection(6, VersionInfo.theOne().rejectionReason(string3));
        }
        if (!stringTokenizer.hasMoreTokens()) {
            this.rejectConnection(1, "Invalid parameter.");
        }
        string2 = stringTokenizer.nextToken();
        int n2 = T3MsgAbbrevJVMConnection.ABBREV_TABLE_SIZE;
        if (string2.charAt(0) == "AS".charAt(0)) {
            if (string2.charAt(1) == "AS".charAt(1)) {
                try {
                    n = Integer.parseInt(string2.substring(string2.indexOf(58) + 1, string2.length()));
                    n2 = Math.min(n2, n);
                }
                catch (Exception exception) {
                    this.rejectConnection(1, "Invalid parameter: " + string2);
                }
            }
        }
        if (!stringTokenizer.hasMoreTokens()) {
            this.rejectConnection(1, "Invalid parameter.");
        }
        string2 = stringTokenizer.nextToken();
        n = 19;
        if (string2.charAt(0) == "HL".charAt(0)) {
            if (string2.charAt(1) == "HL".charAt(1)) {
                try {
                    n = Integer.parseInt(string2.substring(string2.indexOf(58) + 1, string2.length()));
                }
                catch (Exception exception) {
                    this.rejectConnection(1, "Invalid parameter: " + string2);
                }
            }
        }
        this.connection.init(n2, n);
        Login.connectReplyOK((Socket)this.getSocket(), (byte[])CONNECT_PARAMS, (VersionInfo)VersionInfo.theOne());
    }

    private void readConnectionParams(InputStream inputStream) throws IOException {
        TransportUtils.BootstrapResult bootstrapResult = TransportUtils.readBootstrapParams((InputStream)inputStream);
        if (!bootstrapResult.isSuccess()) {
            this.rejectConnection(1, "Invalid parameter: " + bootstrapResult.getInvalidLine());
        }
        this.connection.init(bootstrapResult.getAbbrevSize(), bootstrapResult.getHeaderLength());
    }

    private Socket newSocketWithRetry(InetAddress inetAddress, int n, int n2) throws IOException {
        int n3 = 0;
        while (true) {
            try {
                return this.createSocket(inetAddress, n, n2);
            }
            catch (SocketException socketException) {
                if (n3 == 1) {
                    throw socketException;
                }
                try {
                    Thread.sleep((long)(Math.random() * (double)(1000 << n3)));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n3;
                continue;
            }
            break;
        }
    }

    public OutputStream getOutputStream() {
        return this.getSocketOutputStream();
    }

    public final Chunk getOutputBuffer() {
        return this.sendHead;
    }

    public final void handleException(IOException iOException) {
        this.sendException = iOException;
    }

    public final void handleWrite(Chunk chunk) {
        this.sendHead = chunk.next;
        Chunk.releaseChunk((Chunk)chunk);
    }

    private boolean canReadFirstMessage() {
        int n = this.getAvailableBytes();
        boolean bl = false;
        for (int i = 0; i < n - 1; ++i) {
            if (i > 512) {
                return false;
            }
            if (this.getHeaderByte(i) != 10 || this.getHeaderByte(i + 1) != 10) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected int getHeaderLength() {
        if (!this.bootstrapped) {
            return 2;
        }
        return 4;
    }

    protected int getMessageLength() {
        if (!this.bootstrapped) {
            if (this.canReadFirstMessage()) {
                return this.getAvailableBytes();
            }
            return -1;
        }
        int n = this.getHeaderByte(0) & 0xFF;
        int n2 = this.getHeaderByte(1) & 0xFF;
        int n3 = this.getHeaderByte(2) & 0xFF;
        int n4 = this.getHeaderByte(3) & 0xFF;
        return n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    public final int getIdleTimeoutMillis() {
        return 0;
    }

    public final void dispatch(Chunk chunk) {
        if (!this.bootstrapped) {
            try {
                this.readBootstrapMessage(chunk);
                this.bootstrapped = true;
            }
            catch (IOException iOException) {
                SocketMuxer.getMuxer().deliverHasException(this.getSocketFilter(), iOException);
            }
        } else {
            this.connection.dispatch(chunk);
        }
    }

    public final void hasException(Throwable throwable) {
        this.connection.gotExceptionReceiving(throwable);
        super.hasException(throwable);
    }

    public final boolean timeout() {
        this.connection.gotExceptionReceiving(new EOFException("Connection timed out"));
        return super.timeout();
    }

    public final void endOfStream() {
        this.connection.gotExceptionReceiving(new EOFException());
        super.endOfStream();
    }

    public void incrementBufferOffset(int n) throws MaxMessageSizeExceededException {
        super.incrementBufferOffset(n);
        if (n > 0 && this.getConnection().getDispatcher() != null) {
            this.getConnection().getDispatcher().messageReceived();
        }
    }

    private void rejectConnection(int n, String string) throws T3Exception, IOException {
        Login.connectReply((Socket)this.getSocket(), (int)n, (String)string);
        this.close();
        throw new T3Exception(string);
    }

    public MsgAbbrevJVMConnection getConnection() {
        return this.connection;
    }

    public final void connect(InetAddress inetAddress, int n) throws UnrecoverableConnectException, IOException, UnknownHostException {
        this.connect(inetAddress, n, 0);
    }

    public final void connect(InetAddress inetAddress, int n, int n2) throws UnrecoverableConnectException, IOException, UnknownHostException {
        this.connect(this.newSocketWithRetry(inetAddress, n, n2));
        this.setSoTimeout(60000);
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(this.getSocketOutputStream()));
        dataOutputStream.writeBytes(this.getRealProtocolName() + " " + VersionInfo.theOne().getReleaseVersion() + "\n");
        dataOutputStream.write(CONNECT_PARAMS);
        dataOutputStream.flush();
        DataInputStream dataInputStream = new DataInputStream(this.getSocketInputStream());
        String string = dataInputStream.readLine();
        String string2 = Login.checkLoginSuccess((String)string);
        if (string2 != null) {
            this.close();
            throw new IOException(string2);
        }
        String string3 = Login.getVersionString((String)string);
        if (string3 == null) {
            this.connection.doDownGrade();
        }
        this.readConnectionParams(dataInputStream);
        this.bootstrapped = true;
    }

    private String getRealProtocolName() {
        return ProtocolManager.getRealProtocol((Protocol)this.getProtocol()).getProtocolName().toLowerCase(Locale.ENGLISH);
    }

    protected X509Certificate[] getJavaCertChain() {
        return null;
    }

    public boolean supportsGatheringWrite() {
        return false;
    }

    public long write(NIOConnection nIOConnection) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected class T3MsgAbbrevJVMConnection
    extends MsgAbbrevJVMConnection {
        private T3MsgAbbrevJVMConnection() {
        }

        public final InetAddress getLocalAddress() {
            return MuxableSocketT3.this.getSocket().getLocalAddress();
        }

        public final int getLocalPort() {
            return MuxableSocketT3.this.getSocket().getLocalPort();
        }

        public final ServerChannel getChannel() {
            return MuxableSocketT3.this.getChannel();
        }

        public final ContextHandler getContextHandler() {
            return MuxableSocketT3.this;
        }

        public final void connect(InetAddress inetAddress, int n) throws UnrecoverableConnectException, IOException, UnknownHostException {
            MuxableSocketT3.this.connect(inetAddress, n);
        }

        public final void sendMsg(OutgoingMessage outgoingMessage) throws IOException {
            if (MuxableSocketT3.this.isClosed()) {
                throw new IOException("Attempt to send message on closed socket");
            }
            MuxableSocketT3.this.sendHead = outgoingMessage.getChunks();
            SocketMuxer.getMuxer().write(MuxableSocketT3.this);
            if (MuxableSocketT3.this.sendException != null) {
                throw MuxableSocketT3.this.sendException;
            }
        }

        public final void close() {
            SocketMuxer.getMuxer().closeSocket(MuxableSocketT3.this.getSocketFilter());
        }

        public final X509Certificate[] getJavaCertChain() {
            return MuxableSocketT3.this.getJavaCertChain();
        }
    }
}

