/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm.t3.client;

import java.io.IOException;
import java.net.Socket;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolHandler;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.server.channels.BasicServerChannelImpl;
import weblogic.socket.MuxableSocket;
import weblogic.utils.io.Chunk;

public class ProtocolHandlerT3
implements ProtocolHandler {
    private static final String PROTOCOL_NAME = "t3";
    private static final ProtocolHandler theOne = new ProtocolHandlerT3();
    public static final Protocol PROTOCOL_T3 = ProtocolManager.createProtocol((byte)0, (String)"t3", (String)"t3", (boolean)false, (ProtocolHandler)ProtocolHandlerT3.getProtocolHandler());

    public static ProtocolHandler getProtocolHandler() {
        return theOne;
    }

    public ServerChannel getDefaultServerChannel() {
        return ChannelInitializer.CHANNEL;
    }

    protected ProtocolHandlerT3() {
    }

    public int getHeaderLength() {
        return PROTOCOL_NAME.length() + 1;
    }

    public int getPriority() {
        return 0;
    }

    public Protocol getProtocol() {
        return PROTOCOL_T3;
    }

    public boolean claimSocket(Chunk chunk) {
        return this.claimSocket(chunk, PROTOCOL_NAME);
    }

    boolean claimSocket(Chunk chunk, String string) {
        int n = string.length();
        if (chunk.end < n + 1) {
            return false;
        }
        byte[] byArray = chunk.buf;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == string.charAt(i)) continue;
            return false;
        }
        return byArray[n] == 32;
    }

    public MuxableSocket createSocket(Chunk chunk, Socket socket, ServerChannel serverChannel) throws IOException {
        throw new UnsupportedOperationException("This method is not supported on the weblogic client side");
    }

    private static final class ChannelInitializer {
        private static final ServerChannel CHANNEL = BasicServerChannelImpl.createDefaultServerChannel(PROTOCOL_T3);

        private ChannelInitializer() {
        }
    }
}

