/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm.t3.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import weblogic.protocol.ServerChannel;
import weblogic.socket.WeblogicSocketFactory;

public class T3ClientWeblogicSocketFactory
extends WeblogicSocketFactory {
    private final SSLSocketFactory sslSocketFactory;
    private final ServerChannel channel;

    public T3ClientWeblogicSocketFactory(SSLSocketFactory sSLSocketFactory, ServerChannel serverChannel) {
        this.sslSocketFactory = sSLSocketFactory;
        this.channel = serverChannel;
    }

    public T3ClientWeblogicSocketFactory(SocketFactory socketFactory, ServerChannel serverChannel) {
        throw new UnsupportedOperationException("Only SSLSocketFactory is supported");
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return this.createSocket(InetAddress.getByName(string), n);
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return this.createSocket(inetAddress, n, 0);
    }

    public Socket createSocket(InetAddress inetAddress, int n, int n2) throws IOException {
        int n3 = n2 > 0 || this.channel == null ? n2 : this.channel.getConnectTimeout() * 1000;
        SSLSocket sSLSocket = (SSLSocket)this.sslSocketFactory.createSocket();
        sSLSocket.connect(new InetSocketAddress(inetAddress, n), n3);
        sSLSocket.setTcpNoDelay(true);
        sSLSocket.setTrafficClass(16);
        sSLSocket.startHandshake();
        return sSLSocket;
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) {
        throw new UnsupportedOperationException("Binding characteristics are determined by the channel");
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) {
        throw new UnsupportedOperationException("Binding characteristics are determined by the channel");
    }
}

