/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm.wls;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import weblogic.common.internal.PassivationUtils;
import weblogic.common.internal.ProxyClassResolver;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelStatus;
import weblogic.net.http.HttpURLConnection;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolHandler;
import weblogic.protocol.ProtocolHandlerAdmin;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.rjvm.MsgAbbrevInputStream;
import weblogic.rjvm.MsgAbbrevJVMConnection;
import weblogic.rjvm.RJVMConnectionFactory;
import weblogic.rjvm.RJVMEnvironment;
import weblogic.rjvm.RJVMManager;
import weblogic.rjvm.RemoteInvokable;
import weblogic.rjvm.RemoteRequest;
import weblogic.rjvm.http.HTTPClientConnectionFactory;
import weblogic.rjvm.http.HTTPSClientConnectionFactory;
import weblogic.rjvm.t3.ConnectionFactoryT3;
import weblogic.rjvm.t3.ConnectionFactoryT3S;
import weblogic.rjvm.t3.ProtocolHandlerT3;
import weblogic.rjvm.t3.ProtocolHandlerT3S;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.server.channels.ChannelService;
import weblogic.server.channels.ServerChannelImpl;
import weblogic.servlet.internal.ProtocolHandlerHTTP;
import weblogic.servlet.internal.ProtocolHandlerHTTPS;
import weblogic.servlet.internal.WebService;
import weblogic.socket.ChannelSocketFactory;
import weblogic.t3.srvr.BootServicesImpl;

public final class WLSRJVMEnvironment
extends RJVMEnvironment {
    public void ensureInitialized() {
        Kernel.ensureInitialized();
    }

    public int getHeartbeatIdlePeriodsUntilTimeout() {
        return Kernel.getConfig().getIdlePeriodsUntilTimeout();
    }

    public int getHeartbeatPeriodLengthMillis() {
        return Kernel.getConfig().getPeriodLength();
    }

    public int getAbbrevTableSize() {
        return KernelStatus.isServer() ? Kernel.getConfig().getT3ServerAbbrevTableSize() : Kernel.getConfig().getT3ClientAbbrevTableSize();
    }

    public boolean isTracingEnabled() {
        return Kernel.isTracingEnabled();
    }

    public int getRjvmIdleTimeout() {
        return Kernel.getConfig().getRjvmIdleTimeout();
    }

    public String getDefaultProtocolName() {
        return Kernel.getConfig().getDefaultProtocol();
    }

    public String getDefaultSecureProtocolName() {
        return Kernel.getConfig().getDefaultSecureProtocol();
    }

    public String getAdminProtocolName() {
        return Kernel.getConfig().getAdministrationProtocol();
    }

    public Class resolveProxyClass(String[] stringArray, String string, String string2) throws IOException, ClassNotFoundException {
        return ProxyClassResolver.resolveProxyClass(stringArray, string, string2);
    }

    public Object copyObject(Object object) throws IOException, ClassNotFoundException {
        return PassivationUtils.copy(object);
    }

    public void registerRJVMProtocols() {
        RJVMManager.registerRJVMProtocol((byte)0, (ProtocolHandler)ProtocolHandlerT3.getProtocolHandler(), (RJVMConnectionFactory)new ConnectionFactoryT3());
        RJVMManager.registerRJVMProtocol((byte)2, (ProtocolHandler)ProtocolHandlerT3S.getProtocolHandler(), (RJVMConnectionFactory)new ConnectionFactoryT3S());
        RJVMManager.registerRJVMProtocol((byte)1, (ProtocolHandler)ProtocolHandlerHTTP.getProtocolHandler(), (RJVMConnectionFactory)new HTTPClientConnectionFactory());
        RJVMManager.registerRJVMProtocol((byte)3, (ProtocolHandler)ProtocolHandlerHTTPS.getProtocolHandler(), (RJVMConnectionFactory)new HTTPSClientConnectionFactory());
        RJVMManager.registerRJVMProtocol((byte)6, (ProtocolHandler)ProtocolHandlerAdmin.getProtocolHandler(), null);
    }

    public String getInternalWebAppContextPath() {
        return WebService.getInternalWebAppContextPath();
    }

    public ServerChannel createDefaultChannel(Protocol protocol) {
        return ServerChannelImpl.createDefaultServerChannel(protocol);
    }

    public boolean isLocalChannel(InetAddress inetAddress, int n) {
        return ChannelService.isLocalChannel(inetAddress, n);
    }

    public String createClusterURL(ServerChannel serverChannel) {
        return ChannelHelper.createClusterURL(serverChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeBootService(RemoteInvokable remoteInvokable, MsgAbbrevInputStream msgAbbrevInputStream) throws RemoteException {
        BootServicesImpl bootServicesImpl;
        BootServicesImpl bootServicesImpl2 = bootServicesImpl = (BootServicesImpl)remoteInvokable;
        synchronized (bootServicesImpl2) {
            MsgAbbrevJVMConnection msgAbbrevJVMConnection = msgAbbrevInputStream.getConnection();
            bootServicesImpl.setConnectionInfo(msgAbbrevJVMConnection);
            bootServicesImpl.invoke((RemoteRequest)msgAbbrevInputStream);
        }
    }

    public boolean isServerClusteringSupported() {
        return true;
    }

    public ClassLoader getConnectionManagerClassLoader() {
        return KernelStatus.class.getClassLoader();
    }

    public boolean isServer() {
        return KernelStatus.isServer();
    }

    public boolean isUserAnonymous(AuthenticatedSubject authenticatedSubject) {
        return SubjectUtils.isUserAnonymous((AuthenticatedSubject)authenticatedSubject);
    }

    public ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public Object getSSLContext() {
        return null;
    }

    public void setSSLContext(Object object) {
    }

    public URLConnection createURLConnection(URL uRL, ServerChannel serverChannel) throws IOException {
        if (KernelStatus.isServer()) {
            HttpURLConnection httpURLConnection = new HttpURLConnection(uRL);
            httpURLConnection.setSocketFactory(new ChannelSocketFactory(serverChannel));
            httpURLConnection.u11();
            return httpURLConnection;
        }
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)uRLConnection).u11();
        }
        return uRLConnection;
    }
}

