/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import weblogic.common.internal.InteropWriteReplaceable;
import weblogic.common.internal.PeerInfo;
import weblogic.jndi.Environment;
import weblogic.jndi.internal.ThreadEnvironment;
import weblogic.rmi.cluster.ClusterActivatableServerRef;
import weblogic.rmi.cluster.EntityBeanReplicaHandler;
import weblogic.rmi.cluster.EntityServerRef;
import weblogic.rmi.cluster.ReplicaHandler;
import weblogic.rmi.cluster.RetryHandler;
import weblogic.rmi.extensions.activation.Activatable;
import weblogic.rmi.extensions.activation.Activator;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.internal.OIDManager;
import weblogic.rmi.internal.activation.ActivatableRemoteRef;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.RMIRuntime;

public final class ClusterActivatableRemoteRef
extends ActivatableRemoteRef
implements InteropWriteReplaceable {
    private static final long serialVersionUID = -9116119681422760510L;
    private String jndiName;
    private ReplicaHandler replicaHandler;
    private Environment environment;

    public ClusterActivatableRemoteRef() {
    }

    public ClusterActivatableRemoteRef(int n, HostID hostID, Object object, String string) {
        super(n, hostID, object);
        this.jndiName = string;
    }

    public Object invoke(Remote remote, RuntimeMethodDescriptor runtimeMethodDescriptor, Object[] objectArray, Method method) throws Throwable {
        if (this.environment != null) {
            ThreadEnvironment.push(this.environment);
        }
        try {
            RetryHandler retryHandler = new RetryHandler();
            int n = 0;
            while (true) {
                try {
                    retryHandler.setRetryCount(n);
                    Object object = super.invoke(null, runtimeMethodDescriptor, objectArray, method);
                    return object;
                }
                catch (RemoteException remoteException) {
                    RemoteReference remoteReference = this.replicaHandler.failOver(null, runtimeMethodDescriptor, method, objectArray, remoteException, retryHandler);
                    this.oid = remoteReference.getObjectID();
                    this.hostID = remoteReference.getHostID();
                    ++n;
                    continue;
                }
                break;
            }
        }
        finally {
            if (this.environment != null) {
                ThreadEnvironment.pop();
            }
        }
    }

    public int hashCode() {
        return super.hashCode() ^ this.jndiName.hashCode();
    }

    public String toString() {
        return super.toString() + ", jndiName: '" + this.jndiName + "'";
    }

    public Object interopWriteReplace(PeerInfo peerInfo) throws RemoteException {
        if (peerInfo.getMajor() == 6 && peerInfo.getMinor() == 1) {
            ClusterActivatableServerRef clusterActivatableServerRef = (ClusterActivatableServerRef)OIDManager.getInstance().getServerReference(this.getObjectID());
            Activator activator = clusterActivatableServerRef.getActivator();
            Activatable activatable = activator.activate(this.getActivationID());
            EntityServerRef entityServerRef = null;
            try {
                entityServerRef = (EntityServerRef)ServerHelper.getServerReference((Remote)((Remote)activatable));
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            if (entityServerRef == null) {
                entityServerRef = new EntityServerRef(activatable);
            }
            entityServerRef.exportObject();
            return entityServerRef.getRemoteRef();
        }
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.jndiName);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.jndiName = (String)objectInput.readObject();
        HostID hostID = this.getHostID();
        this.environment = new Environment();
        if (!hostID.isLocal()) {
            this.environment.setProviderUrl(RMIRuntime.findOrCreateEndPoint((HostID)hostID).getClusterURL(objectInput));
        }
        this.replicaHandler = new EntityBeanReplicaHandler(this.getActivationID(), this.jndiName, this.environment);
    }
}

