/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.cluster;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.StateFactory;
import weblogic.iiop.IIOPReplacer;
import weblogic.jndi.internal.WLNamingManager;
import weblogic.rmi.cluster.ClusterableRemoteObject;
import weblogic.rmi.extensions.server.RemoteWrapper;
import weblogic.utils.AssertionError;

public final class ClusterableRemoteBinderFactory
implements StateFactory {
    public Object getStateToBind(Object object, Name name, Context context, Hashtable hashtable) throws NamingException {
        ClusterableRemoteObject clusterableRemoteObject = null;
        if (object instanceof ClusterableRemoteObject) {
            return object;
        }
        try {
            if (ClusterableRemoteObject.isIDLObject(object)) {
                object = IIOPReplacer.getRemoteIDLStub(object);
            }
            if (ClusterableRemoteObject.isClusterable(object)) {
                if (object instanceof Remote) {
                    clusterableRemoteObject = new ClusterableRemoteObject((Remote)object);
                } else if (object instanceof RemoteWrapper) {
                    clusterableRemoteObject = new ClusterableRemoteObject((RemoteWrapper)object);
                }
            }
        }
        catch (RemoteException remoteException) {
            ConfigurationException configurationException = new ConfigurationException("Failed to bind clusterable object: " + object);
            configurationException.setRootCause(remoteException);
            throw configurationException;
        }
        return clusterableRemoteObject;
    }

    public static void initialize() {
        try {
            WLNamingManager.addStateFactory(new ClusterableRemoteBinderFactory());
        }
        catch (NamingException namingException) {
            throw new AssertionError("impossible exception", (Throwable)namingException);
        }
    }
}

