/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.cluster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import org.omg.CORBA.Object;
import org.omg.PortableServer.Servant;
import weblogic.jndi.Aggregatable;
import weblogic.jndi.OpaqueReference;
import weblogic.jndi.internal.NamingNode;
import weblogic.protocol.LocalServerIdentity;
import weblogic.rmi.cluster.ClusterableRemoteRef;
import weblogic.rmi.cluster.ReplicaAwareInfo;
import weblogic.rmi.cluster.ReplicaAwareRemoteObject;
import weblogic.rmi.extensions.server.DescriptorHelper;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RemoteWrapper;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.internal.CBVWrapper;
import weblogic.rmi.internal.RemoteType;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.rmi.internal.StubInfo;
import weblogic.rmi.internal.StubInfoIntf;
import weblogic.rmi.spi.HostID;
import weblogic.utils.AssertionError;

public class ClusterableRemoteObject
extends ReplicaAwareRemoteObject
implements Aggregatable,
OpaqueReference,
Externalizable {
    private static final long serialVersionUID = 588136583649318138L;
    private RemoteType remoteType = null;
    protected transient ClusterableRemoteRef clusterableRef;

    static boolean isClusterable(java.lang.Object object) {
        java.lang.Object object2 = null;
        if (object instanceof CBVWrapper) {
            object2 = ((CBVWrapper)object).getDelegate();
        } else if (object instanceof Remote) {
            object2 = object;
        } else if (object instanceof RemoteWrapper) {
            object2 = ((RemoteWrapper)object).getRemoteDelegate();
        }
        if (object2 == null) {
            return false;
        }
        try {
            if (object2 instanceof StubInfoIntf) {
                StubInfo stubInfo = ((StubInfoIntf)object2).getStubInfo();
                RemoteReference remoteReference = stubInfo.getRemoteRef();
                return remoteReference instanceof ClusterableRemoteRef;
            }
            RuntimeDescriptor runtimeDescriptor = DescriptorHelper.getDescriptor(object2.getClass());
            return runtimeDescriptor.isClusterable();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    static boolean isIDLObject(java.lang.Object object) {
        return object instanceof Object || object instanceof Servant;
    }

    public ClusterableRemoteObject(Remote remote) throws RemoteException {
        super(remote);
        this.initialize();
    }

    public ClusterableRemoteObject(RemoteWrapper remoteWrapper) throws RemoteException {
        super(remoteWrapper);
        this.initialize();
    }

    private void initialize() {
        try {
            if (this.remoteType == null) {
                this.remoteType = ServerHelper.getDescriptor((Remote)this.getPrimaryRemote()).getRemoteType();
            }
            this.clusterableRef = this.getRef();
        }
        catch (RemoteException remoteException) {
            throw new AssertionError("Attempt to create RemoteObject using unexported Remote", (Throwable)remoteException);
        }
    }

    public java.lang.Object getReferent(Name name, Context context) throws NamingException {
        java.lang.Object object = this.getPrimaryRepresentative();
        if (object == null) {
            throw new NamingException("unable to find primary representative");
        }
        return object;
    }

    public String toString() {
        return super.toString() + "\t" + this.remoteType.toString();
    }

    protected boolean isSameType(ClusterableRemoteObject clusterableRemoteObject) {
        RemoteType remoteType = clusterableRemoteObject.remoteType;
        if (this.remoteType != null && remoteType != null) {
            return this.remoteType.isAssignableFrom(remoteType);
        }
        return false;
    }

    public void onBind(NamingNode namingNode, String string, Aggregatable aggregatable) throws NamingException {
        if (aggregatable == null) {
            try {
                this.initializeRef(namingNode.getNameInNamespace(string));
            }
            catch (RemoteException remoteException) {
                throw new AssertionError("impossible exception", (Throwable)remoteException);
            }
        } else if (aggregatable instanceof ClusterableRemoteObject) {
            ClusterableRemoteObject clusterableRemoteObject = (ClusterableRemoteObject)aggregatable;
            if (!this.isSameType(clusterableRemoteObject)) {
                throw new NameAlreadyBoundException("Failed to bind remote object (" + clusterableRemoteObject + ") to replica aware stub at " + string + " (" + this + ") because it " + "does not implement the same remote interfaces");
            }
            ClusterableRemoteRef clusterableRemoteRef = clusterableRemoteObject.clusterableRef;
            if (!this.clusterableRef.getHostID().equals(clusterableRemoteRef.getHostID())) {
                try {
                    clusterableRemoteObject.initializeRef(namingNode.getNameInNamespace(string));
                    this.clusterableRef.add(clusterableRemoteObject.clusterableRef);
                }
                catch (RemoteException remoteException) {
                    throw new AssertionError("impossible exception", (Throwable)remoteException);
                }
            } else {
                if (this.clusterableRef.getObjectID() != clusterableRemoteRef.getObjectID()) {
                    throw new NameAlreadyBoundException("Failed to bind remote object (" + clusterableRemoteObject + ") to replica aware stub at " + string + "(" + this + ")");
                }
                this.clusterableRef.getReplicaList().add(clusterableRemoteRef.getReplicaList().getPrimary());
            }
        } else {
            throw new NameAlreadyBoundException();
        }
    }

    public void onRebind(NamingNode namingNode, String string, Aggregatable aggregatable) throws NamingException {
        ClusterableRemoteObject clusterableRemoteObject;
        boolean bl = false;
        if (aggregatable instanceof ClusterableRemoteObject && this.isSameType(clusterableRemoteObject = (ClusterableRemoteObject)aggregatable)) {
            try {
                clusterableRemoteObject.initializeRef(namingNode.getNameInNamespace(string));
                this.clusterableRef.replace(clusterableRemoteObject.clusterableRef);
                bl = true;
            }
            catch (RemoteException remoteException) {
                throw new AssertionError("impossible exception", (Throwable)remoteException);
            }
        }
        if (!bl) {
            throw new NameAlreadyBoundException("Can't rebind anything but a replica-aware stub to a name that is currently bound to a replica-aware stub");
        }
    }

    public boolean onUnbind(NamingNode namingNode, String string, Aggregatable aggregatable) throws NamingException {
        if (aggregatable == null) {
            this.clusterableRef.removeOne((HostID)LocalServerIdentity.getIdentity());
            this.setPrimaryRepresentativeToNull();
        } else if (aggregatable instanceof ClusterableRemoteObject) {
            try {
                ClusterableRemoteObject clusterableRemoteObject = (ClusterableRemoteObject)aggregatable;
                if (this.isSameType(clusterableRemoteObject)) {
                    this.clusterableRef.remove(clusterableRemoteObject.getRef());
                }
            }
            catch (RemoteException remoteException) {
                ConfigurationException configurationException = new ConfigurationException("failed to unbind due to unexpected exception");
                configurationException.setRootCause(remoteException);
                throw configurationException;
            }
        }
        return this.clusterableRef.getReplicaCount() == 0;
    }

    protected void initializeRef(String string) throws ConfigurationException {
        if (!this.clusterableRef.isInitialized()) {
            try {
                ReplicaAwareInfo replicaAwareInfo = this.getInfo();
                replicaAwareInfo.setJNDIName(string);
                this.clusterableRef.initialize(replicaAwareInfo);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                ConfigurationException configurationException = new ConfigurationException("failed to rebind due to unexpected exception");
                configurationException.setRootCause(noSuchObjectException);
                throw configurationException;
            }
        }
    }

    public ClusterableRemoteObject() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.remoteType);
        super.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.remoteType = (RemoteType)objectInput.readObject();
        super.readExternal(objectInput);
        this.initialize();
    }
}

