/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.cluster;

import java.lang.reflect.Method;
import java.net.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.jndi.Environment;
import weblogic.rmi.cluster.ClusterableRemoteRef;
import weblogic.rmi.cluster.ReplicaHandler;
import weblogic.rmi.cluster.ReplicaList;
import weblogic.rmi.cluster.RetryHandler;
import weblogic.rmi.extensions.RemoteHelper;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.StubInfoIntf;
import weblogic.transaction.TransactionHelper;
import weblogic.utils.AssertionError;

final class EntityBeanReplicaHandler
implements ReplicaHandler {
    private final Object pk;
    private final String jndiName;
    private int homeListSize = 0;
    private final Environment env;

    EntityBeanReplicaHandler(Object object, String string, Environment environment) {
        this.pk = object;
        this.jndiName = string;
        this.env = environment;
    }

    protected boolean isRecoverableFailure(RuntimeMethodDescriptor runtimeMethodDescriptor, RemoteException remoteException) {
        if (runtimeMethodDescriptor.isIdempotent()) {
            return RemoteHelper.isRecoverableFailure((RemoteException)remoteException);
        }
        return RemoteHelper.isRecoverablePreInvokeFailure((RemoteException)remoteException);
    }

    public RemoteReference loadBalance(RemoteReference remoteReference, Method method, Object[] objectArray) {
        throw new AssertionError("Should never call loadbalance");
    }

    public final RemoteReference failOver(RemoteReference remoteReference, RuntimeMethodDescriptor runtimeMethodDescriptor, Method method, Object[] objectArray, RemoteException remoteException, RetryHandler retryHandler) throws RemoteException {
        int n = retryHandler.getRetryCount();
        Object var8_8 = null;
        if (n != 0 && n > this.homeListSize) {
            throw remoteException;
        }
        if (this.isRecoverableFailure(runtimeMethodDescriptor, remoteException) && TransactionHelper.getTransactionHelper().getTransaction() == null) {
            Context context = null;
            try {
                context = this.env.getInitialContext();
                Object object = context.lookup(this.jndiName);
                if (n == 0) {
                    this.homeListSize = this.getListSize(object);
                }
                Method method2 = object.getClass().getMethod("findByPrimaryKey", this.pk.getClass());
                StubInfoIntf stubInfoIntf = (StubInfoIntf)method2.invoke(object, this.pk);
                RemoteReference remoteReference2 = stubInfoIntf.getStubInfo().getRemoteRef();
                return remoteReference2;
            }
            catch (NamingException namingException) {
                throw new NoSuchObjectException(namingException.toString() + " ClusterAddress (a DNS name) should be set for automatic failover. Check edocs on Configuring a cluster");
            }
            catch (Exception exception) {
                if (exception instanceof java.rmi.ConnectException || exception instanceof ConnectIOException || exception instanceof UnknownHostException || exception instanceof ConnectException) {
                    throw new RemoteException("Couldn't reach " + this.env.getProviderUrl() + ", you should set ClusterAddress (a DNS name) for automatic " + " failover. Check edocs on Configuring a cluster");
                }
                throw remoteException;
            }
            finally {
                if (context != null) {
                    try {
                        context.close();
                    }
                    catch (NamingException namingException) {}
                }
            }
        }
        throw remoteException;
    }

    public ReplicaList getReplicaList() {
        return null;
    }

    public void resetReplicaList(ReplicaList replicaList) {
    }

    public void resetRefreshedCount() {
    }

    private int getListSize(Object object) {
        StubInfoIntf stubInfoIntf = (StubInfoIntf)object;
        ClusterableRemoteRef clusterableRemoteRef = (ClusterableRemoteRef)stubInfoIntf.getStubInfo().getRemoteRef();
        return clusterableRemoteRef.getReplicaCount();
    }
}

