/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import javax.transaction.Transaction;
import weblogic.jndi.Environment;
import weblogic.jndi.internal.ThreadEnvironment;
import weblogic.rmi.cluster.EntityBeanReplicaHandler;
import weblogic.rmi.cluster.ReplicaHandler;
import weblogic.rmi.cluster.RetryHandler;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.BasicRemoteRef;
import weblogic.rmi.internal.Enrollable;
import weblogic.rmi.internal.dgc.DGCClientHelper;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.InboundResponse;
import weblogic.rmi.spi.OutboundRequest;
import weblogic.rmi.spi.RMIRuntime;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.TransactionManager;

public final class EntityRemoteRef
extends BasicRemoteRef {
    private static final long serialVersionUID = -3542562121173822208L;
    private static final boolean DEBUG = false;
    private ReplicaHandler replicaHandler;
    private String jndiName;
    private Object pk;
    private Environment environment;
    private Enrollable enrollable;

    protected void finalize() throws Throwable {
        if (this.enrollable != null) {
            this.enrollable.unenroll();
        }
    }

    public EntityRemoteRef(int n, HostID hostID, String string, Object object) {
        super(n, hostID);
        this.jndiName = string;
        this.pk = object;
    }

    public boolean equals(Object object) {
        if (object instanceof EntityRemoteRef) {
            EntityRemoteRef entityRemoteRef = (EntityRemoteRef)((Object)object);
            if (!entityRemoteRef.pk.equals(this.pk)) {
                return false;
            }
            return entityRemoteRef.jndiName.equals(this.jndiName);
        }
        return false;
    }

    public String toString() {
        return super.toString() + " - hostID: '" + this.hostID + "', oid: '" + this.oid + "'" + " PK " + this.pk;
    }

    public final Object invoke(Remote remote, RuntimeMethodDescriptor runtimeMethodDescriptor, Object[] objectArray, Method method) throws Throwable {
        if (this.environment != null) {
            ThreadEnvironment.push(this.environment);
        }
        try {
            RetryHandler retryHandler = new RetryHandler();
            int n = 0;
            while (true) {
                try {
                    retryHandler.setRetryCount(n);
                    Object object = this.privateInvoke(runtimeMethodDescriptor, objectArray, method);
                    return object;
                }
                catch (RemoteException remoteException) {
                    RemoteReference remoteReference = this.replicaHandler.failOver(null, runtimeMethodDescriptor, method, objectArray, remoteException, retryHandler);
                    this.oid = remoteReference.getObjectID();
                    this.hostID = remoteReference.getHostID();
                    ++n;
                    continue;
                }
                break;
            }
        }
        finally {
            if (this.environment != null) {
                ThreadEnvironment.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object privateInvoke(RuntimeMethodDescriptor runtimeMethodDescriptor, Object[] objectArray, Method method) throws Throwable {
        Transaction transaction = null;
        TransactionManager transactionManager = (TransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager();
        if (!runtimeMethodDescriptor.isTransactional()) {
            transaction = transactionManager.forceSuspend();
        }
        OutboundRequest outboundRequest = this.getOutboundRequest(runtimeMethodDescriptor);
        InboundResponse inboundResponse = null;
        try {
            outboundRequest.marshalArgs(objectArray);
            inboundResponse = outboundRequest.sendReceive();
            Object object = inboundResponse.unmarshalReturn();
            return object;
        }
        finally {
            try {
                if (inboundResponse != null) {
                    inboundResponse.close();
                }
            }
            catch (IOException iOException) {
                throw new UnmarshalException("failed to close response stream", iOException);
            }
            if (!runtimeMethodDescriptor.isTransactional()) {
                transactionManager.forceResume(transaction);
            }
        }
    }

    public EntityRemoteRef() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.jndiName);
        objectOutput.writeObject(this.pk);
        if (this.enrollable != null) {
            this.enrollable.renewLease();
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.jndiName = (String)objectInput.readObject();
        this.pk = objectInput.readObject();
        HostID hostID = this.getHostID();
        this.environment = new Environment();
        if (!hostID.isLocal()) {
            this.environment.setProviderUrl(RMIRuntime.findEndPoint((HostID)hostID).getClusterURL(objectInput));
        }
        this.replicaHandler = new EntityBeanReplicaHandler(this.pk, this.jndiName, this.environment);
        this.enrollable = DGCClientHelper.findAndEnroll((RemoteReference)this);
    }
}

