/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.cluster;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.StateFactory;
import weblogic.jndi.internal.WLNamingManager;
import weblogic.rmi.cluster.MigratableRemoteObject;
import weblogic.utils.AssertionError;

public final class MigratableRemoteBinderFactory
implements StateFactory {
    public Object getStateToBind(Object object, Name name, Context context, Hashtable hashtable) throws NamingException {
        MigratableRemoteObject migratableRemoteObject = null;
        if (MigratableRemoteObject.isEOS(object)) {
            try {
                if (object instanceof Remote) {
                    migratableRemoteObject = new MigratableRemoteObject((Remote)object);
                }
            }
            catch (RemoteException remoteException) {
                ConfigurationException configurationException = new ConfigurationException("Failed to bind clusterable object");
                configurationException.setRootCause(remoteException);
                throw configurationException;
            }
        }
        return migratableRemoteObject;
    }

    public static void initialize() {
        try {
            WLNamingManager.addStateFactory(new MigratableRemoteBinderFactory());
        }
        catch (NamingException namingException) {
            throw new AssertionError("impossible exception", (Throwable)namingException);
        }
    }
}

