/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Arrays;
import javax.naming.NamingException;
import weblogic.cluster.migration.MigrationManager;
import weblogic.jndi.Aggregatable;
import weblogic.jndi.internal.NamingNode;
import weblogic.rmi.cluster.BasicReplicaList;
import weblogic.rmi.cluster.ClusterableRemoteObject;
import weblogic.rmi.cluster.ClusterableRemoteRef;
import weblogic.rmi.cluster.MigratableReplicaHandler;
import weblogic.rmi.cluster.ReplicaList;
import weblogic.rmi.extensions.server.DescriptorHelper;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RemoteWrapper;
import weblogic.rmi.internal.CBVWrapper;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.rmi.internal.StubInfo;
import weblogic.rmi.internal.StubInfoIntf;
import weblogic.rmi.spi.HostID;
import weblogic.utils.Debug;

public final class MigratableRemoteObject
extends ClusterableRemoteObject {
    private static final long serialVersionUID = -8639826242081467352L;
    private static final boolean DEBUG = true;

    public static boolean isEOS(Object object) {
        Remote remote = null;
        if (object instanceof CBVWrapper) {
            remote = ((CBVWrapper)object).getDelegate();
        } else if (object instanceof Remote) {
            remote = (Remote)object;
        } else if (object instanceof RemoteWrapper) {
            remote = ((RemoteWrapper)object).getRemoteDelegate();
        }
        if (remote == null) {
            return false;
        }
        try {
            boolean bl = false;
            if (remote instanceof StubInfoIntf) {
                StubInfo stubInfo = ((StubInfoIntf)remote).getStubInfo();
                RemoteReference remoteReference = stubInfo.getRemoteRef();
                if (remoteReference instanceof ClusterableRemoteRef) {
                    ClusterableRemoteRef clusterableRemoteRef = (ClusterableRemoteRef)remoteReference;
                    bl = clusterableRemoteRef.getReplicaHandler() instanceof MigratableReplicaHandler;
                }
            } else {
                RuntimeDescriptor runtimeDescriptor = DescriptorHelper.getDescriptor(remote.getClass());
                String string = runtimeDescriptor.getReplicaHandlerClassName();
                bl = string != null && string.equals(MigratableReplicaHandler.class.getName());
            }
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private void resetList(String string) {
        int n;
        HostID[] hostIDArray = MigrationManager.singleton().getMigratableHostList(string);
        ReplicaList replicaList = this.clusterableRef.getReplicaList();
        if (hostIDArray == null) {
            return;
        }
        Debug.say((String)(string + " OLD LIST " + replicaList));
        Debug.say((String)(string + " MIG MAN LIST " + Arrays.asList((Object[])hostIDArray)));
        if (hostIDArray == null || hostIDArray.length == 0) {
            Debug.say((String)("WARNING For service " + string + " the migration man. returned a list of 0"));
            return;
        }
        BasicReplicaList basicReplicaList = null;
        for (n = 0; n < hostIDArray.length; ++n) {
            RemoteReference remoteReference;
            if (hostIDArray[n] == null || (remoteReference = replicaList.findReplicaHostedBy(hostIDArray[n])) == null) continue;
            if (basicReplicaList == null) {
                basicReplicaList = new BasicReplicaList(remoteReference);
                continue;
            }
            basicReplicaList.add(remoteReference);
        }
        for (n = 0; n < replicaList.size(); ++n) {
            if (basicReplicaList == null) {
                basicReplicaList = new BasicReplicaList(replicaList.get(n));
            }
            if (basicReplicaList.findReplicaHostedBy(replicaList.get(n).getHostID()) != null) continue;
            basicReplicaList.add(replicaList.get(n));
        }
        if (basicReplicaList == null || basicReplicaList.size() == 0) {
            return;
        }
        Debug.say((String)(string + " NEW LIST " + basicReplicaList));
        this.clusterableRef.getReplicaList().resetWithoutShuffle((ReplicaList)basicReplicaList);
        this.clusterableRef.setCurRef(basicReplicaList.get(0));
    }

    public void onBind(NamingNode namingNode, String string, Aggregatable aggregatable) throws NamingException {
        super.onBind(namingNode, string, aggregatable);
        this.resetList(string);
    }

    public void onRebind(NamingNode namingNode, String string, Aggregatable aggregatable) throws NamingException {
        super.onRebind(namingNode, string, aggregatable);
        this.resetList(string);
    }

    public boolean onUnbind(NamingNode namingNode, String string, Aggregatable aggregatable) throws NamingException {
        boolean bl = super.onUnbind(namingNode, string, aggregatable);
        this.resetList(string);
        return bl;
    }

    public MigratableRemoteObject(Remote remote) throws RemoteException {
        super(remote);
    }

    public MigratableRemoteObject(RemoteWrapper remoteWrapper) throws RemoteException {
        super(remoteWrapper);
    }

    public MigratableRemoteObject() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
    }
}

