/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.cluster;

import java.rmi.RemoteException;
import weblogic.cluster.migration.Migratable;
import weblogic.cluster.migration.MigratableActivatingException;
import weblogic.cluster.migration.MigratableInactiveException;
import weblogic.cluster.migration.MigrationManager;
import weblogic.rmi.cluster.ClusterableServerRef;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.spi.InboundRequest;
import weblogic.rmi.spi.OutboundResponse;
import weblogic.utils.AssertionError;

public final class MigratableServerRef
extends ClusterableServerRef {
    public MigratableServerRef(Object object) throws RemoteException {
        super(object);
    }

    public MigratableServerRef(int n, Object object) throws RemoteException {
        super(n, object);
    }

    public final void invoke(RuntimeMethodDescriptor runtimeMethodDescriptor, InboundRequest inboundRequest, OutboundResponse outboundResponse) throws Exception {
        int n = 0;
        try {
            n = MigrationManager.singleton().getMigratableState((Migratable)this.getImplementation());
        }
        catch (ClassCastException classCastException) {
            throw new AssertionError("Implementation is not of type migratable");
        }
        switch (n) {
            case 0: {
                throw new MigratableInactiveException("Service migrated");
            }
            case 2: {
                throw new MigratableActivatingException("Service in the process of migration");
            }
            case 1: {
                super.invoke(runtimeMethodDescriptor, inboundRequest, outboundResponse);
                break;
            }
            default: {
                throw new AssertionError("Migratable service in unknown state " + n);
            }
        }
    }
}

