/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.cluster;

import java.io.Externalizable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import weblogic.rmi.cluster.ClusterableRemoteRef;
import weblogic.rmi.cluster.ReplicaAwareRemoteObject;
import weblogic.rmi.cluster.ReplicaList;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.internal.StubInfoIntf;
import weblogic.utils.AssertionError;

public final class PrimarySecondaryRemoteObject
extends ReplicaAwareRemoteObject
implements Externalizable {
    private static final long serialVersionUID = 8733059777893264840L;
    private transient Remote secondary;

    public PrimarySecondaryRemoteObject(Remote remote, Remote remote2) throws RemoteException {
        super(remote);
        try {
            ClusterableRemoteRef clusterableRemoteRef = this.getRef();
            clusterableRemoteRef.initialize(this.getInfo());
            this.changeSecondary(remote2);
        }
        catch (RemoteException remoteException) {
            throw new AssertionError("impossible exception", (Throwable)remoteException);
        }
    }

    public void changeSecondary(Remote remote) {
        ReplicaList replicaList;
        ClusterableRemoteRef clusterableRemoteRef;
        try {
            clusterableRemoteRef = this.getRef();
        }
        catch (RemoteException remoteException) {
            throw new AssertionError("impossible exception", (Throwable)remoteException);
        }
        RemoteReference remoteReference = clusterableRemoteRef.getPrimaryRef();
        RemoteReference remoteReference2 = null;
        if (remote instanceof StubInfoIntf) {
            this.secondary = remote;
            replicaList = (ClusterableRemoteRef)((StubInfoIntf)remote).getStubInfo().getRemoteRef();
            remoteReference2 = replicaList.getPrimaryRef();
        } else if (remote != null) {
            throw new AssertionError("if not null secondary must always be a Stub");
        }
        try {
            replicaList = (ReplicaList)clusterableRemoteRef.getReplicaList().clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError("couldn't clone replica list");
        }
        replicaList.clear();
        replicaList.add(remoteReference);
        if (remoteReference2 != null) {
            replicaList.add(remoteReference2);
        }
        clusterableRemoteRef.resetReplicaList(replicaList);
    }

    public Remote getSecondary() {
        return this.secondary;
    }

    public Remote getPrimary() {
        return this.getPrimaryRemote();
    }

    public PrimarySecondaryRemoteObject() {
    }
}

