/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.cluster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import weblogic.application.AppClassLoaderManager;
import weblogic.application.internal.AppClassLoaderManagerImpl;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.jndi.internal.NameAlreadyUnboundException;
import weblogic.rmi.cluster.ClusterableRemoteRef;
import weblogic.rmi.cluster.ClusterableServerRef;
import weblogic.rmi.cluster.ReplicaAwareInfo;
import weblogic.rmi.extensions.server.DescriptorHelper;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RemoteWrapper;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.internal.CBVWrapper;
import weblogic.rmi.internal.StubInfo;
import weblogic.rmi.internal.StubInfoIntf;
import weblogic.utils.AssertionError;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.AugmentableClassLoaderManager;
import weblogic.utils.classloaders.GenericClassLoader;

public class ReplicaAwareRemoteObject
implements Externalizable {
    private static final long serialVersionUID = -3476281508384826108L;
    private Object primaryRepresentative;
    private String primaryRemoteName;
    private String appName;
    private static final boolean DEBUG = false;
    private transient Remote primaryRemote;
    private transient ReplicaAwareInfo info;
    private transient ClusterableRemoteRef remoteRef;
    private transient StubInfoIntf stub;
    private transient boolean isRemoteWrapper;

    protected ReplicaAwareRemoteObject(Remote remote) throws RemoteException {
        if (remote instanceof CBVWrapper) {
            this.primaryRepresentative = remote;
            this.primaryRemote = ((CBVWrapper)remote).getDelegate();
        } else {
            this.primaryRepresentative = remote;
            this.primaryRemote = remote;
        }
        this.initialize();
        if (!ServerHelper.isCollocated((Object)this.primaryRemote)) {
            throw new AssertionError(remote.toString() + " is not hosted locally");
        }
    }

    protected ReplicaAwareRemoteObject(RemoteWrapper remoteWrapper) throws RemoteException {
        this.isRemoteWrapper = true;
        this.primaryRepresentative = remoteWrapper;
        this.primaryRemote = remoteWrapper.getRemoteDelegate();
        this.initialize();
        if (!ServerHelper.isCollocated((Object)this.primaryRemote)) {
            throw new AssertionError(remoteWrapper.toString() + " is not hosted locally");
        }
    }

    private void initialize() throws RemoteException {
        this.stub = (StubInfoIntf)ServerHelper.exportObject((Remote)this.primaryRemote);
        this.remoteRef = (ClusterableRemoteRef)this.stub.getStubInfo().getRemoteRef();
        this.primaryRemoteName = this.primaryRemote.getClass().getName();
        this.appName = this.stub.getStubInfo().getApplicationName();
    }

    public Object getPrimaryRepresentative() {
        if (this.primaryRepresentative == null) {
            try {
                AppClassLoaderManager appClassLoaderManager;
                GenericClassLoader genericClassLoader;
                Class clazz = null;
                clazz = this.appName != null ? ((genericClassLoader = (appClassLoaderManager = AppClassLoaderManagerImpl.getAppClassLoaderManager()).findLoader(new Annotation(this.appName))) != null ? genericClassLoader.loadClass(this.primaryRemoteName) : AugmentableClassLoaderManager.getAugmentableSystemClassLoader().loadClass(this.primaryRemoteName)) : AugmentableClassLoaderManager.getAugmentableSystemClassLoader().loadClass(this.primaryRemoteName);
                appClassLoaderManager = DescriptorHelper.getDescriptor((Class)clazz);
                return new StubInfo((RemoteReference)this.getRef(), appClassLoaderManager.getClientRuntimeDescriptor(this.appName), appClassLoaderManager.getStubClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            catch (RemoteException remoteException) {
                throw new AssertionError("Unexpected exception ", (Throwable)remoteException);
            }
        }
        return this.primaryRepresentative;
    }

    protected void setPrimaryRepresentativeToNull() {
        this.primaryRepresentative = null;
    }

    public Remote getPrimaryRemote() {
        return this.primaryRemote;
    }

    public ReplicaAwareInfo getInfo() throws NoSuchObjectException {
        if (this.info == null) {
            ClusterableServerRef clusterableServerRef = (ClusterableServerRef)ServerHelper.getServerReference((Remote)this.primaryRemote);
            this.info = clusterableServerRef.getInfo();
        }
        return this.info;
    }

    public ClusterableRemoteRef getRef() throws RemoteException {
        if (this.remoteRef == null) {
            if (!ServerHelper.isCollocated((Object)this.primaryRemote)) {
                throw new AssertionError(this.primaryRemote + ": is not local");
            }
            ClusterableServerRef clusterableServerRef = (ClusterableServerRef)ServerHelper.getServerReference((Remote)this.primaryRemote);
            this.remoteRef = clusterableServerRef.getReplicaAwareRemoteRef();
        }
        return this.remoteRef;
    }

    public ReplicaAwareRemoteObject() {
    }

    public String toString() {
        return this.remoteRef.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.isRemoteWrapper) {
            if (this.primaryRepresentative == null) {
                throw new NameAlreadyUnboundException("Object already partially unbound in cluster.");
            }
            objectOutput.writeBoolean(this.isRemoteWrapper);
            objectOutput.writeObject(this.primaryRepresentative);
        } else if (objectOutput instanceof WLObjectOutput) {
            WLObjectOutput wLObjectOutput = (WLObjectOutput)objectOutput;
            wLObjectOutput.writeBoolean(this.isRemoteWrapper);
            wLObjectOutput.writeString(this.primaryRemoteName);
            wLObjectOutput.writeString(this.appName);
            wLObjectOutput.writeObject((Object)this.getRef());
        } else {
            objectOutput.writeBoolean(this.isRemoteWrapper);
            objectOutput.writeObject(this.primaryRemoteName);
            objectOutput.writeObject(this.appName);
            objectOutput.writeObject(this.getRef());
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.isRemoteWrapper = objectInput.readBoolean();
        if (this.isRemoteWrapper) {
            this.primaryRepresentative = objectInput.readObject();
            Remote remote = ((RemoteWrapper)this.primaryRepresentative).getRemoteDelegate();
            if (remote instanceof StubInfoIntf) {
                this.primaryRemoteName = remote.getClass().getName();
                StubInfoIntf stubInfoIntf = (StubInfoIntf)remote;
                this.remoteRef = (ClusterableRemoteRef)stubInfoIntf.getStubInfo().getRemoteRef();
            } else {
                this.primaryRemote = remote;
                this.initialize();
            }
        } else if (objectInput instanceof WLObjectInput) {
            WLObjectInput wLObjectInput = (WLObjectInput)objectInput;
            this.primaryRemoteName = wLObjectInput.readString();
            this.appName = wLObjectInput.readString();
            this.remoteRef = (ClusterableRemoteRef)wLObjectInput.readObject();
        } else {
            this.primaryRemoteName = (String)objectInput.readObject();
            this.appName = (String)objectInput.readObject();
            this.remoteRef = (ClusterableRemoteRef)objectInput.readObject();
        }
    }

    static void p(String string) {
        System.out.println("<ReplicaAwareRemoteObject>: " + string);
    }
}

