/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.extensions.server;

import java.io.IOException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import javax.resource.spi.security.PasswordCredential;
import weblogic.management.configuration.SecurityConfigurationMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerIdentity;
import weblogic.rjvm.RJVM;
import weblogic.rmi.extensions.RemoteHelper;
import weblogic.rmi.spi.EndPoint;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.RMIRuntime;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.DefaultUserInfoImpl;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.acl.internal.Security;
import weblogic.security.service.AdminResource;
import weblogic.security.service.AuthorizationManager;
import weblogic.security.service.CredentialManager;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.RemoteResource;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.spi.Resource;

public final class RemoteDomainSecurityHelper {
    private static final boolean DEBUG = Boolean.getBoolean("weblogic.debug.DebugCrossDomainSecurity");
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String CROSS_DOMAIN_PROTOCOL = "cross-domain-protocol";
    private static final String CROSS_DOMAIN_USER = "cross-domain";
    private static final String CROSS_DOMAIN_ADMIN_RESOURCE = "CrossDomain";
    public static final int ACCEPT_CALL = 0;
    public static final int REJECT_CALL = 1;
    public static final int UNDETERMINABLE = 2;

    private static boolean isCDSEnabled() {
        return SINGLETON.secConfig.isCrossDomainSecurityEnabled();
    }

    public static AuthenticatedSubject getSubject(String string) throws IOException, RemoteException {
        if (!RemoteDomainSecurityHelper.isCDSEnabled() || !RemoteDomainSecurityHelper.isRemoteDomain(string)) {
            return null;
        }
        final String string2 = RemoteDomainSecurityHelper.convertAdminProtocol(string);
        EndPoint endPoint = null;
        if (RMIRuntime.supportServerURL((String)string2)) {
            try {
                endPoint = (EndPoint)SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)SubjectUtils.getAnonymousSubject(), (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return RMIRuntime.findOrCreateEndPoint((String)string2);
                    }
                });
                return RemoteDomainSecurityHelper.getSubjectInternal(endPoint);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static String convertAdminProtocol(String string) {
        String string2 = string;
        try {
            int n = string.indexOf(58);
            String string3 = string.substring(0, n);
            if ("admin".equals(string3)) {
                string2 = ProtocolManager.getDefaultAdminProtocol().getProtocolName() + string.substring(n);
            }
            return string2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new AssertionError((Object)("unsupported protocol " + string));
        }
    }

    public static AuthenticatedSubject getSubject(Object object) throws RemoteException, IllegalArgumentException {
        if (!RemoteDomainSecurityHelper.isCDSEnabled()) {
            return null;
        }
        AuthenticatedSubject authenticatedSubject = RemoteDomainSecurityHelper.getSubjectInternal(RemoteHelper.getEndPoint((Object)object));
        if (DEBUG) {
            RemoteDomainSecurityHelper.debug("getSubject for  " + object + " returned:" + authenticatedSubject);
        }
        return authenticatedSubject;
    }

    public static AuthenticatedSubject getSubject(EndPoint endPoint) throws RemoteException {
        if (!RemoteDomainSecurityHelper.isCDSEnabled()) {
            return null;
        }
        AuthenticatedSubject authenticatedSubject = RemoteDomainSecurityHelper.getSubjectInternal(endPoint);
        if (DEBUG) {
            RemoteDomainSecurityHelper.debug("getSubject for  " + endPoint + " returned:" + authenticatedSubject);
        }
        return authenticatedSubject;
    }

    private static AuthenticatedSubject getSubjectInternal(EndPoint endPoint) throws RemoteException {
        HostID hostID = endPoint.getHostID();
        if (!(hostID instanceof ServerIdentity)) {
            return null;
        }
        String string = ((ServerIdentity)hostID).getDomainName();
        if (string == null || RemoteDomainSecurityHelper.isDomainExcluded(string)) {
            return null;
        }
        PasswordCredential passwordCredential = RemoteDomainSecurityHelper.getCredentials(string);
        if (DEBUG) {
            RemoteDomainSecurityHelper.debug("getCredentials() returned " + passwordCredential);
        }
        if (passwordCredential == null) {
            return null;
        }
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getASFromAU((AuthenticatedUser)RemoteDomainSecurityHelper.authenticate(endPoint, passwordCredential));
        if (DEBUG) {
            RemoteDomainSecurityHelper.debug("authenticate returned " + authenticatedSubject);
        }
        return authenticatedSubject;
    }

    private static AuthenticatedUser authenticate(EndPoint endPoint, PasswordCredential passwordCredential) throws RemoteException {
        if (passwordCredential == null) {
            return null;
        }
        DefaultUserInfoImpl defaultUserInfoImpl = new DefaultUserInfoImpl(passwordCredential.getUserName(), new String(passwordCredential.getPassword()));
        if (DEBUG) {
            RemoteDomainSecurityHelper.debug(passwordCredential.getUserName() + " - " + new String(passwordCredential.getPassword()));
        }
        return Security.authenticate(defaultUserInfoImpl, (RJVM)endPoint, ProtocolManager.getDefaultProtocol(), null);
    }

    private static PasswordCredential getCredentials(String string) {
        CredentialManager credentialManager = (CredentialManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)kernelId, (String)"weblogicDEFAULT", (SecurityService.ServiceType)SecurityService.ServiceType.CREDENTIALMANAGER);
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        if (DEBUG) {
            RemoteDomainSecurityHelper.debug("current subject=" + authenticatedSubject + ", domainName=" + string);
        }
        RemoteResource remoteResource = new RemoteResource(CROSS_DOMAIN_PROTOCOL, string, null, null, null);
        Object[] objectArray = credentialManager.getCredentials(kernelId, CROSS_DOMAIN_USER, (Resource)remoteResource, null, "weblogic.UserPassword");
        if (DEBUG) {
            RemoteDomainSecurityHelper.debug("got mappings=" + objectArray);
        }
        if (objectArray == null) {
            return null;
        }
        if (DEBUG) {
            RemoteDomainSecurityHelper.debug("got mappings length=" + objectArray.length);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof PasswordCredential)) continue;
            if (DEBUG) {
                RemoteDomainSecurityHelper.debug("cred=" + object);
            }
            return (PasswordCredential)object;
        }
        if (DEBUG) {
            RemoteDomainSecurityHelper.debug("found no password credential !");
        }
        return null;
    }

    public static int acceptRemoteDomainCall(HostID hostID, AuthenticatedSubject authenticatedSubject) {
        if (!RemoteDomainSecurityHelper.isCDSEnabled()) {
            if (DEBUG) {
                RemoteDomainSecurityHelper.debug("acceptRemoteDomainCall for " + authenticatedSubject + "= No CDS");
            }
            return 2;
        }
        if (!(hostID instanceof ServerIdentity)) {
            if (DEBUG) {
                RemoteDomainSecurityHelper.debug("acceptRemoteDomainCall for " + authenticatedSubject + "= Not ServerIdentity" + hostID);
            }
            return 2;
        }
        String string = ((ServerIdentity)hostID).getDomainName();
        if (string == null || LocalServerIdentity.getIdentity().getDomainName().equals(string) || RemoteDomainSecurityHelper.isDomainExcluded(string)) {
            if (DEBUG) {
                RemoteDomainSecurityHelper.debug("acceptRemoteDomainCall for " + authenticatedSubject + "= UNDETERMINABLE");
            }
            return 2;
        }
        AdminResource adminResource = new AdminResource(CROSS_DOMAIN_ADMIN_RESOURCE, null, null);
        String string2 = "weblogicDEFAULT";
        AuthorizationManager authorizationManager = (AuthorizationManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)kernelId, (String)string2, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHORIZE);
        boolean bl = authorizationManager.isAccessAllowed(authenticatedSubject, (Resource)adminResource, null);
        if (DEBUG) {
            RemoteDomainSecurityHelper.debug("acceptRemoteDomainCall for " + authenticatedSubject + "=" + bl);
        }
        return bl ? 0 : 1;
    }

    public static boolean isRemoteDomain(String string) throws IOException, RemoteException {
        if (DEBUG) {
            RemoteDomainSecurityHelper.debug("[RemoteDomainSecurityHelper] isRemoteDomain: url= " + string);
        }
        if (string == null || string.length() == 0) {
            return false;
        }
        String string2 = RemoteDomainSecurityHelper.convertAdminProtocol(string);
        boolean bl = false;
        if (RMIRuntime.supportServerURL((String)string2)) {
            bl = RemoteDomainSecurityHelper.isRemoteDomain(RMIRuntime.findOrCreateEndPoint((String)string2));
        }
        if (DEBUG) {
            RemoteDomainSecurityHelper.debug("[RemoteDomainSecurityHelper] isRemoteDomain: url= " + string2 + " isRemote==" + bl);
        }
        return bl;
    }

    public static boolean isRemoteDomain(EndPoint endPoint) {
        HostID hostID = endPoint.getHostID();
        if (!(hostID instanceof ServerIdentity)) {
            return false;
        }
        String string = ((ServerIdentity)hostID).getDomainName();
        if (string != null && !SINGLETON.localName.equals(string)) {
            if (DEBUG) {
                RemoteDomainSecurityHelper.debug("[RemoteDomainSecurityHelper] isRemoteDomain: TRUE remote domainName= " + string + "!=" + SINGLETON.localName);
            }
            return true;
        }
        if (DEBUG) {
            RemoteDomainSecurityHelper.debug("[RemoteDomainSecurityHelper] isRemoteDomain: FALSE remote domainName= " + string + "==" + SINGLETON.localName);
        }
        return false;
    }

    private static boolean isDomainExcluded(String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = SINGLETON.secConfig.getExcludedDomainNames();
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private static void debug(String string) {
        if (DEBUG) {
            System.out.println("[RemoteDomainSecurityHelper] " + string);
        }
    }

    static /* synthetic */ AuthenticatedSubject access$000() {
        return kernelId;
    }

    private static class SINGLETON {
        static SecurityConfigurationMBean secConfig = ManagementService.getRuntimeAccess(RemoteDomainSecurityHelper.access$000()).getDomain().getSecurityConfiguration();
        static String localName = LocalServerIdentity.getIdentity().getDomainName();

        private SINGLETON() {
        }
    }
}

