/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import weblogic.common.internal.RMIBootServiceImpl;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JTAMBean;
import weblogic.management.provider.ManagementService;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.internal.OIDManager;
import weblogic.rmi.provider.WorkContextAccessController;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.RemoteLifeCycleOperationsImpl;
import weblogic.server.ServiceFailureException;

public final class RMIServerService
extends AbstractServerService {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void start() throws ServiceFailureException {
        try {
            OIDManager.getInstance().initialize();
            ServerHelper.exportObject((Remote)new RMIBootServiceImpl());
            WorkContextAccessController.initialize();
            ServerHelper.exportObject((Remote)RemoteLifeCycleOperationsImpl.getInstance());
        }
        catch (RemoteException remoteException) {
            throw new ServiceFailureException((Throwable)remoteException);
        }
    }

    public static int getTransactionTimeoutMillis() {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        JTAMBean jTAMBean = domainMBean.getJTA();
        return jTAMBean.getTimeoutSeconds() * 1000;
    }
}

