/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal.wls;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.common.internal.WLObjectOutputStream;
import weblogic.rmi.extensions.server.CBVOutputStream;
import weblogic.rmi.extensions.server.ColocatedStream;
import weblogic.rmi.internal.CBVOutput;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkOutput;
import weblogic.utils.io.Immutable;
import weblogic.utils.io.StringOutput;

public class WLSCBVOutput
extends WLObjectOutputStream
implements CBVOutput,
ChunkOutput,
StringOutput,
ColocatedStream,
ObjectOutput {
    private CBVOutputStream cbvos;

    public WLSCBVOutput(CBVOutputStream cBVOutputStream, OutputStream outputStream) throws IOException {
        super(outputStream);
        this.cbvos = cBVOutputStream;
    }

    public void setDelegate(CBVOutputStream cBVOutputStream, OutputStream outputStream) {
        this.cbvos = cBVOutputStream;
        super.setDelegate(outputStream);
    }

    public void writeUTF(String string) throws IOException {
        this.cbvos.writeObjectSpecial((Object)string);
    }

    public void writeUTF8(String string) throws IOException {
        this.cbvos.writeObjectSpecial((Object)string);
    }

    public void writeASCII(String string) throws IOException {
        this.cbvos.writeObjectSpecial((Object)string);
    }

    public void writeChunks(Chunk chunk) throws IOException {
        this.cbvos.writeObjectSpecial((Object)chunk);
    }

    public final void writeImmutable(Object object) throws IOException {
        this.cbvos.writeObjectSpecial(object);
    }

    protected Object replaceObject(Object object) throws IOException {
        if ((object = super.replaceObject(object)) instanceof Immutable) {
            return new ImmutableWrapper(object);
        }
        return object;
    }

    protected void writeClassDescriptor(ObjectStreamClass objectStreamClass) throws IOException {
        this.cbvos.writeObjectSpecial((Object)objectStreamClass);
    }

    public void close() throws IOException {
        this.cbvos = null;
        super.close();
    }

    private static final class ImmutableWrapper
    implements Immutable,
    Externalizable {
        private static final long serialVersionUID = -7325914689974638362L;
        private Object obj;

        public ImmutableWrapper() {
        }

        private ImmutableWrapper(Object object) {
            this.obj = object;
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            ((WLObjectOutput)objectOutput).writeImmutable(this.obj);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.obj = ((WLObjectInput)objectInput).readImmutable();
        }

        public Object readResolve() throws ObjectStreamException {
            return this.obj;
        }
    }
}

