/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal.wls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import weblogic.common.internal.VersionInfoFactory;
import weblogic.jndi.Environment;
import weblogic.kernel.Kernel;
import weblogic.rmi.cluster.ReplicaList;
import weblogic.rmi.extensions.server.CBVInputStream;
import weblogic.rmi.extensions.server.CBVOutputStream;
import weblogic.rmi.extensions.server.InvokableServerReference;
import weblogic.rmi.extensions.server.ReferenceHelper;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.BasicServerRef;
import weblogic.rmi.internal.CBVInput;
import weblogic.rmi.internal.CBVOutput;
import weblogic.rmi.internal.ClusterAwareServerReference;
import weblogic.rmi.internal.DefaultCBVInput;
import weblogic.rmi.internal.DefaultCBVOutput;
import weblogic.rmi.internal.DefaultExecuteRequest;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.internal.wls.CEReferenceHelperImpl;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.InboundRequest;
import weblogic.rmi.spi.InvokeHandler;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.SecurityServiceManager;
import weblogic.work.Work;

public class WLSClientRMIEnvironment
extends RMIEnvironment {
    private static final String WLS_STUB_VERSION = "_" + VersionInfoFactory.getPeerInfo().getMajor() + VersionInfoFactory.getPeerInfo().getMinor() + VersionInfoFactory.getPeerInfo().getServicePack() + "_WLStub";
    private static final String DEFAULT_STUB_VERSION = "_1036_WLStub";
    private static final String DEFAULT_SYSTEM_SECURITY = "supported";
    private static final boolean DEFAULT_NETWORK_CLASS_LOADING = false;
    private static final String NETWORK_CLASS_LOADING_PROP = "weblogic.rmi.networkclassloadingenabled";
    private static final int DEFAULT_TRAN_TIMEOUT = 30000;

    public WLSClientRMIEnvironment() {
        ReferenceHelper.setReferenceHelper((ReferenceHelper)new CEReferenceHelperImpl());
    }

    public long getTimedOutRefIsolationTime() {
        return Kernel.getConfig().getTimedOutRefIsolationTime();
    }

    public boolean isTracingEnabled() {
        return Kernel.isTracingEnabled();
    }

    public String getIIOPSystemSecurity() {
        return DEFAULT_SYSTEM_SECURITY;
    }

    public boolean isLogRemoteExceptions() {
        return Kernel.getConfig().isLogRemoteExceptionsEnabled();
    }

    public int getHeartbeatPeriodLength() {
        return Kernel.getConfig().getPeriodLength();
    }

    public boolean isRefreshClientRuntimeDescriptor() {
        return Kernel.getConfig().getRefreshClientRuntimeDescriptor();
    }

    public int getDGCIdlePeriodsUntilTimeout() {
        return Kernel.getConfig().getDGCIdlePeriodsUntilTimeout();
    }

    public boolean isInstrumentStackTrace() {
        return Kernel.getConfig().isInstrumentStackTraceEnabled();
    }

    public boolean isNetworkClassLoadingEnabled() {
        if (System.getProperty(NETWORK_CLASS_LOADING_PROP) != null) {
            return Boolean.getBoolean(NETWORK_CLASS_LOADING_PROP);
        }
        return false;
    }

    public int getTransactionTimeoutMillis() {
        return 30000;
    }

    public String getStubVersion() {
        return DEFAULT_STUB_VERSION;
    }

    public CBVInput getCBVInput(CBVInputStream cBVInputStream, InputStream inputStream) throws IOException {
        return new DefaultCBVInput(cBVInputStream, inputStream);
    }

    public CBVOutput getCBVOutput(CBVOutputStream cBVOutputStream, OutputStream outputStream) throws IOException {
        return new DefaultCBVOutput(cBVOutputStream, outputStream);
    }

    public Parser getSAXParser() throws SAXException, ParserConfigurationException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        Parser parser2 = sAXParser.getParser();
        parser2.setEntityResolver(new DefaultRMIEntityResolver());
        parser2.setErrorHandler(new DefaultErrorHandler());
        return parser2;
    }

    public Work createExecuteRequest(BasicServerRef basicServerRef, InboundRequest inboundRequest, RuntimeMethodDescriptor runtimeMethodDescriptor, InvokeHandler invokeHandler, AuthenticatedSubject authenticatedSubject) {
        return new DefaultExecuteRequest(basicServerRef, inboundRequest, runtimeMethodDescriptor, invokeHandler, authenticatedSubject);
    }

    public ClusterAwareServerReference createClusteredServerRef(InvokableServerReference invokableServerReference) {
        throw new AssertionError((Object)"Clustering not supported");
    }

    public String getIIOPMangledName(Method method, Class clazz) {
        throw new AssertionError((Object)"RMI over IIOP not supported");
    }

    public boolean isIIOPResponse(Object object) {
        return false;
    }

    public Object replaceSpecialCBVObject(Object object) {
        return null;
    }

    public ClassLoader getDescriptorClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public boolean isIIOPHostID(HostID hostID) {
        return false;
    }

    public Context getContext(Object object) throws NamingException {
        return ((Environment)object).getContext(null);
    }

    public boolean isIIOPVendorInfoCluster(ReplicaList replicaList) {
        return false;
    }

    public boolean isIIOPInboundRequest(InboundRequest inboundRequest) {
        return false;
    }

    public Object newEnvironment() {
        try {
            Class<?> clazz = Class.forName("weblogic.jndi.Environment");
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        catch (SecurityException securityException) {
            throw new AssertionError((Object)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AssertionError((Object)illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
    }

    public Object threadEnvironmentGet() {
        try {
            Class<?> clazz = Class.forName("weblogic.jndi.internal.ThreadEnvironment");
            Method method = clazz.getMethod("get", null);
            return method.invoke(null, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        catch (SecurityException securityException) {
            throw new AssertionError((Object)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AssertionError((Object)illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
    }

    public Object threadEnvironmentPop() {
        try {
            Class<?> clazz = Class.forName("weblogic.jndi.internal.ThreadEnvironment");
            Method method = clazz.getMethod("pop", null);
            return method.invoke(null, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        catch (SecurityException securityException) {
            throw new AssertionError((Object)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AssertionError((Object)illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
    }

    public void threadEnvironmentPush(Object object) {
        try {
            Class<?> clazz = Class.forName("weblogic.jndi.internal.ThreadEnvironment");
            Class<?> clazz2 = Class.forName("weblogic.jndi.Environment");
            Class[] classArray = new Class[]{clazz2};
            Method method = clazz.getMethod("push", classArray);
            Object[] objectArray = new Object[]{object};
            method.invoke(null, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        catch (SecurityException securityException) {
            throw new AssertionError((Object)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AssertionError((Object)illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
    }

    public Hashtable getProperties(Object object) {
        return ((Environment)object).getProperties();
    }

    public boolean isAdminModeAccessException(NamingException namingException) {
        return false;
    }

    public String getClusterDefaultLoadAlgorithm() {
        return "round-robin";
    }

    public boolean isMigratableActivatingException(RemoteException remoteException) {
        return false;
    }

    public boolean isMigratableInactiveException(RemoteException remoteException) {
        return false;
    }

    public boolean isServerInCluster() {
        return false;
    }

    public AuthenticatedSubject getCurrentSubjectForWire(AuthenticatedSubject authenticatedSubject) {
        return SecurityServiceManager.getCurrentSubjectForWire((AuthenticatedSubject)authenticatedSubject);
    }

    public boolean rmiShutdownAcceptRequest(int n, AuthenticatedSubject authenticatedSubject) {
        return true;
    }

    public boolean nonTxRmiShutdownAcceptRequest(int n, AuthenticatedSubject authenticatedSubject, Object object) {
        return true;
    }

    private static final class DefaultErrorHandler
    implements ErrorHandler {
        private DefaultErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) {
        }
    }

    private static final class DefaultRMIEntityResolver
    implements EntityResolver {
        private DefaultRMIEntityResolver() {
        }

        public InputSource resolveEntity(String string, String string2) {
            InputStream inputStream;
            int n = string2.lastIndexOf(47);
            String string3 = n >= 0 ? string2.substring(n + 1) : string2;
            if (string3 != null && string3.equals("rmi.dtd") && (inputStream = this.getClass().getClassLoader().getResourceAsStream("weblogic/rmi/internal/rmi.dtd")) != null) {
                return new InputSource(inputStream);
            }
            return null;
        }
    }
}

