/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal.wls;

import java.io.IOException;
import weblogic.kernel.QueueThrottleException;
import weblogic.rmi.RMILogger;
import weblogic.rmi.extensions.NotImplementedException;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.BasicServerRef;
import weblogic.rmi.internal.ReplyOnError;
import weblogic.rmi.spi.EndPoint;
import weblogic.rmi.spi.InboundRequest;
import weblogic.rmi.spi.InvokeHandler;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.work.ServerWorkAdapter;
import weblogic.work.WorkRejectedException;

public class WLSExecuteRequest
extends ServerWorkAdapter {
    private final BasicServerRef ref;
    protected final InboundRequest request;
    private final RuntimeMethodDescriptor md;
    private final InvokeHandler invoker;
    private final AuthenticatedSubject as;
    private boolean underExecution;

    public WLSExecuteRequest(BasicServerRef basicServerRef, InboundRequest inboundRequest, RuntimeMethodDescriptor runtimeMethodDescriptor, InvokeHandler invokeHandler, AuthenticatedSubject authenticatedSubject) {
        super(authenticatedSubject);
        this.ref = basicServerRef;
        this.as = authenticatedSubject;
        this.request = inboundRequest;
        this.md = runtimeMethodDescriptor;
        this.invoker = invokeHandler;
    }

    public String toString() {
        return this.ref.getImplementationClassName();
    }

    private boolean isAdminRequest() {
        return this.as != null && SubjectUtils.doesUserHaveAnyAdminRoles((AuthenticatedSubject)this.as);
    }

    public boolean isTransactional() {
        return this.request.getTxContext() != null;
    }

    public Runnable overloadAction(final String string) {
        if (this.ref.getObjectID() <= 256 || this.md.isOneway() || this.isTransactional()) {
            return null;
        }
        return new Runnable(){

            public void run() {
                try {
                    new ReplyOnError(WLSExecuteRequest.this.request, WLSExecuteRequest.this.request.getOutboundResponse(), (Throwable)new QueueThrottleException(string));
                }
                catch (IOException iOException) {
                    RMILogger.logException((String)"Unable to send error response to client", (Throwable)iOException);
                }
            }
        };
    }

    public Runnable cancel(final String string) {
        if (this.underExecution) {
            return this.disconnectEndPointTask();
        }
        if (this.isAdminRequest()) {
            return null;
        }
        return new Runnable(){

            public void run() {
                try {
                    new ReplyOnError(WLSExecuteRequest.this.request, WLSExecuteRequest.this.request.getOutboundResponse(), (Throwable)new WorkRejectedException(string));
                }
                catch (IOException iOException) {
                    RMILogger.logException((String)"Unable to send error response to client", (Throwable)iOException);
                }
            }
        };
    }

    private Runnable disconnectEndPointTask() {
        return new Runnable(){

            public void run() {
                try {
                    EndPoint endPoint = WLSExecuteRequest.this.request.getEndPoint();
                    if (endPoint != null) {
                        endPoint.disconnect();
                    }
                }
                catch (NotImplementedException notImplementedException) {
                    // empty catch block
                }
            }
        };
    }

    public void run() {
        this.underExecution = true;
        this.ref.handleRequest(this.request, this.invoker);
        this.underExecution = false;
    }
}

